/* dconf.c generated by valac 0.20.1, the Vala compiler
 * generated from dconf.vala, do not modify */

/*
 * Copyright © 2010, 2011 Codethink Limited
 * Copyright © 2011 Canonical Limited
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the licence, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Ryan Lortie <desrt@desrt.ca>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dconf.h>
#include <gio/gio.h>
#include <locale.h>
#include <stdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

#define TYPE_COMMAND_MAPPING (command_mapping_get_type ())
typedef struct _CommandMapping CommandMapping;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef void (*Command) (gchar** args, int args_length1, void* user_data, GError** error);
struct _CommandMapping {
	Command func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
	gchar* name;
};



void show_help (gboolean requested, const gchar* command);
void dconf_help (gchar** args, int args_length1, GError** error);
void dconf_read (gchar** args, int args_length1, GError** error);
void dconf_list (gchar** args, int args_length1, GError** error);
void dconf_write (gchar** args, int args_length1, GError** error);
void dconf_reset (gchar** args, int args_length1, GError** error);
void show_path (DConfClient* client, const gchar* path);
void watch_function (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag);
void dconf_watch (gchar** args, int args_length1, GError** error);
static void _watch_function_dconf_client_changed (DConfClient* _sender, const gchar* prefix, gchar** changes, const gchar* tag, gpointer self);
void dconf_blame (gchar** args, int args_length1, GError** error);
void dconf_complete (gchar** args, int args_length1, GError** error);
GType command_mapping_get_type (void) G_GNUC_CONST;
CommandMapping* command_mapping_dup (const CommandMapping* self);
void command_mapping_free (CommandMapping* self);
void command_mapping_copy (const CommandMapping* self, CommandMapping* dest);
void command_mapping_destroy (CommandMapping* self);
void command_mapping_init (CommandMapping *self, const gchar* name, Command func, void* func_target);
gint _vala_main (gchar** args, int args_length1);
static void _dconf_help_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_read_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_list_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_write_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_reset_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_update (gchar** args, int args_length1, GError** error);
static void _dconf_update_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_watch_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_dump (gchar** args, int args_length1, GError** error);
static void _dconf_dump_command (gchar** args, int args_length1, gpointer self, GError** error);
void dconf_load (gchar** args, int args_length1, GError** error);
static void _dconf_load_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_blame_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _dconf_complete_command (gchar** args, int args_length1, gpointer self, GError** error);
static void _vala_CommandMapping_array_free (CommandMapping* array, gint array_length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void show_help (gboolean requested, const gchar* command) {
	GString* _tmp0_;
	GString* str;
	gchar* description;
	gchar* synopsis;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	static GQuark _tmp3_label3 = 0;
	static GQuark _tmp3_label4 = 0;
	static GQuark _tmp3_label5 = 0;
	static GQuark _tmp3_label6 = 0;
	static GQuark _tmp3_label7 = 0;
	static GQuark _tmp3_label8 = 0;
	static GQuark _tmp3_label9 = 0;
	const gchar* _tmp25_;
	gboolean _tmp59_;
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	description = NULL;
	synopsis = NULL;
	_tmp1_ = command;
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("help")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_strdup ("Print help");
				_g_free0 (description);
				description = _tmp5_;
				_tmp6_ = g_strdup ("COMMAND");
				_g_free0 (synopsis);
				synopsis = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("read")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_strdup ("Read the value of a key");
				_g_free0 (description);
				description = _tmp7_;
				_tmp8_ = g_strdup ("KEY");
				_g_free0 (synopsis);
				synopsis = _tmp8_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label3) ? _tmp3_label3 : (_tmp3_label3 = g_quark_from_static_string ("list")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = g_strdup ("List the sub-keys and sub-dirs of a dir");
				_g_free0 (description);
				description = _tmp9_;
				_tmp10_ = g_strdup ("DIR");
				_g_free0 (synopsis);
				synopsis = _tmp10_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label4) ? _tmp3_label4 : (_tmp3_label4 = g_quark_from_static_string ("write")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = g_strdup ("Write a new value to a key");
				_g_free0 (description);
				description = _tmp11_;
				_tmp12_ = g_strdup ("KEY VALUE");
				_g_free0 (synopsis);
				synopsis = _tmp12_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label5) ? _tmp3_label5 : (_tmp3_label5 = g_quark_from_static_string ("reset")))) {
		switch (0) {
			default:
			{
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = g_strdup ("Reset a key or dir.  -f is required for dirs.");
				_g_free0 (description);
				description = _tmp13_;
				_tmp14_ = g_strdup ("[-f] PATH");
				_g_free0 (synopsis);
				synopsis = _tmp14_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label6) ? _tmp3_label6 : (_tmp3_label6 = g_quark_from_static_string ("update")))) {
		switch (0) {
			default:
			{
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = g_strdup ("Update the system dconf databases");
				_g_free0 (description);
				description = _tmp15_;
				_tmp16_ = g_strdup ("");
				_g_free0 (synopsis);
				synopsis = _tmp16_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label7) ? _tmp3_label7 : (_tmp3_label7 = g_quark_from_static_string ("watch")))) {
		switch (0) {
			default:
			{
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = g_strdup ("Watch a path for key changes");
				_g_free0 (description);
				description = _tmp17_;
				_tmp18_ = g_strdup ("PATH");
				_g_free0 (synopsis);
				synopsis = _tmp18_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label8) ? _tmp3_label8 : (_tmp3_label8 = g_quark_from_static_string ("dump")))) {
		switch (0) {
			default:
			{
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp19_ = g_strdup ("Dump an entire subpath to stdout");
				_g_free0 (description);
				description = _tmp19_;
				_tmp20_ = g_strdup ("DIR");
				_g_free0 (synopsis);
				synopsis = _tmp20_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label9) ? _tmp3_label9 : (_tmp3_label9 = g_quark_from_static_string ("load")))) {
		switch (0) {
			default:
			{
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp21_ = g_strdup ("Populate a subpath from stdin");
				_g_free0 (description);
				description = _tmp21_;
				_tmp22_ = g_strdup ("DIR");
				_g_free0 (synopsis);
				synopsis = _tmp22_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GString* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = str;
				_tmp24_ = command;
				g_string_append_printf (_tmp23_, "Unknown command '%s'\n\n", _tmp24_);
				command = NULL;
				break;
			}
		}
	}
	_tmp25_ = command;
	if (_tmp25_ == NULL) {
		GString* _tmp26_;
		_tmp26_ = str;
		g_string_append (_tmp26_, "Usage:\n" \
"  dconf COMMAND [ARGS...]\n" \
"\n" \
"Commands:\n" \
"  help              Show this information\n" \
"  read              Read the value of a key\n" \
"  list              List the contents of a dir\n" \
"  write             Change the value of a key\n" \
"  reset             Reset the value of a key or dir\n" \
"  update            Update the system databases\n" \
"  watch             Watch a path for changes\n" \
"  dump              Dump an entire subpath to stdout\n" \
"  load              Populate a subpath from stdin\n" \
"\n" \
"Use 'dconf help COMMAND' to get detailed help.\n" \
"\n");
	} else {
		GString* _tmp27_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GString* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		GString* _tmp58_;
		_tmp27_ = str;
		g_string_append (_tmp27_, "Usage:\n");
		_tmp28_ = str;
		_tmp29_ = command;
		_tmp30_ = synopsis;
		g_string_append_printf (_tmp28_, "  dconf %s %s\n\n", _tmp29_, _tmp30_);
		_tmp31_ = str;
		_tmp32_ = description;
		g_string_append_printf (_tmp31_, "%s\n\n", _tmp32_);
		_tmp33_ = synopsis;
		if (g_strcmp0 (_tmp33_, "") != 0) {
			GString* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
			const gchar* _tmp38_;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp41_ = FALSE;
			const gchar* _tmp42_;
			gboolean _tmp43_ = FALSE;
			gboolean _tmp46_;
			gboolean _tmp48_ = FALSE;
			const gchar* _tmp49_;
			gboolean _tmp50_ = FALSE;
			gboolean _tmp53_;
			const gchar* _tmp55_;
			gboolean _tmp56_ = FALSE;
			_tmp34_ = str;
			g_string_append (_tmp34_, "Arguments:\n");
			_tmp35_ = synopsis;
			_tmp36_ = string_contains (_tmp35_, "COMMAND");
			if (_tmp36_) {
				GString* _tmp37_;
				_tmp37_ = str;
				g_string_append (_tmp37_, "  COMMAND   The (optional) command to explain\n");
			}
			_tmp38_ = synopsis;
			_tmp39_ = string_contains (_tmp38_, "PATH");
			if (_tmp39_) {
				GString* _tmp40_;
				_tmp40_ = str;
				g_string_append (_tmp40_, "  PATH      Either a KEY or DIR\n");
			}
			_tmp42_ = synopsis;
			_tmp43_ = string_contains (_tmp42_, "PATH");
			if (_tmp43_) {
				_tmp41_ = TRUE;
			} else {
				const gchar* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp44_ = synopsis;
				_tmp45_ = string_contains (_tmp44_, "KEY");
				_tmp41_ = _tmp45_;
			}
			_tmp46_ = _tmp41_;
			if (_tmp46_) {
				GString* _tmp47_;
				_tmp47_ = str;
				g_string_append (_tmp47_, "  KEY       A key path (starting, but not ending with '/')\n");
			}
			_tmp49_ = synopsis;
			_tmp50_ = string_contains (_tmp49_, "PATH");
			if (_tmp50_) {
				_tmp48_ = TRUE;
			} else {
				const gchar* _tmp51_;
				gboolean _tmp52_ = FALSE;
				_tmp51_ = synopsis;
				_tmp52_ = string_contains (_tmp51_, "DIR");
				_tmp48_ = _tmp52_;
			}
			_tmp53_ = _tmp48_;
			if (_tmp53_) {
				GString* _tmp54_;
				_tmp54_ = str;
				g_string_append (_tmp54_, "  DIR       A directory path (starting and ending with '/')\n");
			}
			_tmp55_ = synopsis;
			_tmp56_ = string_contains (_tmp55_, "VALUE");
			if (_tmp56_) {
				GString* _tmp57_;
				_tmp57_ = str;
				g_string_append (_tmp57_, "  VALUE     The value to write (in GVariant format)\n");
			}
		}
		_tmp58_ = str;
		g_string_append (_tmp58_, "\n");
	}
	_tmp59_ = requested;
	if (_tmp59_) {
		GString* _tmp60_;
		const gchar* _tmp61_;
		_tmp60_ = str;
		_tmp61_ = _tmp60_->str;
		g_print ("%s", _tmp61_);
	} else {
		GString* _tmp62_;
		const gchar* _tmp63_;
		_tmp62_ = str;
		_tmp63_ = _tmp62_->str;
		g_printerr ("%s", _tmp63_);
	}
	_g_free0 (synopsis);
	_g_free0 (description);
	_g_string_free0 (str);
}


void dconf_help (gchar** args, int args_length1, GError** error) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = _tmp0_[2];
	show_help (TRUE, _tmp1_);
}


void dconf_read (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_;
	DConfClient* client;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* key;
	GVariant* _tmp4_ = NULL;
	GVariant* _result_;
	GVariant* _tmp5_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	key = _tmp3_;
	dconf_is_key (key, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp4_ = dconf_client_read (client, key);
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	if (_tmp5_ != NULL) {
		GVariant* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp6_ = _result_;
		_tmp7_ = g_variant_print (_tmp6_, TRUE);
		_tmp8_ = _tmp7_;
		g_print ("%s\n", _tmp8_);
		_g_free0 (_tmp8_);
	}
	_g_variant_unref0 (_result_);
	_g_free0 (key);
	_g_object_unref0 (client);
}


void dconf_list (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_;
	DConfClient* client;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* dir;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	dir = _tmp3_;
	dconf_is_dir (dir, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		_g_object_unref0 (client);
		return;
	}
	_tmp5_ = dconf_client_list (client, dir, &_tmp4_);
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp5_;
		item_collection_length1 = _tmp4_;
		for (item_it = 0; item_it < _tmp4_; item_it = item_it + 1) {
			gchar* _tmp6_;
			gchar* item = NULL;
			_tmp6_ = g_strdup (item_collection[item_it]);
			item = _tmp6_;
			{
				const gchar* _tmp7_;
				_tmp7_ = item;
				g_print ("%s\n", _tmp7_);
				_g_free0 (item);
			}
		}
		item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (dir);
	_g_object_unref0 (client);
}


void dconf_write (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_;
	DConfClient* client;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* key;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* val;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_;
	DConfClient* _tmp11_;
	const gchar* _tmp12_;
	GVariant* _tmp13_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	key = _tmp3_;
	_tmp4_ = args;
	_tmp4__length1 = args_length1;
	_tmp5_ = _tmp4_[3];
	_tmp6_ = g_strdup (_tmp5_);
	val = _tmp6_;
	_tmp7_ = key;
	dconf_is_key (_tmp7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp8_ = val;
	_tmp9_ = g_variant_parse (NULL, _tmp8_, NULL, NULL, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_tmp11_ = client;
	_tmp12_ = key;
	_tmp13_ = _tmp10_;
	dconf_client_write_sync (_tmp11_, _tmp12_, _tmp13_, NULL, NULL, &_inner_error_);
	_g_variant_unref0 (_tmp13_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (val);
		_g_free0 (key);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (val);
	_g_free0 (key);
	_g_object_unref0 (client);
}


void dconf_reset (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_;
	DConfClient* client;
	gboolean force;
	gint index;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* path;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp14_;
	DConfClient* _tmp16_;
	const gchar* _tmp17_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	force = FALSE;
	index = 2;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = index;
	_tmp3_ = _tmp1_[_tmp2_];
	if (g_strcmp0 (_tmp3_, "-f") == 0) {
		gint _tmp4_;
		force = TRUE;
		_tmp4_ = index;
		index = _tmp4_ + 1;
	}
	_tmp5_ = args;
	_tmp5__length1 = args_length1;
	_tmp6_ = index;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp8_ = g_strdup (_tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	dconf_is_path (_tmp9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_tmp11_ = path;
	_tmp12_ = dconf_is_dir (_tmp11_, NULL);
	if (_tmp12_) {
		gboolean _tmp13_;
		_tmp13_ = force;
		_tmp10_ = !_tmp13_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp14_ = _tmp10_;
	if (_tmp14_) {
		GError* _tmp15_;
		_tmp15_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "-f must be given to (recursively) reset entire dirs");
		_inner_error_ = _tmp15_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_tmp16_ = client;
	_tmp17_ = path;
	dconf_client_write_sync (_tmp16_, _tmp17_, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	_g_free0 (path);
	_g_object_unref0 (client);
}


void show_path (DConfClient* client, const gchar* path) {
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (client != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = dconf_is_key (_tmp0_, NULL);
	if (_tmp1_) {
		DConfClient* _tmp2_;
		const gchar* _tmp3_;
		GVariant* _tmp4_ = NULL;
		GVariant* value;
		gchar* _tmp5_ = NULL;
		GVariant* _tmp6_;
		const gchar* _tmp10_;
		_tmp2_ = client;
		_tmp3_ = path;
		_tmp4_ = dconf_client_read (_tmp2_, _tmp3_);
		value = _tmp4_;
		_tmp6_ = value;
		if (_tmp6_ != NULL) {
			GVariant* _tmp7_;
			gchar* _tmp8_ = NULL;
			_tmp7_ = value;
			_tmp8_ = g_variant_print (_tmp7_, TRUE);
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp8_;
		} else {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("unset");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp9_;
		}
		_tmp10_ = _tmp5_;
		g_print ("  %s\n", _tmp10_);
		_g_free0 (_tmp5_);
		_g_variant_unref0 (value);
	}
}


void watch_function (DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (client != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = items;
	_tmp0__length1 = items_length1;
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			gchar* _tmp1_;
			gchar* item = NULL;
			_tmp1_ = g_strdup (item_collection[item_it]);
			item = _tmp1_;
			{
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* full;
				const gchar* _tmp5_;
				DConfClient* _tmp6_;
				const gchar* _tmp7_;
				_tmp2_ = path;
				_tmp3_ = item;
				_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
				full = _tmp4_;
				_tmp5_ = full;
				g_print ("%s\n", _tmp5_);
				_tmp6_ = client;
				_tmp7_ = full;
				show_path (_tmp6_, _tmp7_);
				_g_free0 (full);
				_g_free0 (item);
			}
		}
	}
	g_print ("\n");
}


static void _watch_function_dconf_client_changed (DConfClient* _sender, const gchar* prefix, gchar** changes, const gchar* tag, gpointer self) {
	watch_function (_sender, prefix, changes, _vala_array_length (changes), tag);
}


void dconf_watch (gchar** args, int args_length1, GError** error) {
	DConfClient* _tmp0_;
	DConfClient* client;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* path;
	GMainLoop* _tmp4_;
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
	_tmp0_ = dconf_client_new ();
	client = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[2];
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	dconf_is_path (path, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (path);
		_g_object_unref0 (client);
		return;
	}
	g_signal_connect (client, "changed", (GCallback) _watch_function_dconf_client_changed, NULL);
	dconf_client_watch_sync (client, path);
	_tmp4_ = g_main_loop_new (NULL, FALSE);
	_tmp5_ = _tmp4_;
	g_main_loop_run (_tmp5_);
	_g_main_loop_unref0 (_tmp5_);
	_g_free0 (path);
	_g_object_unref0 (client);
}


void dconf_blame (gchar** args, int args_length1, GError** error) {
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* connection;
	GDBusConnection* _tmp1_;
	GVariantType* _tmp2_;
	GVariantType* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_;
	GVariant* reply;
	GVariant* _tmp6_;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	connection = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = connection;
	_tmp2_ = g_variant_type_new ("(s)");
	_tmp3_ = _tmp2_;
	_tmp4_ = g_dbus_connection_call_sync (_tmp1_, "ca.desrt.dconf", "/ca/desrt/dconf", "ca.desrt.dconf.ServiceInfo", "Blame", NULL, _tmp3_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_variant_type_free0 (_tmp3_);
	reply = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (connection);
		return;
	}
	_tmp6_ = reply;
	_tmp7_ = g_variant_get_child_value (_tmp6_, (gsize) 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_get_string (_tmp8_, NULL);
	g_print ("%s", _tmp9_);
	_g_variant_unref0 (_tmp8_);
	_g_variant_unref0 (reply);
	_g_object_unref0 (connection);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void dconf_complete (gchar** args, int args_length1, GError** error) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* suffix;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* path;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar _tmp8_ = '\0';
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = _tmp0_[2];
	_tmp2_ = g_strdup (_tmp1_);
	suffix = _tmp2_;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = _tmp3_[3];
	_tmp5_ = g_strdup (_tmp4_);
	path = _tmp5_;
	_tmp6_ = path;
	if (g_strcmp0 (_tmp6_, "") == 0) {
		g_print ("/\n");
		_g_free0 (path);
		_g_free0 (suffix);
		return;
	}
	_tmp7_ = path;
	_tmp8_ = string_get (_tmp7_, (glong) 0);
	if (_tmp8_ == '/') {
		DConfClient* _tmp9_;
		DConfClient* client;
		gint last;
		const gchar* _tmp20_;
		gint _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* dir;
		DConfClient* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_ = 0;
		gchar** _tmp26_ = NULL;
		_tmp9_ = dconf_client_new ();
		client = _tmp9_;
		last = 0;
		{
			gint i;
			i = 1;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					gboolean _tmp11_;
					const gchar* _tmp13_;
					gint _tmp14_;
					gchar _tmp15_ = '\0';
					const gchar* _tmp16_;
					gint _tmp17_;
					gchar _tmp18_ = '\0';
					_tmp11_ = _tmp10_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp13_ = path;
					_tmp14_ = i;
					_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
					if (!(_tmp15_ != '\0')) {
						break;
					}
					_tmp16_ = path;
					_tmp17_ = i;
					_tmp18_ = string_get (_tmp16_, (glong) _tmp17_);
					if (_tmp18_ == '/') {
						gint _tmp19_;
						_tmp19_ = i;
						last = _tmp19_;
					}
				}
			}
		}
		_tmp20_ = path;
		_tmp21_ = last;
		_tmp22_ = string_substring (_tmp20_, (glong) 0, (glong) (_tmp21_ + 1));
		dir = _tmp22_;
		_tmp23_ = client;
		_tmp24_ = dir;
		_tmp26_ = dconf_client_list (_tmp23_, _tmp24_, &_tmp25_);
		{
			gchar** item_collection = NULL;
			gint item_collection_length1 = 0;
			gint _item_collection_size_ = 0;
			gint item_it = 0;
			item_collection = _tmp26_;
			item_collection_length1 = _tmp25_;
			for (item_it = 0; item_it < _tmp25_; item_it = item_it + 1) {
				gchar* _tmp27_;
				gchar* item = NULL;
				_tmp27_ = g_strdup (item_collection[item_it]);
				item = _tmp27_;
				{
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* full_item;
					gboolean _tmp31_ = FALSE;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gboolean _tmp34_ = FALSE;
					gboolean _tmp38_;
					_tmp28_ = dir;
					_tmp29_ = item;
					_tmp30_ = g_strconcat (_tmp28_, _tmp29_, NULL);
					full_item = _tmp30_;
					_tmp32_ = full_item;
					_tmp33_ = path;
					_tmp34_ = g_str_has_prefix (_tmp32_, _tmp33_);
					if (_tmp34_) {
						const gchar* _tmp35_;
						const gchar* _tmp36_;
						gboolean _tmp37_ = FALSE;
						_tmp35_ = item;
						_tmp36_ = suffix;
						_tmp37_ = g_str_has_suffix (_tmp35_, _tmp36_);
						_tmp31_ = _tmp37_;
					} else {
						_tmp31_ = FALSE;
					}
					_tmp38_ = _tmp31_;
					if (_tmp38_) {
						const gchar* _tmp39_ = NULL;
						const gchar* _tmp40_;
						gboolean _tmp41_ = FALSE;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
						_tmp40_ = full_item;
						_tmp41_ = g_str_has_suffix (_tmp40_, "/");
						if (_tmp41_) {
							_tmp39_ = "";
						} else {
							_tmp39_ = " ";
						}
						_tmp42_ = full_item;
						_tmp43_ = _tmp39_;
						g_print ("%s%s\n", _tmp42_, _tmp43_);
					}
					_g_free0 (full_item);
					_g_free0 (item);
				}
			}
			item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (dir);
		_g_object_unref0 (client);
	}
	_g_free0 (path);
	_g_free0 (suffix);
}


void command_mapping_init (CommandMapping *self, const gchar* name, Command func, void* func_target) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	Command _tmp2_;
	void* _tmp2__target;
	g_return_if_fail (name != NULL);
	memset (self, 0, sizeof (CommandMapping));
	_tmp0_ = name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*self).name);
	(*self).name = _tmp1_;
	_tmp2_ = func;
	_tmp2__target = func_target;
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	(*self).func = _tmp2_;
	(*self).func_target = _tmp2__target;
	(*self).func_target_destroy_notify = NULL;
}


void command_mapping_copy (const CommandMapping* self, CommandMapping* dest) {
	Command _tmp0_;
	void* _tmp0__target;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = (*self).func;
	_tmp0__target = (*self).func_target;
	((*dest).func_target_destroy_notify == NULL) ? NULL : ((*dest).func_target_destroy_notify ((*dest).func_target), NULL);
	(*dest).func = NULL;
	(*dest).func_target = NULL;
	(*dest).func_target_destroy_notify = NULL;
	(*dest).func = _tmp0_;
	(*dest).func_target = _tmp0__target;
	(*dest).func_target_destroy_notify = NULL;
	_tmp1_ = (*self).name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp2_;
}


void command_mapping_destroy (CommandMapping* self) {
	((*self).func_target_destroy_notify == NULL) ? NULL : ((*self).func_target_destroy_notify ((*self).func_target), NULL);
	(*self).func = NULL;
	(*self).func_target = NULL;
	(*self).func_target_destroy_notify = NULL;
	_g_free0 ((*self).name);
}


CommandMapping* command_mapping_dup (const CommandMapping* self) {
	CommandMapping* dup;
	dup = g_new0 (CommandMapping, 1);
	command_mapping_copy (self, dup);
	return dup;
}


void command_mapping_free (CommandMapping* self) {
	command_mapping_destroy (self);
	g_free (self);
}


GType command_mapping_get_type (void) {
	static volatile gsize command_mapping_type_id__volatile = 0;
	if (g_once_init_enter (&command_mapping_type_id__volatile)) {
		GType command_mapping_type_id;
		command_mapping_type_id = g_boxed_type_register_static ("CommandMapping", (GBoxedCopyFunc) command_mapping_dup, (GBoxedFreeFunc) command_mapping_free);
		g_once_init_leave (&command_mapping_type_id__volatile, command_mapping_type_id);
	}
	return command_mapping_type_id__volatile;
}


static void _dconf_help_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_help (args, args_length1, error);
}


static void _dconf_read_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_read (args, args_length1, error);
}


static void _dconf_list_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_list (args, args_length1, error);
}


static void _dconf_write_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_write (args, args_length1, error);
}


static void _dconf_reset_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_reset (args, args_length1, error);
}


static void _dconf_update_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_update (args, args_length1, error);
}


static void _dconf_watch_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_watch (args, args_length1, error);
}


static void _dconf_dump_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_dump (args, args_length1, error);
}


static void _dconf_load_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_load (args, args_length1, error);
}


static void _dconf_blame_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_blame (args, args_length1, error);
}


static void _dconf_complete_command (gchar** args, int args_length1, gpointer self, GError** error) {
	dconf_complete (args, args_length1, error);
}


static void _vala_CommandMapping_array_free (CommandMapping* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			command_mapping_destroy (&array[i]);
		}
	}
	g_free (array);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	CommandMapping _tmp3_ = {0};
	CommandMapping _tmp4_ = {0};
	CommandMapping _tmp5_ = {0};
	CommandMapping _tmp6_ = {0};
	CommandMapping _tmp7_ = {0};
	CommandMapping _tmp8_ = {0};
	CommandMapping _tmp9_ = {0};
	CommandMapping _tmp10_ = {0};
	CommandMapping _tmp11_ = {0};
	CommandMapping _tmp12_ = {0};
	CommandMapping _tmp13_ = {0};
	CommandMapping* _tmp14_ = NULL;
	CommandMapping* map;
	gint map_length1;
	gint _map_size_;
	GError * _inner_error_ = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_vala_assert (_tmp0__length1 != 0, "args.length != 0");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	g_set_prgname (_tmp2_);
	setlocale (LC_ALL, "");
	command_mapping_init (&_tmp3_, "help", _dconf_help_command, NULL);
	command_mapping_init (&_tmp4_, "read", _dconf_read_command, NULL);
	command_mapping_init (&_tmp5_, "list", _dconf_list_command, NULL);
	command_mapping_init (&_tmp6_, "write", _dconf_write_command, NULL);
	command_mapping_init (&_tmp7_, "reset", _dconf_reset_command, NULL);
	command_mapping_init (&_tmp8_, "update", _dconf_update_command, NULL);
	command_mapping_init (&_tmp9_, "watch", _dconf_watch_command, NULL);
	command_mapping_init (&_tmp10_, "dump", _dconf_dump_command, NULL);
	command_mapping_init (&_tmp11_, "load", _dconf_load_command, NULL);
	command_mapping_init (&_tmp12_, "blame", _dconf_blame_command, NULL);
	command_mapping_init (&_tmp13_, "_complete", _dconf_complete_command, NULL);
	_tmp14_ = g_new0 (CommandMapping, 11);
	_tmp14_[0] = _tmp3_;
	_tmp14_[1] = _tmp4_;
	_tmp14_[2] = _tmp5_;
	_tmp14_[3] = _tmp6_;
	_tmp14_[4] = _tmp7_;
	_tmp14_[5] = _tmp8_;
	_tmp14_[6] = _tmp9_;
	_tmp14_[7] = _tmp10_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	map = _tmp14_;
	map_length1 = 11;
	_map_size_ = map_length1;
	{
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		CommandMapping* _tmp18_;
		gint _tmp18__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		const gchar* _tmp28_;
		GError* _tmp29_;
		_tmp15_ = args;
		_tmp15__length1 = args_length1;
		_tmp16_ = _tmp15_[1];
		if (_tmp16_ == NULL) {
			GError* _tmp17_;
			_tmp17_ = g_error_new_literal (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "no command specified");
			_inner_error_ = _tmp17_;
			goto __catch7_g_error;
		}
		_tmp18_ = map;
		_tmp18__length1 = map_length1;
		{
			CommandMapping* mapping_collection = NULL;
			gint mapping_collection_length1 = 0;
			gint _mapping_collection_size_ = 0;
			gint mapping_it = 0;
			mapping_collection = _tmp18_;
			mapping_collection_length1 = _tmp18__length1;
			for (mapping_it = 0; mapping_it < _tmp18__length1; mapping_it = mapping_it + 1) {
				CommandMapping _tmp19_ = {0};
				CommandMapping mapping = {0};
				command_mapping_copy (&mapping_collection[mapping_it], &_tmp19_);
				mapping = _tmp19_;
				{
					CommandMapping _tmp20_;
					const gchar* _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					_tmp20_ = mapping;
					_tmp21_ = _tmp20_.name;
					_tmp22_ = args;
					_tmp22__length1 = args_length1;
					_tmp23_ = _tmp22_[1];
					if (g_strcmp0 (_tmp21_, _tmp23_) == 0) {
						CommandMapping _tmp24_;
						Command _tmp25_;
						void* _tmp25__target;
						gchar** _tmp26_;
						gint _tmp26__length1;
						_tmp24_ = mapping;
						_tmp25_ = _tmp24_.func;
						_tmp25__target = _tmp24_.func_target;
						_tmp26_ = args;
						_tmp26__length1 = args_length1;
						_tmp25_ (_tmp26_, _tmp26__length1, _tmp25__target, &_inner_error_);
						if (_inner_error_ != NULL) {
							command_mapping_destroy (&mapping);
							goto __catch7_g_error;
						}
						result = 0;
						command_mapping_destroy (&mapping);
						map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
						return result;
					}
					command_mapping_destroy (&mapping);
				}
			}
		}
		_tmp27_ = args;
		_tmp27__length1 = args_length1;
		_tmp28_ = _tmp27_[1];
		_tmp29_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "unknown command %s", _tmp28_);
		_inner_error_ = _tmp29_;
		goto __catch7_g_error;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		FILE* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		const gchar* _tmp34_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = stderr;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		fprintf (_tmp30_, "error: %s\n\n", _tmp32_);
		_tmp33_ = args;
		_tmp33__length1 = args_length1;
		_tmp34_ = _tmp33_[1];
		show_help (FALSE, _tmp34_);
		result = 1;
		_g_error_free0 (e);
		map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
		return result;
	}
	__finally7:
	map = (_vala_CommandMapping_array_free (map, map_length1), NULL);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



