#
# Wrapper implementation of TRY_RUN(), with some support for
# cross-compiling
#
# Usage and syntax is equivalent to CMake's TRY_RUN().
#

# CMakeParseArguments was introduced in CMake 2.8.3.
# DCMTK_TRY_RUN will revert to CMake's internal TRY_RUN()
# for versions prior to 2.8.3, as arguments can't be parsed
# in that case. This means cross compiling support will be
# disabled for CMake versions prior to 2.8.3.
IF(CMAKE_VERSION VERSION_LESS 2.8.3)

MACRO(DCMTK_TRY_RUN)
    TRY_RUN(${ARGN})
ENDMACRO(DCMTK_TRY_RUN)

ELSE(CMAKE_VERSION VERSION_LESS 2.8.3)

INCLUDE(CMakeParseArguments)

FUNCTION(DCMTK_TRY_RUN_CROSS RUN_RESULT_VAR COMPILE_RESULT_VAR bindir srcfile)
    CMAKE_PARSE_ARGUMENTS(DCMTK_TRY_RUN
            ""
            "COMPILE_OUTPUT_VARIABLE;RUN_OUTPUT_VARIABLE;OUTPUT_VARIABLE"
            "CMAKE_FLAGS;COMPILE_DEFINITIONS;ARGS"
            ${ARGN}
    )
    GET_FILENAME_COMPONENT(OUTPUT_EXECUTABLE_NAME ${srcfile} NAME)
    SET(OUTPUT_EXECUTABLE_NAME ${OUTPUT_EXECUTABLE_NAME}${CMAKE_EXECUTABLE_SUFFIX})
    SET(OUTPUT_EXECUTABLE ${bindir}/${OUTPUT_EXECUTABLE_NAME})
    SET(TRY_COMPILE_ARGS ${COMPILE_RESULT_VAR} ${bindir} ${srcfile})
    IF(DCMTK_TRY_RUN_CMAKE_FLAGS)
        LIST(APPEND TRY_COMPILE_ARGS CMAKE_FLAGS ${DCMTK_TRY_RUN_CMAKE_FLAGS} ${DCMTK_TRY_COMPILE_REQUIRED_CMAKE_FLAGS})
    ELSEIF(DCMTK_TRY_COMPILE_REQUIRED_CMAKE_FLAGS)
        LIST(APPEND TRY_COMPILE_ARGS CMAKE_FLAGS ${DCMTK_TRY_COMPILE_REQUIRED_CMAKE_FLAGS})
    ENDIF()
    IF(DCMTK_TRY_RUN_COMPILE_DEFINITIONS)
        LIST(APPEND TRY_COMPILE_ARGS COMPILE_DEFINITIONS ${DCMTK_TRY_RUN_COMPILE_DEFINITIONS})
    ENDIF()
    IF(DCMTK_TRY_RUN_COMPILE_OUTPUT_VARIABLE)
        LIST(APPEND TRY_COMPILE_ARGS OUTPUT_VARIABLE ${DCMTK_TRY_RUN_COMPILE_OUTPUT_VARIABLE})
    ENDIF()
    TRY_COMPILE(${TRY_COMPILE_ARGS} COPY_FILE ${OUTPUT_EXECUTABLE})
    SET(${COMPILE_RESULT_VAR} ${${COMPILE_RESULT_VAR}} PARENT_SCOPE)
    IF(DCMTK_TRY_RUN_COMPILE_OUTPUT_VARIABLE)
        SET(${DCMTK_TRY_RUN_COMPILE_OUTPUT_VARIABLE} ${${DCMTK_TRY_RUN_COMPILE_OUTPUT_VARIABLE}} PARENT_SCOPE)
    ENDIF()
    IF(${COMPILE_RESULT_VAR})
        IF(WIN32)
            WINE_COMMAND(CMD ${OUTPUT_EXECUTABLE} ${DCMTK_TRY_RUN_ARGS})
            IF(CMD)
                EXECUTE_PROCESS(
                    COMMAND ${CMD}
                    RESULT_VARIABLE ${RUN_RESULT_VAR}
                    OUTPUT_VARIABLE ${DCMTK_TRY_RUN_RUN_OUTPUT_VARIABLE}
                    ERROR_VARIABLE ${DCMTK_TRY_RUN_RUN_OUTPUT_VARIABLE}
                )
            ENDIF()
        ELSEIF(ANDROID)
            DCMTK_ANDROID_WAIT_FOR_EMULATOR(DCMTK_ANDROID_EMULATOR_INSTANCE)
            IF(NOT DCMTK_TRY_RUN_ANDROID_RUNTIME_INSTALLED)
                DCMTK_ANDROID_FIND_RUNTIME_LIBRARIES(ANDROID_RUNTIME_LIBRARIES)
                SET(ANDROID_RUNTIME_LIBRARIES ${ANDROID_RUNTIME_LIBRARIES} CACHE INTERNAL "")
                DCMTK_ANDROID_PUSH(DCMTK_ANDROID_EMULATOR_INSTANCE ${ANDROID_RUNTIME_LIBRARIES} DESTINATION ${ANDROID_TEMPORARY_FILES_LOCATION})
                SET(DCMTK_TRY_RUN_ANDROID_RUNTIME_INSTALLED TRUE CACHE INTERNAL "")
            ENDIF()
            DCMTK_ANDROID_PUSH(DCMTK_ANDROID_EMULATOR_INSTANCE ${OUTPUT_EXECUTABLE} DESTINATION ${ANDROID_TEMPORARY_FILES_LOCATION}/${OUTPUT_EXECUTABLE_NAME})
            DCMTK_ANDROID_SHELL(DCMTK_ANDROID_EMULATOR_INSTANCE
                COMMAND chmod 755 ${ANDROID_TEMPORARY_FILES_LOCATION}/${OUTPUT_EXECUTABLE_NAME}
                OUTPUT_QUIET
                ERROR_QUIET
            )
            DCMTK_ANDROID_SHELL(DCMTK_ANDROID_EMULATOR_INSTANCE
                COMMAND "LD_LIBRARY_PATH=\$LD_LIBRARY_PATH:${ANDROID_TEMPORARY_FILES_LOCATION}" ${ANDROID_TEMPORARY_FILES_LOCATION}/${OUTPUT_EXECUTABLE_NAME} ${DCMTK_TRY_RUN_ARGS}
                RESULT_VARIABLE ${RUN_RESULT_VAR}
                OUTPUT_VARIABLE ${DCMTK_TRY_RUN_RUN_OUTPUT_VARIABLE}
                ERROR_VARIABLE ${DCMTK_TRY_RUN_RUN_OUTPUT_VARIABLE}
            )
        ELSE()
            MESSAGE(WARNING "Emulation for your target platform is not available, please fill in the required configure test results manually.")
            TRY_RUN(${RUN_RESULT_VAR} ${COMPILE_RESULT_VAR} ${bindir} ${srcfile} ${ARGN})
            RETURN()
        ENDIF()
        SET(${RUN_RESULT_VAR} ${${RUN_RESULT_VAR}} PARENT_SCOPE)
        SET(${DCMTK_TRY_RUN_RUN_OUTPUT_VARIABLE} ${${DCMTK_TRY_RUN_RUN_OUTPUT_VARIABLE}} PARENT_SCOPE)
    ENDIF()
ENDFUNCTION(DCMTK_TRY_RUN_CROSS)

MACRO(DCMTK_TRY_RUN)
    IF(CMAKE_CROSSCOMPILING)
        DCMTK_TRY_RUN_CROSS(${ARGN})
    ELSE(CMAKE_CROSSCOMPILING)
        TRY_RUN(${ARGN})
    ENDIF(CMAKE_CROSSCOMPILING)
ENDMACRO(DCMTK_TRY_RUN)

ENDIF(CMAKE_VERSION VERSION_LESS 2.8.3)
