-- Copyright (c) DbVis Software AB. All Rights Reserved.
SELECT 
    CUST.FIRST_NAME, 
    CUST.LAST_NAME, 
    SUM(PAY.AMOUNT) AS TOTAL
    
FROM 
    PAYMENT PAY
JOIN 
    CUSTOMER CUST
ON 
    PAY.CUSTOMER_ID = CUST.CUSTOMER_ID
GROUP BY 
    CUST.FIRST_NAME, 
    CUST.LAST_NAME
ORDER BY 
    CUST.LAST_NAME;