/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.GSSPrivilegedAction;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.sql.SQLException;
import java.util.Set;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GSSAuthentication {
    public static void authenticate(EXAConnection eXAConnection, boolean bl) throws IOException, SQLException {
        Exception exception = null;
        try {
            Subject subject = Subject.getSubject(AccessController.getContext());
            GSSCredential gSSCredential = GSSAuthentication.getCredentials(eXAConnection, subject);
            GSSPrivilegedAction gSSPrivilegedAction = new GSSPrivilegedAction(eXAConnection, gSSCredential, bl);
            exception = Subject.doAs(subject, gSSPrivilegedAction);
        }
        catch (Exception exception2) {
            eXAConnection.logStackTrace(exception2);
            throw new SQLException(exception2.getMessage(), exception2);
        }
        if (exception instanceof IOException) {
            eXAConnection.logStackTrace(exception);
            throw (IOException)exception;
        }
        if (exception instanceof SQLException) {
            eXAConnection.logStackTrace(exception);
            throw (SQLException)exception;
        }
        if (exception != null) {
            throw new SQLException("Kerberos authentication failed: " + exception.getMessage(), "HY000", exception);
        }
    }

    private static GSSCredential getCredentials(EXAConnection eXAConnection, Subject subject) throws GSSException {
        if (subject == null) {
            eXAConnection.log("No subject found in context");
            return null;
        }
        eXAConnection.log("Found subject with " + subject.getPrincipals().size() + " principals(s) in context:");
        for (Principal object2 : subject.getPrincipals()) {
            eXAConnection.log("  - '" + object2.getName() + "'");
        }
        Set<GSSCredential> set = subject.getPrivateCredentials(GSSCredential.class);
        if (set == null || set.size() <= 0) {
            eXAConnection.log("No private credentials found for subject");
            return null;
        }
        GSSCredential gSSCredential = (GSSCredential)set.iterator().next();
        eXAConnection.log("Found " + set.size() + " private credential(s), using first credentials for '" + gSSCredential.getName() + "'");
        return gSSCredential;
    }
}

