/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.EXAURLParser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class EXASocketFactory
extends SocketFactory {
    private final String disableTLSChecksKeyword = "NOCERTCHECK";
    private String serverFingerprint = null;

    public abstract Socket createCustomSocket(InetAddress var1, int var2, int var3) throws IOException;

    public Socket createSSLSocket(Socket socket, Properties properties, KeyStore keyStore, String string, int n, String string2, String string3, boolean bl) throws IOException {
        try {
            if (string3 != null && "NOCERTCHECK".toUpperCase().equals(string3.toUpperCase())) {
                string3 = null;
                bl = false;
            }
            SSLContext sSLContext = SSLContext.getInstance(string2);
            TrustManager[] trustManagerArray = this.TrustManagerCallback(keyStore, string3, bl);
            sSLContext.init(null, trustManagerArray, null);
            SSLSocket sSLSocket = (SSLSocket)sSLContext.getSocketFactory().createSocket(socket, string, n, true);
            SSLParameters sSLParameters = new SSLParameters();
            if (bl && string3 == null) {
                sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
            }
            sSLSocket.setSSLParameters(sSLParameters);
            return sSLSocket;
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new IOException(generalSecurityException.getMessage());
        }
    }

    public Socket createSSLSocket(Properties properties, KeyStore keyStore, InetAddress inetAddress, int n, String string, String string2, String string3, boolean bl, int n2) throws IOException {
        try {
            if (string3 != null && "NOCERTCHECK".toUpperCase().equals(string3.toUpperCase())) {
                string3 = null;
                bl = false;
            }
            SSLContext sSLContext = SSLContext.getInstance(string);
            TrustManager[] trustManagerArray = this.TrustManagerCallback(keyStore, string3, bl);
            sSLContext.init(null, trustManagerArray, null);
            SSLSocket sSLSocket = (SSLSocket)sSLContext.getSocketFactory().createSocket();
            SSLParameters sSLParameters = new SSLParameters();
            sSLParameters.setProtocols(new String[]{string2});
            if (bl && string3 == null) {
                sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
            }
            sSLSocket.setSSLParameters(sSLParameters);
            sSLSocket.connect(new InetSocketAddress(inetAddress, n), n2);
            if (bl && string3 == null) {
                this.TestConnection(sSLSocket, properties, inetAddress.getHostName());
            }
            return sSLSocket;
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new IOException(generalSecurityException.getMessage());
        }
    }

    public Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException("createSocket: connect timeout cannot be negative: " + n2);
        }
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(inetAddress, n), n2);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(InetAddress.getByName(string), n, 0);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, 0);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    private String CertificateToHash(X509Certificate x509Certificate) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = messageDigest.digest(x509Certificate.getEncoded());
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                String string = Integer.toHexString(0xFF & byArray[i]);
                if (string.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            throw new IOException("[ERROR] Fingerprint could not be obtained from the certificate.");
        }
    }

    private void TestConnection(SSLSocket sSLSocket, Properties properties, String string) throws IOException {
        try {
            sSLSocket.startHandshake();
        }
        catch (Exception exception) {
            if (this.serverFingerprint != null) {
                String string2 = ".";
                if (exception.getLocalizedMessage().endsWith(".")) {
                    string2 = "";
                }
                String string3 = null;
                if (properties != null) {
                    string3 = properties.getProperty("url");
                    HashMap<String, String> hashMap = EXAURLParser.extractURL(string3);
                    if (hashMap == null) {
                        string3 = null;
                    } else {
                        String string4 = hashMap.get("DefaultPort");
                        string3 = hashMap.get("URL") + (string4.length() > 0 ? ":" + string4 : "");
                        if (string3.startsWith("//")) {
                            string3 = string3 + ";fingerprint=" + this.serverFingerprint;
                        } else {
                            String string5 = string3.split(":|,|/|$")[0];
                            string3 = string3.replaceFirst(string5 + "/*", string5 + "/" + this.serverFingerprint);
                        }
                    }
                }
                if (string3 != null) {
                    throw new IOException("TLS connection to host (" + string + ") failed: " + exception.getLocalizedMessage() + string2 + " If you trust the server, you can include the fingerprint in " + "the connection string: " + string3 + ". ");
                }
                throw new IOException("TLS connection to host (" + string + ") failed: " + exception.getLocalizedMessage() + string2);
            }
            throw new IOException("TLS connection to host (" + string + ") failed: " + exception.getLocalizedMessage());
        }
    }

    private TrustManager[] TrustManagerCallback(final KeyStore keyStore, final String string, boolean bl) {
        TrustManager[] trustManagerArray = null;
        trustManagerArray = string == null && !bl ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }} : (string != null ? new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) throws CertificateException {
                if (x509CertificateArray.length > 0) {
                    try {
                        EXASocketFactory.this.serverFingerprint = EXASocketFactory.this.CertificateToHash(x509CertificateArray[0]);
                    }
                    catch (IOException iOException) {
                        throw new CertificateException(iOException.getMessage());
                    }
                    if (string.compareToIgnoreCase(EXASocketFactory.this.serverFingerprint) != 0) {
                        throw new CertificateException("[ERROR] Fingerprint did not match. The fingerprint provided: " + string.toUpperCase() + ". Server's certificate fingerprint: " + EXASocketFactory.this.serverFingerprint.toUpperCase() + ". ");
                    }
                } else {
                    throw new CertificateException("[ERROR] Certificate was not received from the server.");
                }
            }
        }} : new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                if (x509CertificateArray.length > 0) {
                    try {
                        EXASocketFactory.this.serverFingerprint = EXASocketFactory.this.CertificateToHash(x509CertificateArray[0]);
                        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        trustManagerFactory.init(keyStore);
                        X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
                        x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                        x509CertificateArray[0].checkValidity();
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        throw certificateExpiredException;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        throw certificateNotYetValidException;
                    }
                    catch (Exception exception) {
                        throw new CertificateException(exception.getMessage());
                    }
                } else {
                    throw new CertificateException("[ERROR] Certificate was not received from the server.");
                }
            }
        }});
        return trustManagerArray;
    }
}

