/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAURLParser;
import com.exasol.jdbc.ParserResult;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EXADriver
implements Driver {
    private static final String DRIVER_NAME = "EXASolution JDBC Driver";
    public static final int DEFAULT_CONNECTION_POOL_SIZE = 64;
    public static final int MAX_CONNECTION_POOL_SIZE = 8192;
    public static int connectionPoolSize = 64;
    private static Map versionInfo = null;
    private DebugLog debug = null;
    private static EXADriver registeredDriver;

    public static void main(String[] stringArray) throws Exception {
        System.out.println("Exasol JDBC driver, version " + EXADriver.getEXADriverMajorVersion() + "." + EXADriver.getEXADriverMinorVersion() + "." + EXADriver.getEXADriverVersionInc());
        System.out.println("Build for JRE 6 or higher");
    }

    public static void debugError(String string, Throwable throwable, DebugLog debugLog) {
        String string2 = "JDBC Exception - " + string;
        if (null == debugLog || null == throwable) {
            return;
        }
        if (null != string) {
            debugLog.log(string2);
        }
        if (null != throwable) {
            StackTraceElement[] stackTraceElementArray;
            StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
            if (null != stackTraceElementArray2 && stackTraceElementArray2.length > 0) {
                debugLog.log(throwable.getClass() + ": " + throwable.getMessage());
                stackTraceElementArray = stackTraceElementArray2;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    debugLog.log("    at " + stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')');
                }
            }
            for (stackTraceElementArray = throwable.getCause(); null != stackTraceElementArray; stackTraceElementArray = stackTraceElementArray.getCause()) {
                StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray.getStackTrace();
                if (null == stackTraceElementArray3 || stackTraceElementArray3.length <= 0) continue;
                debugLog.log("Caused by:");
                debugLog.log(stackTraceElementArray.getClass() + ": " + stackTraceElementArray.getMessage());
                for (StackTraceElement stackTraceElement : stackTraceElementArray3) {
                    debugLog.log("    at " + stackTraceElement.getClassName() + '.' + stackTraceElement.getMethodName() + '(' + stackTraceElement.getFileName() + ':' + stackTraceElement.getLineNumber() + ')');
                }
            }
        }
    }

    @Override
    public boolean acceptsURL(String string) {
        return string.startsWith("jdbc:exa:") || string.startsWith("jdbc:exa-debug:") || string.startsWith("exa:") || string.startsWith("exa-debug:") || string.startsWith("jdbc:exa-worker:") || string.startsWith("jdbc:exa-worker-debug:") || string.startsWith("exa-worker:") || string.startsWith("exa-worker-debug:");
    }

    public static void register() throws SQLException {
        if (EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        EXADriver eXADriver = new EXADriver();
        DriverManager.registerDriver(eXADriver);
        registeredDriver = eXADriver;
    }

    public static void deregister() throws SQLException {
        if (!EXADriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using EXADriver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        Vector vector = null;
        if (null == string) {
            throw new SQLException(Translator.Driver_URL_can_t_be_null());
        }
        if (0 == string.length()) {
            throw new SQLException(Translator.Driver_URL_can_t_be_an_empty_string());
        }
        EXAConnection eXAConnection = null;
        try {
            ParserResult parserResult = this.parseURL8(string);
            if (parserResult != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(parserResult.params.getProperty("connectionPoolSize"));
                }
                catch (Exception exception) {
                    n = 0;
                }
                if (n > 8192 || n < 0) {
                    throw new SQLException("Connection pool size can be between 1 and 8192");
                }
                if (n != 0) {
                    if (connectionPoolSize != 64 && n != connectionPoolSize) {
                        throw new SQLException("Connection pool size can be changed only one time in the driver.");
                    }
                    connectionPoolSize = n;
                }
                if ("1".equals(parserResult.params.getProperty("TestConnectionStringOnly"))) {
                    parserResult = this.expandDNSPool(parserResult);
                }
                vector = new Vector();
                for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
                    if (!((ClusterNode)parserResult.clusterNodes.get(i)).isValid()) continue;
                    vector.add(parserResult.clusterNodes.get(i));
                }
                if (vector.size() < 1) {
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts(), "HY000");
                }
                if (properties != null) {
                    parserResult.params.putAll((Map<?, ?>)properties);
                }
                if ("1".equals(parserResult.params.getProperty("debug"))) {
                    this.openLog(parserResult.params.getProperty("logdir"));
                }
                String string2 = parserResult.params.getProperty("user");
                String string3 = parserResult.params.getProperty("password");
                String string4 = parserResult.params.getProperty("authmethod");
                String string5 = parserResult.params.getProperty("validateservercertificate");
                this.log("Java Version  : " + System.getProperty("java.version"));
                this.log("Driver Version: " + EXADriver.getVersionInfo());
                String string6 = string;
                if (string6.contains("keystorepassword")) {
                    String string7 = parserResult.params.getProperty("keystorepassword");
                    string6 = string6.replace("keystorepassword=" + string7, "keystorepassword=******");
                }
                this.log("Connection Url: " + string6);
                for (int i = 0; i < vector.size(); ++i) {
                    if (0 == ((ClusterNode)vector.get(i)).GetPort()) {
                        ((ClusterNode)vector.get(i)).SetPort(8563);
                    }
                    this.log("Server:Port: " + ((ClusterNode)vector.get(i)).GetHostAndPort());
                }
                this.log("Username...: " + string2);
                if (string3 != null && string3 != "") {
                    this.log("Password...: *****");
                }
                if (string4 != null && string4 != "") {
                    this.log("AuthMethod...: " + string4);
                }
                if (string5 != null && string5 != "") {
                    this.log("validateServerCertificate: " + string5);
                }
                if (vector.size() < 1) {
                    this.log(Translator.Error_in_connection_string_no_valid_hosts());
                    throw new SQLException(Translator.Error_in_connection_string_no_valid_hosts());
                }
                eXAConnection = new EXAConnection(vector, string2, string3, this.debug, parserResult.params);
            }
            return eXAConnection;
        }
        catch (SQLException sQLException) {
            this.log(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMajorVersion() {
        return EXADriver.getEXADriverMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return EXADriver.getEXADriverMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return EXAConnection.getDefaultProperties();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private void openLog(String string) {
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.debug = new DebugLog(string, "utf8");
        }
        catch (IOException iOException) {
            System.err.println("Cannot create logfile in " + string);
            this.debug = null;
        }
    }

    protected static int getEXADriverMajorVersion() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_MAJOR")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    protected static int getEXADriverMinorVersion() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_MINOR")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    protected static int getEXADriverVersionInc() {
        String string;
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null && (string = (String)versionInfo.get("PRODUCT_VERSION_INC_jdbc")) != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    protected static String getEXADriverName() {
        return DRIVER_NAME;
    }

    public static String getCompilationInfo() {
        try {
            Class<?> clazz = Class.forName("com.exasol.jdbc.EXADriver");
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/exasol/jdbc/timestamp");
            StringBuffer stringBuffer = new StringBuffer();
            int n = inputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            Pattern pattern = Pattern.compile("Revision:");
            String[] stringArray = pattern.split(stringBuffer.toString());
            if (stringArray.length > 1) {
                return stringArray[1].trim();
            }
            return Translator.No_info_available();
        }
        catch (Exception exception) {
            return Translator.No_info_available();
        }
    }

    public ParserResult parseURL8(String string) throws SQLException {
        return new EXAURLParser().URLParser(string);
    }

    private ParserResult expandDNSPool(ParserResult parserResult) {
        ParserResult parserResult2 = new ParserResult();
        parserResult2.params = parserResult.params;
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            ClusterNode clusterNode = (ClusterNode)parserResult.clusterNodes.get(i);
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(clusterNode.GetHost());
                if (inetAddressArray.length > 1) {
                    ParserResult parserResult3 = new ParserResult();
                    for (int j = 0; j < inetAddressArray.length; ++j) {
                        ClusterNode clusterNode2 = new ClusterNode(inetAddressArray[j].getHostAddress(), clusterNode.GetPort());
                        parserResult3.clusterNodes.add(clusterNode2);
                    }
                    ParserResult parserResult4 = this.sortNodesByHostAndPort(parserResult3);
                    int n = parserResult2.clusterNodes.size();
                    for (int j = 0; j < parserResult4.clusterNodes.size(); ++j) {
                        parserResult2.clusterNodes.add(parserResult4.clusterNodes.get(j));
                    }
                    continue;
                }
                parserResult2.clusterNodes.add(clusterNode);
                continue;
            }
            catch (Exception exception) {
                parserResult2.clusterNodes.add(clusterNode);
            }
        }
        return parserResult2;
    }

    private ParserResult sortNodesByHostAndPort(ParserResult parserResult) throws ConnectionException {
        Object[] objectArray = new String[parserResult.clusterNodes.size()];
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            objectArray[i] = ((ClusterNode)parserResult.clusterNodes.get(i)).GetHostAndPort();
        }
        Arrays.sort(objectArray);
        ParserResult parserResult2 = new ParserResult();
        parserResult2.params = parserResult.params;
        for (int i = 0; i < parserResult.clusterNodes.size(); ++i) {
            ClusterNode clusterNode = new ClusterNode((String)objectArray[i]);
            parserResult2.clusterNodes.add(clusterNode);
        }
        return parserResult2;
    }

    private String FormatNumWithLeadingNulls(int n, int n2) {
        String string = "";
        for (int i = 0; i < n - Integer.toString(n2).length(); ++i) {
            string = string + "0";
        }
        string = string + Integer.toString(n2);
        return string;
    }

    private void log(Object object) {
        if (this.debug != null) {
            this.debug.log(object.toString());
        }
    }

    public static int getProtocolVersion() {
        return EXAConnection.getProtocolVersion();
    }

    public static String getVersionInfo() {
        if (versionInfo == null) {
            EXADriver.readVersionRC();
        }
        if (versionInfo != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_MAJOR"));
            stringBuffer.append(".");
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_MINOR"));
            stringBuffer.append(".");
            stringBuffer.append(versionInfo.get("PRODUCT_VERSION_INC_jdbc"));
            return stringBuffer.toString();
        }
        return Translator.No_info_available();
    }

    protected static void readVersionRC() {
        try {
            Pattern pattern = Pattern.compile("^\\s*versioninfo\\((.*),(.*)\\)\\s*$");
            Matcher matcher = null;
            ClassLoader classLoader = Class.forName("com.exasol.jdbc.EXADriver").getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("com/exasol/jdbc/version.res");
            if (inputStream == null) {
                throw new Exception("File version.res missing.");
            }
            versionInfo = new HashMap();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                matcher = pattern.matcher(string);
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    String string3 = matcher.group(2);
                    versionInfo.put(string2, TextUtil.stripQuotes(string3));
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            System.err.println("Error when reading file version number: " + exception.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new EXADriver());
            EXADriver.readVersionRC();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

