/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.EXAURLParser;
import com.exasol.jdbc.Translator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClusterNode {
    private String host;
    private int port;
    private boolean isMarked = false;
    private String fingerprint;

    ClusterNode(String string, int n) throws ConnectionException {
        this.host = string;
        this.SetPort(n);
        this.SetFingerprint(null);
    }

    ClusterNode(String string, int n, String string2) throws ConnectionException {
        this.host = string;
        this.SetPort(n);
        this.SetFingerprint(string2);
    }

    ClusterNode(String string) throws ConnectionException {
        this.UrlParser(string, null);
        this.SetFingerprint(null);
    }

    ClusterNode(String string, String string2) throws ConnectionException {
        this.UrlParser(string, string2);
        this.SetFingerprint(null);
    }

    ClusterNode(String string, String string2, String string3) throws ConnectionException {
        this.UrlParser(string, string2);
        this.SetFingerprint(string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void UrlParser(String string, String string2) throws ConnectionException {
        if (string == null) {
            throw new ConnectionException("[ERROR] URL is null.");
        }
        if (!string.matches("([0-9a-zA-Z.\\-\\/:]+)")) {
            int n = EXAURLParser.getIndexOfCharacters(string, "[^0-9a-zA-Z.\\-\\/:]");
            if (n < 0) throw new ConnectionException(Translator.Invalid_character_in_cluster_string() + " Hostname: " + string);
            throw new ConnectionException(Translator.Invalid_character_in_cluster_string() + " Hostname: " + string + " Invalid character at: " + n + " (" + string.charAt(n) + ")");
        }
        String string3 = "Host";
        String string4 = "Port";
        Matcher matcher = Pattern.compile("(?<" + string3 + ">[0-9a-zA-Z.\\-]+)/*(:(?<" + string4 + ">[0-9]+)){0,1}/*", 32).matcher(string);
        if (matcher.matches()) {
            this.host = matcher.group(string3);
            String string5 = matcher.group(string4);
            if (string5 != null && string5.trim().length() > 0) {
                this.SetPort(Integer.parseInt(string5));
                return;
            } else if (string2 != null && string2.trim().length() > 0) {
                if (!string2.matches("[0-9]+")) throw new ConnectionException("[ERROR] Default Port contains invalid characters. Only Numeric characters are allowed. Default Port: " + string2);
                this.SetPort(Integer.parseInt(string2));
                return;
            } else {
                this.SetPort(0);
            }
            return;
        } else {
            if (!string.matches("(?<" + string3 + ">[0-9a-zA-Z.\\-]+)/*(:(?<" + string4 + ">[0-9]+)){2,}/*")) throw new ConnectionException(Translator.Error_reading_the_hosts_form_cluster_string() + " Hostname: " + string);
            throw new ConnectionException(Translator.Cartesian_product_hosts_ports_found() + " Hostname: " + string);
        }
    }

    public boolean HasPort() {
        return this.port != 0;
    }

    public int GetPort() {
        return this.port;
    }

    public String GetHost() {
        return this.host;
    }

    public String GetHostAndPort() {
        return this.host + ":" + this.port;
    }

    public void SetPort(int n) throws ConnectionException {
        if (n < 0 || n > 65535) {
            throw new ConnectionException(Translator.Illegal_value_for_port_found_in_the_connection_string() + n);
        }
        this.port = n;
    }

    public void Mark() {
        this.isMarked = true;
    }

    public void UnMark() {
        this.isMarked = false;
    }

    public String GetFingerprint() {
        return this.fingerprint;
    }

    public void SetFingerprint(String string) {
        this.fingerprint = string;
    }

    public boolean IsMarked() {
        return this.isMarked;
    }

    public boolean isValid() {
        int n;
        byte[] byArray = this.host.getBytes();
        for (n = 0; n < this.host.length(); ++n) {
            if (byArray[n] == 46 || byArray[n] >= 48 && byArray[n] <= 57) continue;
            return true;
        }
        n = 0;
        int n2 = 0;
        block1: for (int i = 0; i < 4; ++i) {
            while (n < byArray.length) {
                if (byArray[n] == 46) {
                    ++n2;
                    ++n;
                    continue block1;
                }
                ++n;
            }
        }
        return n2 == 3;
    }
}

