/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.logger;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.logger.LogConsoleHandler;
import com.amazon.redshift.logger.LogFileHandler;
import com.amazon.redshift.logger.LogHandler;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.LogWriterHandler;
import com.amazon.redshift.util.RedshiftProperties;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.DriverManager;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class RedshiftLogger {
    private static boolean isEnable = false;
    private static RedshiftLogger driverLogger;
    private volatile LogLevel level = LogLevel.OFF;
    private String fileName;
    private LogHandler handler;
    private static AtomicInteger connectionId;

    public RedshiftLogger(String fileName, String logLevel, boolean driver, String maxLogFileSize, String maxLogFileCount) {
        if (driver) {
            this.fileName = fileName;
            driverLogger = this;
        } else {
            int connId = connectionId.incrementAndGet();
            if (fileName != null) {
                String fileExt = "";
                if (fileName.contains(".")) {
                    fileExt = fileName.substring(fileName.lastIndexOf("."), fileName.length());
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                }
                this.fileName = fileName + "_connection_" + connId + fileExt;
            }
        }
        LogLevel logLevel2 = this.level = logLevel != null ? LogLevel.getLogLevel(logLevel) : LogLevel.OFF;
        if (this.level != LogLevel.OFF) {
            try {
                this.handler = DriverManager.getLogWriter() != null ? new LogWriterHandler(DriverManager.getLogWriter()) : (this.fileName != null ? new LogFileHandler(this.fileName, driver, maxLogFileSize, maxLogFileCount) : new LogConsoleHandler());
            }
            catch (Exception ex) {
                this.handler = new LogConsoleHandler();
            }
            isEnable = true;
        }
    }

    public static boolean isEnable() {
        return isEnable;
    }

    public static RedshiftLogger getDriverLogger() {
        return driverLogger;
    }

    private boolean isEnabled() {
        return this.level != LogLevel.OFF;
    }

    public LogLevel getLogLevel() {
        return this.level;
    }

    public static boolean checkLogLevel(LogLevel level, RedshiftLogger log) {
        return log.isEnabled() && level.ordinal() <= log.getLogLevel().ordinal();
    }

    private static StackTraceElement getStackElementAbove(String functionName) {
        boolean returnNextFunction = false;
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            if (returnNextFunction) {
                return s;
            }
            if (!s.getMethodName().equals(functionName)) continue;
            returnNextFunction = true;
        }
        return Thread.currentThread().getStackTrace()[3];
    }

    public static String maskSecureInfoInUrl(String url) {
        String[] tokens = new String[]{RedshiftProperty.PWD.getName(), RedshiftProperty.PASSWORD.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName(), RedshiftProperty.IAM_SECRET_ACCESS_KEY.getName(), RedshiftProperty.IAM_SESSION_TOKEN.getName()};
        String temp = RedshiftLogger.maskSecureInfo(url, tokens, "[\\?;&]");
        return temp;
    }

    public static String maskSecureInfo(String msg, String[] tokens, String tokenizer) {
        if (msg == null) {
            return msg;
        }
        StringBuilder newMsg = new StringBuilder();
        String[] splitMsgs = msg.split(tokenizer);
        boolean secureInfoFound = false;
        for (String splitMsg : splitMsgs) {
            String tokenFound = null;
            String sTemp = splitMsg.toLowerCase();
            for (String token : tokens) {
                String temp = token.toLowerCase();
                if (!sTemp.contains(temp)) continue;
                tokenFound = token;
                secureInfoFound = true;
                break;
            }
            if (tokenFound == null) {
                newMsg.append(splitMsg).append(";");
                continue;
            }
            newMsg.append(tokenFound).append("=***;");
        }
        return secureInfoFound ? newMsg.toString() : msg;
    }

    public static Properties maskSecureInfoInProps(Properties info) {
        if (info == null) {
            return info;
        }
        boolean secureInfoFound = false;
        String[] propNames = new String[]{RedshiftProperty.PWD.getName(), RedshiftProperty.PASSWORD.getName(), RedshiftProperty.IAM_ACCESS_KEY_ID.getName(), RedshiftProperty.IAM_SECRET_ACCESS_KEY.getName(), RedshiftProperty.IAM_SESSION_TOKEN.getName()};
        RedshiftProperties temp = new RedshiftProperties();
        temp.putAll((Map<?, ?>)info);
        for (String propName : propNames) {
            String oldVal = RedshiftLogger.replaceIgnoreCase(temp, propName, "***");
            if (oldVal == null) continue;
            secureInfoFound = true;
        }
        return secureInfoFound ? temp : info;
    }

    public static String replaceIgnoreCase(Properties info, String key, String newVal) {
        String value = info.getProperty(key);
        if (null != value) {
            info.replace(key, newVal);
            return value;
        }
        Set<Map.Entry<Object, Object>> s = info.entrySet();
        for (Map.Entry<Object, Object> entry : s) {
            if (!key.equalsIgnoreCase((String)entry.getKey())) continue;
            info.replace(key, newVal);
            return (String)entry.getValue();
        }
        return null;
    }

    private static String[] getCallerMethodName(String logFunction) {
        StackTraceElement element = RedshiftLogger.getStackElementAbove(logFunction);
        String[] names = new String[3];
        names[2] = element.getMethodName();
        try {
            Class<?> originatingClass = Class.forName(element.getClassName());
            names[1] = originatingClass.getSimpleName();
            names[0] = "";
            Package originatingPackage = originatingClass.getPackage();
            if (null != originatingPackage) {
                names[0] = originatingPackage.getName();
            }
        }
        catch (ClassNotFoundException e) {
            names[0] = "<error>";
            names[1] = element.getClassName();
        }
        if (names[2].equals("<init>")) {
            names[2] = names[1];
        }
        return names;
    }

    public void log(LogLevel logLevel, String msg, Object ... msgArgs) {
        if (!RedshiftLogger.checkLogLevel(logLevel, this)) {
            return;
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("log");
        this.logMsg(logLevel, callerNames, msg, msgArgs);
    }

    public void log(LogLevel logLevel, Throwable thrown, String msg, Object ... msgArgs) {
        if (!RedshiftLogger.checkLogLevel(logLevel, this)) {
            return;
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("log");
        StringWriter sw = new StringWriter();
        thrown.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        this.logMsg(logLevel, callerNames, msg, msgArgs);
        this.logMsg(logLevel, callerNames, stacktrace, new Object[0]);
    }

    public void logError(Exception error) {
        if (!RedshiftLogger.checkLogLevel(LogLevel.ERROR, this)) {
            return;
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("logError");
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        this.logMsg(LogLevel.ERROR, callerNames, stacktrace, new Object[0]);
    }

    public void logError(String msg, Object ... msgArgs) {
        if (!RedshiftLogger.checkLogLevel(LogLevel.ERROR, this)) {
            return;
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("logError");
        this.logMsg(LogLevel.ERROR, callerNames, msg, msgArgs);
    }

    public void logInfo(String msg, Object ... msgArgs) {
        if (!RedshiftLogger.checkLogLevel(LogLevel.INFO, this)) {
            return;
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("logInfo");
        this.logMsg(LogLevel.INFO, callerNames, msg, msgArgs);
    }

    public void logFunction(boolean entry, Object ... params) {
        String msg;
        if (!RedshiftLogger.checkLogLevel(LogLevel.FUNCTION, this)) {
            return;
        }
        String string = msg = entry ? " Enter " : " Return ";
        if (params != null) {
            StringBuffer paramVal = new StringBuffer();
            int paramCount = 0;
            paramVal.append(msg);
            if (entry) {
                paramVal.append("(");
            }
            for (Object param : params) {
                if (paramCount++ != 0) {
                    paramVal.append(",");
                }
                if (param != null) {
                    if (param.getClass().isArray()) {
                        if (param instanceof Object[]) {
                            paramVal.append(Arrays.toString((Object[])param));
                            continue;
                        }
                        if (param instanceof int[]) {
                            paramVal.append(Arrays.toString((int[])param));
                            continue;
                        }
                        if (param instanceof long[]) {
                            paramVal.append(Arrays.toString((long[])param));
                            continue;
                        }
                        paramVal.append(param);
                        continue;
                    }
                    paramVal.append(param);
                    continue;
                }
                paramVal.append(param);
            }
            if (entry) {
                paramVal.append(") ");
            } else {
                paramVal.append(" ");
            }
            msg = paramVal.toString();
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("logFunction");
        this.logMsg(LogLevel.FUNCTION, callerNames, msg, new Object[0]);
    }

    public void logDebug(String msg, Object ... msgArgs) {
        if (!RedshiftLogger.checkLogLevel(LogLevel.DEBUG, this)) {
            return;
        }
        String[] callerNames = RedshiftLogger.getCallerMethodName("logDebug");
        this.logMsg(LogLevel.DEBUG, callerNames, msg, msgArgs);
    }

    public void close() {
        if (this.handler != null && this.handler instanceof LogFileHandler) {
            try {
                this.handler.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void flush() {
        if (this.handler != null) {
            this.handler.flush();
        }
    }

    private void logMsg(LogLevel level, String[] callerNames, String msg, Object ... msgArgs) {
        String formattedMsg = this.formatLogMsg(level, callerNames[0], callerNames[1], callerNames[2], msg, msgArgs);
        try {
            if (formattedMsg != null && null != this.handler) {
                this.handler.write(formattedMsg);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String formatLogMsg(LogLevel logLevel, String packageName, String className, String methodName, String msg, Object ... msgArgs) {
        if (null == this.handler) {
            return null;
        }
        StringBuffer msgBuf = new StringBuffer();
        SimpleDateFormat dateFormat = null;
        dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss.SSS");
        dateFormat.format(new Date(), msgBuf, new FieldPosition(0));
        msgBuf.append(" ");
        msgBuf.append(logLevel.toString()).append(" ");
        msgBuf.append(" ");
        msgBuf.append("[").append(Thread.currentThread().getId()).append(" ").append(Thread.currentThread().getName()).append("] ");
        msgBuf.append(packageName).append(".");
        msgBuf.append(className).append(".");
        msgBuf.append(methodName).append(": ");
        if (msgArgs == null || msgArgs.length == 0) {
            msgBuf.append(msg);
        } else {
            msgBuf.append(new MessageFormat(msg).format(msgArgs));
        }
        return msgBuf.toString();
    }

    public static String getLogFileUsingPath(String logLevel, String logPath) {
        if (logPath == null) {
            LogLevel level;
            LogLevel logLevel2 = level = logLevel != null ? LogLevel.getLogLevel(logLevel) : LogLevel.OFF;
            if (level != LogLevel.OFF) {
                logPath = System.getProperty("user.dir");
            }
        }
        if (logPath != null) {
            return logPath + File.separatorChar + "redshift_jdbc.log";
        }
        return null;
    }

    static {
        connectionId = new AtomicInteger();
    }
}

