/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink;

import com.yworks.common.ShrinkBag;
import com.yworks.logging.ConsoleLogger;
import com.yworks.logging.Logger;
import com.yworks.logging.XmlLogger;
import com.yworks.yshrink.ant.filters.AllMainMethodsFilter;
import com.yworks.yshrink.ant.filters.EntryPointFilter;
import com.yworks.yshrink.core.Analyzer;
import com.yworks.yshrink.core.ClassResolver;
import com.yworks.yshrink.core.Shrinker;
import com.yworks.yshrink.core.Writer;
import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class YShrink {
    private static final String CENTER_CLASS = "";
    private static final String CENTER_METHOD_NAME = "";
    private static final String CENTER_METHOD_DESC = "";
    private final boolean createStubs;
    private String digests;

    public YShrink() {
        this.createStubs = true;
    }

    public YShrink(boolean createStubs, String digests) {
        this.createStubs = createStubs;
        this.digests = digests;
    }

    public void doShrinkPairs(List<ShrinkBag> pairs, EntryPointFilter epf, ClassResolver resolver) throws IOException {
        Analyzer analyzer = new Analyzer();
        Model model = new Model();
        if (null != resolver) {
            model.setClassResolver(resolver);
        }
        if (!model.isSimpleModelSet()) {
            analyzer.initModel(model, pairs);
        }
        List<AbstractDescriptor> entryPoints = this.markEntryPoints(model, epf);
        if (model.isSimpleModelSet()) {
            analyzer.createDependencyEdges(model);
        } else {
            analyzer.createEdges(model);
        }
        model.createEntryPointEdges(entryPoints);
        Shrinker shrinker = new Shrinker();
        shrinker.shrink(model);
        Writer writer = new Writer(this.createStubs, this.digests);
        for (ShrinkBag bag : pairs) {
            if (bag.isEntryPointJar()) continue;
            writer.write(model, bag);
        }
        if (!model.isAllResolved()) {
            Logger.warn("Not all dependencies could be resolved. Please see the logfile for details.");
        }
    }

    private List<AbstractDescriptor> markEntryPoints(Model model, EntryPointFilter epFilter) {
        StringBuilder buf = new StringBuilder();
        buf.append("<entrypoints>\n");
        ArrayList<AbstractDescriptor> entryPoints = new ArrayList<AbstractDescriptor>();
        for (ClassDescriptor cd : model.getAllClassDescriptors()) {
            epFilter.setRetainAttribute(cd);
            if (epFilter.isEntryPointClass(model, cd)) {
                buf.append("\t<class name=\"");
                buf.append(Util.toJavaClass(cd.getName()));
                buf.append("\" />\n");
                entryPoints.add(cd);
                cd.setEntryPoint(true);
                model.markNotObsolete(cd.getNode());
            }
            for (MethodDescriptor md : cd.getMethods()) {
                AbstractDescriptor newNodeDesc;
                if (!epFilter.isEntryPointMethod(model, cd, md)) continue;
                buf.append("\t<method signature=\"");
                buf.append(XmlLogger.replaceSpecialChars(md.getSignature()));
                buf.append("\" class=\"");
                buf.append(Util.toJavaClass(cd.getName()));
                buf.append("\" />\n");
                entryPoints.add(md);
                md.setEntryPoint(true);
                if (!md.getName().equals("<init>") || (newNodeDesc = model.getDescriptor(cd.getNewNode())).isEntryPoint()) continue;
                newNodeDesc.setEntryPoint(true);
                entryPoints.add(newNodeDesc);
            }
            for (FieldDescriptor fd : cd.getFields()) {
                if (!epFilter.isEntryPointField(model, cd, fd)) continue;
                buf.append("\t<field name=\"");
                buf.append(Util.toJavaClass(fd.getName()));
                buf.append("\" class=\"");
                buf.append(Util.toJavaClass(cd.getName()));
                buf.append("\" />\n");
                entryPoints.add(fd);
                fd.setEntryPoint(true);
            }
        }
        buf.append("</entrypoints>\n");
        Logger.shrinkLog(buf.toString());
        return entryPoints;
    }

    public static void main(String[] args) {
        new ConsoleLogger();
        try {
            boolean showGraph = false;
            File in = null;
            File out = null;
            if (args.length > 0) {
                in = new File(args[0]);
            }
            if (null == in) {
                in = new File(ClassLoader.getSystemResource("yshrink.jar").getFile());
            }
            if (args.length > 1) {
                out = new File(args[1]);
            }
            if (null == out) {
                out = new File(System.getProperty("user.dir") + "/out.jar");
            }
            if (args.length > 2) {
                showGraph = Boolean.parseBoolean(args[2]);
            }
            URL[] externalLibs = new URL[]{ClassLoader.getSystemResource("external.jar")};
            YShrink yshrink = new YShrink();
            AllMainMethodsFilter allMainMethodsFilter = new AllMainMethodsFilter();
        }
        catch (Exception e) {
            Logger.err("An Exception occured.", e);
        }
    }
}

