/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.ParseException;
import com.yworks.yguard.obf.classfile.AnnotationInfo;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.CpInfo;
import com.yworks.yguard.obf.classfile.IntegerCpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ElementValueInfo {
    protected int u1Tag;
    protected int u2cpIndex;
    protected int u2typeNameIndex;
    protected int u2constNameIndex;
    protected AnnotationInfo nestedAnnotation;
    protected ElementValueInfo[] arrayValues;

    private ElementValueInfo() {
    }

    public static ElementValueInfo create(DataInput din) throws IOException {
        ElementValueInfo evp = new ElementValueInfo();
        evp.read(din);
        return evp;
    }

    public boolean getBoolValue(ConstantPool cp) {
        if (this.u1Tag == 90) {
            CpInfo cpEntry = cp.getCpEntry(this.u2cpIndex);
            return cpEntry instanceof IntegerCpInfo && ((IntegerCpInfo)cpEntry).asBool();
        }
        throw new RuntimeException("cannot get bool value of " + this.u1Tag);
    }

    protected void read(DataInput din) throws IOException {
        this.u1Tag = din.readUnsignedByte();
        switch (this.u1Tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.u2cpIndex = din.readUnsignedShort();
                break;
            }
            case 101: {
                this.u2typeNameIndex = din.readUnsignedShort();
                this.u2constNameIndex = din.readUnsignedShort();
                break;
            }
            case 99: {
                this.u2cpIndex = din.readUnsignedShort();
                break;
            }
            case 64: {
                this.nestedAnnotation = AnnotationInfo.create(din);
                break;
            }
            case 91: {
                int count = din.readUnsignedShort();
                this.arrayValues = new ElementValueInfo[count];
                for (int i = 0; i < count; ++i) {
                    this.arrayValues[i] = ElementValueInfo.create(din);
                }
                break;
            }
            default: {
                throw new ParseException("Unkown tag type in ElementValuePair: " + this.u1Tag);
            }
        }
    }

    protected void markUtf8RefsInInfo(ConstantPool pool) {
        switch (this.u1Tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                pool.getCpEntry(this.u2cpIndex).incRefCount();
                break;
            }
            case 101: {
                pool.getCpEntry(this.u2typeNameIndex).incRefCount();
                pool.getCpEntry(this.u2constNameIndex).incRefCount();
                break;
            }
            case 99: {
                pool.getCpEntry(this.u2cpIndex).incRefCount();
                break;
            }
            case 64: {
                this.nestedAnnotation.markUtf8RefsInInfo(pool);
                break;
            }
            case 91: {
                for (int i = 0; i < this.arrayValues.length; ++i) {
                    this.arrayValues[i].markUtf8RefsInInfo(pool);
                }
                break;
            }
        }
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeByte(this.u1Tag);
        switch (this.u1Tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dout.writeShort(this.u2cpIndex);
                break;
            }
            case 101: {
                dout.writeShort(this.u2typeNameIndex);
                dout.writeShort(this.u2constNameIndex);
                break;
            }
            case 99: {
                dout.writeShort(this.u2cpIndex);
                break;
            }
            case 64: {
                this.nestedAnnotation.write(dout);
                break;
            }
            case 91: {
                int count = this.arrayValues.length;
                dout.writeShort(count);
                for (int i = 0; i < count; ++i) {
                    this.arrayValues[i].write(dout);
                }
                break;
            }
        }
    }
}

