/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.compiler;

import com.yworks.util.compiler.Streams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class FileObjects {
    private FileObjects() {
    }

    static JavaFileObject newInMemoryFileObject(String typeName, String code) {
        return new InMemoryFileObject(typeName, code);
    }

    static JavaFileObject newUrlFileObject(String typeName, URL url) {
        return new UrlFileObject(typeName, url);
    }

    private static final class UrlFileObject
    extends AbstractSourceObject {
        private final URL url;

        UrlFileObject(String typname, URL url) {
            super(typname);
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            StringBuffer sb = new StringBuffer();
            int[] tail = new int[1];
            try (BufferedReader br = new BufferedReader(Streams.newTail(this.openReader(ignoreEncodingErrors), tail));){
                String line = br.readLine();
                while (line != null) {
                    sb.append(line).append('\n');
                    line = br.readLine();
                }
            }
            if (sb.length() > 0 && tail[0] != 10) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            return new InputStreamReader(this.url.openStream(), "UTF-8");
        }
    }

    private static final class InMemoryFileObject
    extends AbstractSourceObject {
        private final String code;

        InMemoryFileObject(String typeName, String code) {
            super(typeName);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.code;
        }
    }

    private static abstract class AbstractSourceObject
    extends SimpleJavaFileObject {
        AbstractSourceObject(String typname) {
            super(AbstractSourceObject.asUri(typname), JavaFileObject.Kind.SOURCE);
        }

        static URI asUri(String typeName) {
            return URI.create("string:///" + typeName.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
        }
    }
}

