/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.logging;

import java.util.ArrayList;
import java.util.List;

public abstract class Logger {
    private static List<Logger> instances;

    protected void register() {
        if (null == instances) {
            instances = new ArrayList<Logger>();
        }
        instances.add(this);
    }

    protected void unregister() {
        instances.remove(this);
    }

    public static void log(String s) {
        if (null != instances) {
            for (Logger logger : instances) {
                logger.doLog(s);
            }
        }
    }

    public static void err(String s) {
        if (null != instances) {
            for (Logger logger : instances) {
                logger.doErr(s);
            }
        }
    }

    public static void err(String s, Throwable ex) {
        if (null != instances) {
            for (Logger logger : instances) {
                logger.doErr(s, ex);
            }
        }
    }

    public static void warn(String s) {
        if (null != instances) {
            for (Logger logger : instances) {
                logger.doWarn(s);
            }
        }
    }

    public static void warnToLog(String s) {
        if (null != instances) {
            for (Logger logger : instances) {
                logger.doWarnToLog(s);
            }
        }
    }

    public static void shrinkLog(String s) {
        if (null != instances) {
            for (Logger logger : instances) {
                logger.doShrinkLog(s);
            }
        }
    }

    public abstract void doLog(String var1);

    public abstract void doErr(String var1);

    public abstract void doWarn(String var1);

    public abstract void doWarnToLog(String var1);

    public abstract void doShrinkLog(String var1);

    public abstract void doErr(String var1, Throwable var2);

    public abstract void close();

    public static enum ShrinkType {
        CLASS,
        METHOD,
        FIELD;

    }
}

