/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class OvalShape
implements BalloonShape {
    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        int n2 = dimension.width;
        int n3 = dimension.height;
        return new Ellipse2D.Double(0.0, 0.0, n2 - 1, n3 - 1);
    }

    @Override
    public Point getHotSpot(Dimension dimension) {
        return new Point(0, dimension.height);
    }

    @Override
    public Insets getInsets(Dimension dimension) {
        double d2 = (double)dimension.width / 2.0;
        double d3 = (double)dimension.height / 2.0;
        double d4 = d2 * Math.sqrt(2.0);
        double d5 = d3 * Math.sqrt(2.0);
        int n2 = (int)(d4 - d2);
        int n3 = (int)(d5 - d3);
        return new Insets(n3, n2, n3, n2);
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        double d2;
        Dimension dimension = balloonTip.getBalloonSize();
        double d3 = point.x;
        double d4 = point.y;
        if (dimension.width > dimension.height) {
            d4 = d4 * (double)dimension.width / (double)dimension.height;
            d2 = (double)dimension.width / 2.0;
        } else {
            d3 = d3 * (double)dimension.height / (double)dimension.width;
            d2 = (double)dimension.height / 2.0;
        }
        double d5 = Point.distance(d3, d4, d2, d2);
        return (int)(d5 - d2);
    }
}

