/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DraggingTableHeader;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LegacySortableTableHeader
extends DraggingTableHeader {
    public LegacySortableTableHeader(SortableTable sortableTable) {
        super(sortableTable.getColumnModel());
        this.addMouseListener(sortableTable.getSortableHeaderMouseListener());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.\u02d0();
        super.paintComponent(graphics);
        this.paintSortArrows(graphics);
    }

    private void \u02d0() {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        int[] nArray = new int[list.size()];
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ISortableTableModel.SortItem sortItem = list.get(i2);
            nArray[i2] = sortableTable.convertColumnIndexToView(sortItem.getColumn());
        }
        sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", nArray);
        sortableTable.putClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND", true);
    }

    protected void paintSortArrows(Graphics graphics) {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            return;
        }
        TableColumn tableColumn = this.getDraggedColumn();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ISortableTableModel.SortItem sortItem = list.get(i2);
            int n2 = sortItem.getColumn();
            if (n2 < 0) continue;
            boolean bl = false;
            if (tableColumn != null && tableColumn.getModelIndex() == n2) {
                bl = true;
            }
            if ((n2 = sortableTable.convertColumnIndexToView(n2)) == -1) continue;
            boolean bl2 = sortItem.isAscending();
            Rectangle rectangle = this.getHeaderRect(n2);
            if (bl) {
                rectangle.x += this.getDraggedDistance();
            }
            this.paintSortArrow(this, sortableTable, graphics, rectangle, sortableTable.isShowSortOrderNumber() || list.size() > 1 ? i2 : -1, bl2);
        }
    }

    protected void paintSortArrow(JComponent jComponent, SortableTable sortableTable, Graphics graphics, Rectangle rectangle, int n2, boolean bl) {
        Icon icon = this.createSortIcon(sortableTable, bl);
        boolean bl2 = sortableTable.isMultiColumnSortable();
        Color color = sortableTable.getSortOrderForeground() != null ? sortableTable.getSortOrderForeground() : jComponent.getForeground();
        Object object = UIDefaultsLookup.get("Theme.painter");
        if (object instanceof ThemePainter) {
            ((ThemePainter)object).paintSortableTableHeaderColumn(sortableTable.getTableHeader(), graphics, rectangle, 0, 0, bl ? 1 : 2, icon, n2, color, bl2);
        }
    }

    protected Icon createSortIcon(SortableTable sortableTable, boolean bl) {
        return sortableTable.createSortIcon(bl);
    }

    private Component \u014b(int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n2);
    }

    @Override
    public int getPreferredHeight() {
        if (this.\u1e5c == -1) {
            this.\u1e5c = 0;
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
                Component component = this.\u014b(i2);
                int n2 = component.getPreferredSize().height;
                this.\u1e5c = Math.max(this.\u1e5c, n2);
            }
        }
        return this.\u1e5c;
    }

    public Dimension originalGetPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.originalGetPreferredSize();
        if (dimension.width == 0 || dimension.height == 0 || SystemInfo.isJdk15Above() && this.isPreferredSizeSet()) {
            return dimension;
        }
        return new Dimension(dimension.width, this.getPreferredHeight());
    }

    void \u02d1() {
        this.\u1e5c = -1;
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.\u02d1();
        super.columnAdded(tableColumnModelEvent);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.\u02d1();
        super.columnRemoved(tableColumnModelEvent);
    }
}

