/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.DefaultComboBoxModelWrapper;
import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class SortableComboBoxModel<E>
extends DefaultComboBoxModelWrapper<E>
implements ListDataListener {
    private static final long \u0103 = 7114812950561886305L;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = -1;
    public static final int UNSORTED = 0;
    private int \u0106 = 1;
    private boolean \u0107 = true;
    private boolean \u0105 = true;
    private ComparatorContext \u0109;
    private boolean \u0108 = false;
    private Comparator<E> \u0104;
    protected EventListenerList listenerList = new EventListenerList();

    public SortableComboBoxModel() {
    }

    public SortableComboBoxModel(ComboBoxModel<E> comboBoxModel) {
        this.setActualModel(comboBoxModel);
    }

    @Override
    public void setActualModel(ComboBoxModel<E> comboBoxModel) {
        super.setActualModel(comboBoxModel);
        comboBoxModel.addListDataListener(this);
        this.reallocateIndexes();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        super.intervalAdded(listDataEvent);
        if (this.\u0106 == 0) {
            this.reallocateIndexes();
            this.fireIntervalAdded(listDataEvent.getSource(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
            return;
        }
        if (!this.isOptimized()) {
            this.\u0102();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            return;
        }
        for (int i2 = listDataEvent.getIndex0(); i2 <= listDataEvent.getIndex1(); ++i2) {
            int n2;
            if (this.isAutoResort()) {
                n2 = this.\u0103(i2);
                this.fireIntervalAdded(listDataEvent.getSource(), n2, n2);
                continue;
            }
            n2 = this.\u0101(i2);
            this.fireIntervalAdded(listDataEvent.getSource(), n2, n2);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        super.intervalRemoved(listDataEvent);
        if (this.\u0106 == 0) {
            this.reallocateIndexes();
            this.fireIntervalRemoved(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
            return;
        }
        if (!this.isOptimized()) {
            this.\u0102();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            return;
        }
        if (listDataEvent.getIndex0() == 0 && listDataEvent.getIndex1() == this.getSize() - 1) {
            this.reallocateIndexes();
            this.fireIntervalRemoved(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
        } else {
            for (int i2 = listDataEvent.getIndex1(); i2 >= listDataEvent.getIndex0(); --i2) {
                int n2 = this.getIndexAt(i2);
                if (n2 == -1) continue;
                this.\u0102(i2);
                this.fireIntervalRemoved(this, n2, n2);
            }
        }
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        super.contentsChanged(listDataEvent);
        if (this.\u0106 == 0) {
            this.reallocateIndexes();
            this.fireContentsChanged(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
            return;
        }
        if (!this.isOptimized()) {
            this.\u0102();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            return;
        }
        if (this.isAutoResort()) {
            for (int i2 = listDataEvent.getIndex1(); i2 >= listDataEvent.getIndex0(); --i2) {
                int n2 = this.getIndexAt(i2);
                if (n2 == -1 || i2 == n2) continue;
                this.\u0102(i2);
                this.\u0103(i2);
                this.fireContentsChanged(this, n2, n2);
            }
        } else {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    private void \u0102() {
        this.reallocateIndexes();
        this.sort((int[])this._indexes.clone(), this._indexes, 0, this._indexes.length);
    }

    protected int search(int[] nArray, int n2) {
        return this.\u0101(nArray, n2);
    }

    private int \u0101(int[] nArray, int n2) {
        int n3;
        int n4 = 0;
        int n5 = n3 = nArray.length - 1;
        boolean bl = false;
        while (n4 <= n3) {
            int n6 = n4 + n3 >> 1;
            int n7 = this.compare(nArray[n6], n2);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n3 = n6 - 1;
                continue;
            }
            n5 = n6;
            bl = true;
            break;
        }
        if (!bl) {
            n5 = n4;
        }
        return n5;
    }

    protected void sort(int[] nArray, int[] nArray2, int n2, int n3) {
        this.\u0101(nArray, nArray2, n2, n3);
    }

    protected int compare(int n2, int n3) {
        int n4 = this.\u0101(n2, n3);
        if (n4 != 0) {
            return this.\u0106 > 0 ? n4 : -n4;
        }
        return 0;
    }

    private void \u0101(int[] nArray, int[] nArray2, int n2, int n3) {
        if (n3 - n2 < 2) {
            return;
        }
        int n4 = (n2 + n3) / 2;
        this.\u0101(nArray2, nArray, n2, n4);
        this.\u0101(nArray2, nArray, n4, n3);
        int n5 = n2;
        int n6 = n4;
        if (n3 - n2 >= 4 && this.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            for (int i2 = n2; i2 < n3; ++i2) {
                nArray2[i2] = nArray[i2];
            }
            return;
        }
        for (int i3 = n2; i3 < n3; ++i3) {
            nArray2[i3] = n6 >= n3 || n5 < n4 && this.compare(nArray[n5], nArray[n6]) <= 0 ? nArray[n5++] : nArray[n6++];
        }
    }

    private int \u0101(int n2, int n3) {
        Object e2 = this._model.getElementAt(n2);
        Object e3 = this._model.getElementAt(n3);
        if (e2 == null && e3 == null) {
            return 0;
        }
        if (e2 == null) {
            return -1;
        }
        if (e3 == null) {
            return 1;
        }
        return this.compare(e2, e3);
    }

    protected int compare(E e2, E e3) {
        try {
            if (this.isAlwaysUseComparators() || this.getComparator() != null || this.getComparatorContext() != null) {
                Comparator comparator = this.getComparator();
                if (comparator == null) {
                    comparator = ObjectComparatorManager.getComparator(e2.getClass(), this.getComparatorContext());
                }
                return comparator.compare(e2, e3);
            }
            if (e2 == null && e3 == null) {
                return 0;
            }
            if (e2 == null) {
                return -1;
            }
            if (e3 == null) {
                return 1;
            }
            if (e2 instanceof String && e3 instanceof String) {
                return ((String)e2).compareToIgnoreCase((String)e3);
            }
            if (e2 instanceof Comparable && e3 instanceof Comparable && e2.getClass().isAssignableFrom(e3.getClass())) {
                return ((Comparable)e2).compareTo(e3);
            }
            if (e2 instanceof Comparable && e3 instanceof Comparable && e3.getClass().isAssignableFrom(e2.getClass())) {
                return ((Comparable)e3).compareTo(e2);
            }
            Comparator comparator = this.getComparator();
            if (comparator == null) {
                comparator = ObjectComparatorManager.getComparator(e2.getClass(), this.getComparatorContext());
            }
            return comparator.compare(e2, e3);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Comparator<E> getComparator() {
        return this.\u0104;
    }

    public void setComparator(Comparator<E> comparator) {
        this.\u0104 = comparator;
    }

    public ComparatorContext getComparatorContext() {
        return this.\u0109;
    }

    public void setComparatorContext(ComparatorContext comparatorContext) {
        this.\u0109 = comparatorContext;
    }

    public int getSortOrder() {
        return this.\u0106;
    }

    public void setSortOrder(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != -1) {
            throw new IllegalArgumentException("Sort order must be one of the three values: UNSORTED, SORT_DESCENDING or SORT_ASCENDING");
        }
        this.\u0106 = n2;
        if (this.\u0106 == 0) {
            this.reset();
        } else {
            this.\u0102();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            this.fireSortEvent();
        }
    }

    public void sort() {
        this.setSortOrder(1);
    }

    public void sort(int n2) {
        this.setSortOrder(n2);
    }

    public void unsort() {
        this.\u0106 = 0;
        this.reallocateIndexes();
        this.fireContentsChanged(this, 0, this.getSize() - 1);
        this.fireSortEvent();
    }

    public void reset() {
        this.unsort();
    }

    @Override
    public void setIndexes(int[] nArray) {
        this.\u0106 = 0;
        super.setIndexes(nArray);
    }

    public static SortableComboBoxModel getSortableListModel(ListModel listModel) {
        while (true) {
            if (listModel instanceof SortableComboBoxModel) {
                return (SortableComboBoxModel)listModel;
            }
            if (!(listModel instanceof ListModelWrapper)) break;
            listModel = ((ListModelWrapper)((Object)listModel)).getActualModel();
        }
        return null;
    }

    public boolean isOptimized() {
        return this.\u0105;
    }

    public void setOptimized(boolean bl) {
        this.\u0105 = bl;
    }

    public boolean isAutoResort() {
        return this.\u0107;
    }

    public void setAutoResort(boolean bl) {
        this.\u0107 = bl;
    }

    public void resort() {
        if (this.\u0106 != 0) {
            this.\u0102();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
    }

    public void addSortListener(SortListener sortListener) {
        this.listenerList.add(SortListener.class, sortListener);
    }

    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i2 + 1]).sortChanged(sortEvent);
        }
    }

    private void \u0102(int n2) {
        int n3 = this.getIndexAt(n2);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n3);
        System.arraycopy(nArray, n3 + 1, this._indexes, n3, this._indexes.length - n3);
        for (int i2 = 0; i2 < this._indexes.length; ++i2) {
            int n4 = this._indexes[i2];
            if (n4 <= n2) continue;
            this._indexes[i2] = n4 - 1;
        }
    }

    private int \u0103(int n2) {
        int n3;
        for (n3 = 0; n3 < this._indexes.length; ++n3) {
            int n4 = this._indexes[n3];
            if (n4 < n2) continue;
            this._indexes[n3] = n4 + 1;
        }
        n3 = this.search(this._indexes, n2);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n3);
        this._indexes[n3] = n2;
        System.arraycopy(nArray, n3, this._indexes, n3 + 1, this._indexes.length - n3 - 1);
        return n3;
    }

    private int \u0101(int n2) {
        for (int i2 = 0; i2 < this._indexes.length; ++i2) {
            int n3 = this._indexes[i2];
            if (n3 < n2) continue;
            this._indexes[i2] = n3 + 1;
        }
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this._indexes, 0, nArray.length);
        this._indexes[nArray.length] = n2;
        return nArray.length;
    }

    public boolean isAlwaysUseComparators() {
        return this.\u0108;
    }

    public void setAlwaysUseComparators(boolean bl) {
        this.\u0108 = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(SortableComboBoxModel.class.getName(), 4);
        }
    }
}

