/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.TypeInfo;
import com.nuodb.jdbc.Value;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class ValueTimestampNoTZ
extends Value {
    LocalDateTime value;
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(TimeZone.getTimeZone("UTC").toZoneId());
    static DateTimeFormatter formatterMilliseconds = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(TimeZone.getTimeZone("UTC").toZoneId());
    static DateTimeFormatter formatterMicroseconds = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").withZone(TimeZone.getTimeZone("UTC").toZoneId());
    static DateTimeFormatter formatterNanoseconds = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSSSS").withZone(TimeZone.getTimeZone("UTC").toZoneId());

    private DateTimeFormatter valueFormatter() {
        int nanos = this.value.getNano();
        if (nanos == 0) {
            return formatter;
        }
        if (nanos % 1000000 == 0) {
            return formatterMilliseconds;
        }
        if (nanos % 1000 == 0) {
            return formatterMicroseconds;
        }
        return formatterNanoseconds;
    }

    public ValueTimestampNoTZ(long seconds, int nanos) {
        this.value = LocalDateTime.ofEpochSecond(seconds, nanos, ZoneOffset.UTC);
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeScaledTimestampNoTZ(this.value);
    }

    @Override
    int getType() {
        return 25;
    }

    @Override
    String getString() {
        return this.valueFormatter().format(this.value);
    }

    @Override
    String getString(SQLContext context) {
        return this.getString();
    }

    @Override
    Date getDate() {
        return new Date(this.value.toEpochSecond(ZoneOffset.UTC) * 1000L);
    }

    @Override
    Timestamp getTimestamp() throws SQLException {
        throw new SQLException("Time zone is required to get timestamp from a timestamp without time zone");
    }

    @Override
    Time getTime() throws SQLException {
        return Time.valueOf(this.value.toLocalTime());
    }

    @Override
    Date getDate(SQLContext context) throws SQLException {
        return this.getDate();
    }

    @Override
    Time getTime(SQLContext context) throws SQLException {
        return this.getTime();
    }

    private long getLocalTimeInMillis() {
        long millis = this.value.toEpochSecond(ZoneOffset.UTC) * 1000L;
        return millis += (long)(this.value.getNano() / 1000000);
    }

    @Override
    Timestamp getTimestamp(SQLContext context) throws SQLException {
        long rawMillis;
        long localMillis = this.getLocalTimeInMillis();
        TimeZone tz = context.getTimeZone();
        long utcMillis = rawMillis - (long)(tz.inDaylightTime(new Date(rawMillis = localMillis - (long)tz.getRawOffset())) ? tz.getDSTSavings() : 0);
        return new Timestamp(utcMillis);
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.getLocalTimeInMillis());
    }

    @Override
    public Object getObject(TypeInfo typeInfo, SQLContext sqlContext) throws SQLException {
        switch (typeInfo.getTypeCode()) {
            case 93: {
                return this.getTimestamp(sqlContext);
            }
            case 92: {
                return this.getTime(sqlContext);
            }
            case 91: {
                return this.getDate(sqlContext);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(sqlContext);
            }
        }
        this.throwConversionNotImplemented(typeInfo.getTypeName());
        return null;
    }
}

