/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.NuoDBTime;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.Value;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ValueTime
extends Value {
    Time value;

    public ValueTime() {
    }

    public ValueTime(Time val) {
        this.value = val;
    }

    public ValueTime(Object val) {
        if (val instanceof Time) {
            this.value = (Time)val;
        } else if (val instanceof Date) {
            this.value = new Time(((Date)val).getTime());
        } else {
            throw new IllegalArgumentException("Unable to convert: " + val.getClass().getName() + " into a Time");
        }
    }

    @Override
    int getType() {
        return 11;
    }

    @Override
    Time getTime() {
        return this.value;
    }

    @Override
    Time getTime(SQLContext context) throws SQLException {
        return this.getTime();
    }

    @Override
    Object getObject() {
        return this.getTime();
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeTime(this.value);
    }

    @Override
    String getString() throws SQLException {
        throw new SQLException("Time requires a TimeZone");
    }

    @Override
    Timestamp getTimestamp() throws SQLException {
        return this.getTimestamp(null);
    }

    @Override
    Timestamp getTimestamp(SQLContext context) throws SQLException {
        Calendar c = NuoDBTime.getCalendar();
        c.clear();
        TimeZone timeZone = context.getTimeZone();
        c.setTimeZone(timeZone);
        c.setTimeInMillis(this.value.getTime());
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        c.setTimeInMillis(System.currentTimeMillis() / 1000L * 1000L);
        c.set(11, hour);
        c.set(12, minute);
        c.set(13, second);
        long tsInMillis = c.getTimeInMillis();
        Timestamp ts = new Timestamp(tsInMillis);
        if (this.value instanceof NuoDBTime) {
            ts.setNanos(((NuoDBTime)this.value).getNanos());
        }
        return ts;
    }

    @Override
    String getString(SQLContext context) throws SQLException {
        if (this.value instanceof NuoDBTime) {
            return ((NuoDBTime)this.value).toString(context.getTimeZone());
        }
        return ValueTime.getTimeFormatter(context.getTimeZone()).format(this.value.toLocalTime());
    }

    @Override
    BigDecimal getBigDecimal() throws SQLException {
        if (this.value instanceof NuoDBTime) {
            NuoDBTime nt = (NuoDBTime)this.value;
            return this.getBigDecimalFromDateType(nt.getTime(), nt.getNanos());
        }
        return new BigDecimal(this.value.getTime()).movePointLeft(3);
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value.getTime());
    }

    public static Time parseTime(SQLContext context, String formattedDate) {
        LocalTime lt = LocalTime.from(Value.getTimeFormatter(context.getTimeZone()).parse(formattedDate));
        long millis = lt.toNanoOfDay() / 1000000L;
        millis -= (long)TimeZone.getDefault().getOffset(millis);
        return new Time(millis);
    }
}

