/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Blob;
import com.nuodb.jdbc.Clob;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.TimeValues;
import com.nuodb.jdbc.TypeInfo;
import com.nuodb.jdbc.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Map;
import java.util.TimeZone;

public abstract class Value
implements TimeValues {
    public static final int Null = 0;
    public static final int typeString = 1;
    public static final int typeChar = 2;
    public static final int Varchar = 3;
    public static final int typeShort = 4;
    public static final int typeInt = 5;
    public static final int typeLong = 6;
    public static final int typeFloat = 7;
    public static final int typeDouble = 8;
    public static final int typeDate = 9;
    public static final int typeTimestamp = 10;
    public static final int typeTimeType = 11;
    public static final int Asciiblob = 12;
    public static final int Binaryblob = 13;
    public static final int BlobPtr = 14;
    public static final int typeSqlTimestamp = 15;
    public static final int ClobPtr = 16;
    public static final int typeArbitrarydecimal = 17;
    public static final int typeNumber = 18;
    public static final int typeBytes = 19;
    public static final int typeBinChar = 20;
    public static final int typeVarBinChar = 21;
    public static final int typeBoolean = 22;
    public static final int typeStream = 23;
    public static final int typeArray = 24;
    public static final int typeTimestampNoTZ = 25;
    protected ValueRef ref = null;
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter timeFormatter = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter timestampFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 9, true).toFormatter();

    void setResultSet(ResultSet resultSet) throws SQLException {
    }

    int getType() {
        return 0;
    }

    abstract void encodeValue(EncodedDataStream var1) throws SQLException;

    abstract String getString() throws SQLException;

    String getString(SQLContext context) throws SQLException {
        return this.getString();
    }

    String getZeroPaddedString(int numZeroes, SQLContext context) throws SQLException {
        return this.getString(context);
    }

    int getScale() {
        return 0;
    }

    byte getByte() throws SQLException {
        this.throwConversionNotImplemented("byte");
        return 0;
    }

    short getShort() throws SQLException {
        this.throwConversionNotImplemented("short");
        return 0;
    }

    int getInt() throws SQLException {
        this.throwConversionNotImplemented("int");
        return 0;
    }

    long getLong() throws SQLException {
        this.throwConversionNotImplemented("long");
        return 0L;
    }

    BigDecimal getBigDecimal() throws SQLException {
        this.throwConversionNotImplemented("bigdecimal");
        return null;
    }

    BigDecimal getBigDecimal(TypeInfo typeInfo) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal != null && typeInfo.getTypeCode() == 2 && typeInfo.getScale() != -1) {
            return bigDecimal.setScale(typeInfo.getScale());
        }
        return bigDecimal;
    }

    BigDecimal getBigDecimalFromDateType(long inMillis, int nanos) {
        long time = inMillis / 1000L;
        int scale = 0;
        if (nanos > 0) {
            scale = 9;
            int pow = 1;
            int pow2 = 1000000000;
            while (nanos % (pow * 10) == 0) {
                pow2 /= 10;
                --scale;
                pow *= 10;
            }
            if (time < 0L) {
                --time;
            }
            time = time * (long)pow2 + (long)(nanos / pow);
        }
        return new BigDecimal(time).movePointLeft(scale);
    }

    byte[] getBytes(SQLContext sqlContext) throws SQLException {
        String string = this.getString(sqlContext);
        if (string == null) {
            return null;
        }
        return string.getBytes();
    }

    java.sql.Blob getBlob(SQLContext context) throws SQLException {
        byte[] value = this.getBytes(context);
        return value == null ? null : new Blob(value);
    }

    java.sql.Clob getClob(SQLContext context) throws SQLException {
        String value = this.getString(context);
        return value == null ? null : new Clob(value);
    }

    boolean getBoolean() throws SQLException {
        return this.getLong() != 0L;
    }

    float getFloat() throws SQLException {
        return (float)this.getDouble();
    }

    double getDouble() throws SQLException {
        double d;
        block3: {
            int scale;
            block2: {
                d = this.getLong();
                if (scale <= 0) break block2;
                for (scale = this.getScale(); scale > 0; --scale) {
                    d /= 10.0;
                }
                break block3;
            }
            if (scale >= 0) break block3;
            while (scale < 0) {
                d *= 10.0;
                ++scale;
            }
        }
        return d;
    }

    Date getDate() throws SQLException {
        this.throwConversionNotImplemented("date");
        return null;
    }

    Timestamp getTimestamp() throws SQLException {
        this.throwConversionNotImplemented("timestamp");
        return null;
    }

    Time getTime() throws SQLException {
        this.throwConversionNotImplemented("time");
        return null;
    }

    Date getDate(SQLContext context) throws SQLException {
        this.throwConversionNotImplemented("date");
        return null;
    }

    Timestamp getTimestamp(SQLContext context) throws SQLException {
        this.throwConversionNotImplemented("timestamp");
        return null;
    }

    Time getTime(SQLContext context) throws SQLException {
        this.throwConversionNotImplemented("time");
        return null;
    }

    Object getObject(TypeInfo typeInfo, SQLContext context) throws SQLException {
        return this.getObject(typeInfo);
    }

    Object getObject(TypeInfo typeInfo) throws SQLException {
        Object result;
        switch (typeInfo.getTypeCode()) {
            case 5: {
                result = this.getShort();
                break;
            }
            case -5: {
                result = this.getLong();
                break;
            }
            case 7: {
                result = Float.valueOf(this.getFloat());
                break;
            }
            case 6: 
            case 8: {
                result = this.getDouble();
                break;
            }
            case 2: 
            case 3: {
                result = this.getBigDecimal(typeInfo);
                break;
            }
            default: {
                result = this.getObject();
            }
        }
        return result;
    }

    Object getObject() throws SQLException {
        this.throwConversionNotImplemented("object");
        return null;
    }

    void throwConversionNotImplemented(String type) throws SQLException {
        throw new SQLException(String.format("%s does not support conversion to %s", this.getClass().getName(), type));
    }

    public static String getString(long value, int scale) {
        return Value.getString(value, scale, 0);
    }

    public static String getString(long value, int scale, int numZeroes) {
        long n;
        boolean needRadix = true;
        if (scale == 0 || value == 0L) {
            StringBuilder appendZeroes = new StringBuilder(numZeroes + 1);
            if (numZeroes > 0) {
                appendZeroes.append(".0");
                --numZeroes;
            }
            while (numZeroes > 0) {
                appendZeroes.append("0");
                --numZeroes;
            }
            return String.valueOf(value) + appendZeroes.toString();
        }
        char[] chars = new char[23 + numZeroes];
        int digits = 0;
        long l = n = value >= 0L ? value : -value;
        while (n > 0L || digits <= scale) {
            if (digits == scale) {
                chars[digits++] = 46;
                needRadix = false;
                if (n == 0L) break;
            }
            chars[digits++] = (char)(48L + n % 10L);
            n /= 10L;
        }
        if (value < 0L) {
            chars[digits++] = 45;
        }
        int i = 0;
        for (int j = digits - 1; i < j; ++i, --j) {
            char c = chars[i];
            chars[i] = chars[j];
            chars[j] = c;
        }
        if (numZeroes > 0 && needRadix) {
            chars[digits++] = 46;
        }
        while (numZeroes > 0) {
            chars[digits++] = 48;
            --numZeroes;
        }
        return new String(chars, 0, digits);
    }

    public InputStream getInputStream() throws SQLException {
        byte[] result = this.getBytes();
        return result == null ? null : new ByteArrayInputStream(result);
    }

    public abstract byte[] getBytes() throws SQLException;

    public InputStream getAsciiStream(SQLContext context) throws SQLException {
        String result = this.getString(context);
        return result == null ? null : new ByteArrayInputStream(result.getBytes());
    }

    public Reader getCharacterStream(SQLContext context) throws SQLException {
        String result = this.getString(context);
        return result == null ? null : new StringReader(result);
    }

    public Ref getRef(TypeInfo typeInfo) {
        if (this.ref == null) {
            this.ref = new ValueRef(typeInfo);
        }
        return this.ref;
    }

    protected static DateTimeFormatter getDateFormatter(TimeZone timeZone) {
        return dateFormatter.withZone(timeZone.toZoneId());
    }

    protected static DateTimeFormatter getTimestampFormatter(TimeZone timeZone) {
        return timestampFormatter.withZone(timeZone.toZoneId());
    }

    protected static DateTimeFormatter getTimeFormatter(TimeZone timeZone) {
        return timeFormatter.withZone(timeZone.toZoneId());
    }

    public static long reScale(long number, int fromScale, int toScale) {
        block3: {
            int delta;
            block2: {
                delta = toScale - fromScale;
                if (delta <= 0) break block2;
                for (int n = 0; n < delta; ++n) {
                    number *= 10L;
                }
                break block3;
            }
            if (delta >= 0) break block3;
            for (int n = 0; n > delta; --n) {
                number /= 10L;
            }
        }
        return number;
    }

    private class ValueRef
    implements Ref {
        private TypeInfo typeInfo;

        public ValueRef(TypeInfo typeInfo) {
            this.typeInfo = typeInfo;
        }

        @Override
        public String getBaseTypeName() throws SQLException {
            return this.typeInfo.getTypeName();
        }

        @Override
        public Object getObject(Map<String, Class<?>> map) throws SQLException {
            Utils.notYetImplemented();
            return null;
        }

        @Override
        public Object getObject() throws SQLException {
            return Value.this.getObject(this.typeInfo);
        }

        @Override
        public void setObject(Object value) throws SQLException {
            Utils.notYetImplemented();
        }
    }
}

