/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EmptyResultSet;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.Utils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class RemDatabaseMetaData
implements DatabaseMetaData {
    RemConnection connection;
    boolean haveMetaData = false;
    private String productName;
    private String productVersion;
    private int databaseMinorVersion;
    private int databaseMajorVersion;
    private int defaultTransactionIsolation;

    RemDatabaseMetaData(RemConnection connect) {
        this.connection = connect;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        if (this.connection.protocolVersion < 18) {
            return false;
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(115);
        this.connection.sendAndReceive(dataStream);
        return dataStream.getBoolean();
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        if (this.connection.protocolVersion < 18) {
            return false;
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(116);
        this.connection.sendAndReceive(dataStream);
        return dataStream.getBoolean();
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return this.connection.protocolVersion < 22;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(117);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        dataStream.encodeString(arg3);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(34);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String[] names = new String[]{"NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION"};
        int[] types = new int[]{12, 4, 12, 12};
        return new EmptyResultSet(names, types, names);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection.protocolVersion < 16) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(113);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaPattern);
        dataStream.encodeString(tableNamePattern);
        dataStream.encodeString(columnNamePattern);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(38);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        dataStream.encodeString(arg3);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (this.connection.protocolVersion < 16) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(114);
        dataStream.encodeString(parentCatalog);
        dataStream.encodeString(parentSchema);
        dataStream.encodeString(parentTable);
        dataStream.encodeString(foreignCatalog);
        dataStream.encodeString(foreignSchema);
        dataStream.encodeString(foreignTable);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (!this.haveMetaData) {
            this.getMetaData();
        }
        return this.databaseMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (!this.haveMetaData) {
            this.getMetaData();
        }
        return this.databaseMinorVersion;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        if (!this.haveMetaData) {
            this.getMetaData();
        }
        return this.productName;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        if (!this.haveMetaData) {
            this.getMetaData();
        }
        return this.productVersion;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        if (!this.haveMetaData) {
            this.getMetaData();
        }
        return this.defaultTransactionIsolation;
    }

    @Override
    public int getDriverMajorVersion() {
        return 24;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "NuoDB JDBC Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "24.0.0";
    }

    @Override
    public ResultSet getExportedKeys(String catalogName, String schemaName, String tableName) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(42);
        dataStream.encodeString(catalogName);
        dataStream.encodeString(schemaName);
        dataStream.encodeString(tableName);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$&#";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnPattern) throws SQLException {
        if (this.connection.protocolVersion < 13) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(111);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaPattern);
        dataStream.encodeString(functionNamePattern);
        dataStream.encodeString(columnPattern);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getFunctions(catalog, schemaPattern, functionNamePattern, null);
    }

    private ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern, String functionType) throws SQLException {
        if (this.connection.protocolVersion < 13) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(110);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaPattern);
        dataStream.encodeString(functionNamePattern);
        dataStream.encodeString(functionType);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalogName, String schemaName, String tableName) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(41);
        dataStream.encodeString(catalogName);
        dataStream.encodeString(schemaName);
        dataStream.encodeString(tableName);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(43);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        dataStream.encodeInt(arg3 ? 1 : 0);
        dataStream.encodeInt(arg4 ? 1 : 0);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,floor,mod,pi,power,radians,rand,round,sin,sqrt,tan";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(40);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schema);
        dataStream.encodeString(table);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        if (this.connection.protocolVersion < 12) {
            throw new SQLFeatureNotSupportedException(String.format("NuoDB server protocol {0} does not support getProcedureColumns", this.connection.protocolVersion));
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(107);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        dataStream.encodeString(arg3);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        if (this.connection.protocolVersion < 12) {
            throw new SQLFeatureNotSupportedException(String.format("NuoDB server protocol {0} does not support getProcedures", this.connection.protocolVersion));
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(106);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "ABS,ACOS,ADD_PARTITION,ASIN,ATAN2,ATAN,BITS,BIT_LENGTH,BREAK,CASCADE,CATCH,CEILING,CHARACTER_LENGTH,COALESCE,CONCAT,CONTAINING,CONVERT_TZ,COS,COT,CURRENT_SCHEMA,DATE_ADD,DATE_SUB,DAYOFWEEK,DAYOFYEAR,DEGREES,DROP_PARTITION,END_FOR,END_FUNCTION,END_IF,END_PROCEDURE,END_TRIGGER,END_TRY,END_WHILE,ENUM,EXTRACT,FLOOR,FOR_UPDATE,GENERATED,IF,IFNULL,KEY,LAST_INSERT_ID,LIMIT,LOCATE,LOWER,LTRIM,MAXVALUE,MOD,MSLEEP,NEXT,NEXT_VALUE,NOW,NULLIF,NVARCHAR,OCTETS,OCTET_LENGTH,OFF,OFFSET,PI,POSITION,POWER,RADIANS,RAND,RECORD_BATCHING,REGEXP,RESTART,RESTRICT,REVERSE,ROUND,RTRIM,SHOW,SIN,SQRT,STARTING,STORE IN,STRING_TYPE,SUBSTRING_INDEX,SUBSTR,TAN,THROW,TINYINT,TRIM,TRY,VAR,VER,WHILE";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(35);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (this.connection.protocolVersion < 13) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(35);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaPattern);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "`";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "concat,lcase,left,length,locate,ltrim,replace,right,rtrim,substring,ucase";
    }

    private String getFunctionNames(String functionType) throws SQLException {
        StringBuilder functions = new StringBuilder();
        ResultSet rset = this.getFunctions(null, null, null, functionType);
        while (rset.next()) {
            if (functions.length() > 0) {
                functions.append(",");
            }
            functions.append(rset.getString("FUNCTION_NAME"));
        }
        rset.close();
        return functions.toString();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaNamePattern, String tableNamePattern) throws SQLException {
        if (this.connection.protocolVersion < 13) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(108);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaNamePattern);
        dataStream.encodeString(tableNamePattern);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaNamePattern, String typeNamePattern) throws SQLException {
        if (this.connection.protocolVersion < 13) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(109);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaNamePattern);
        dataStream.encodeString(typeNamePattern);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.connection.protocolVersion < 16) {
            Utils.notYetImplemented();
        }
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(112);
        dataStream.encodeString(catalog);
        dataStream.encodeString(schemaPattern);
        dataStream.encodeString(tableNamePattern);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(44);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getTables(String arg0, String arg1, String arg2, String[] arg3) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(36);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        if (arg3 == null) {
            dataStream.encodeInt(0);
        } else {
            dataStream.encodeInt(arg3.length);
            for (String anArg3 : arg3) {
                dataStream.encodeString(anArg3);
            }
        }
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "year,month,day,hour,minute,second,dayofweek,dayofyear,extract,current_date,current_time,current_timestamp,now,convert_tz,date,date_add,date_sub,date_from_str,date_to_str";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(45);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public ResultSet getUDTs(String arg0, String arg1, String arg2, int[] arg3) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(118);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        if (arg3 == null) {
            dataStream.encodeInt(0);
        } else {
            dataStream.encodeInt(arg3.length);
            for (int anArg3 : arg3) {
                dataStream.encodeInt(anArg3);
            }
        }
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public String getURL() throws SQLException {
        if (this.connection != null) {
            return this.connection.getConnectionURL();
        }
        return null;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public ResultSet getVersionColumns(String arg0, String arg1, String arg2) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(119);
        dataStream.encodeString(arg0);
        dataStream.encodeString(arg1);
        dataStream.encodeString(arg2);
        this.connection.sendAndReceive(dataStream);
        return this.connection.createMetaDataResultSet(dataStream);
    }

    @Override
    public boolean insertsAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int arg0, int arg1) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int arg0, int arg1) throws SQLException {
        return arg0 == 1003 && arg1 == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int arg0) throws SQLException {
        if (this.connection.protocolVersion < 24) {
            return arg0 == 2;
        }
        return true;
    }

    @Override
    public boolean supportsResultSetType(int arg0) throws SQLException {
        return arg0 == 1003;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int arg0) throws SQLException {
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(100);
        dataStream.encodeInt(arg0);
        this.connection.sendAndReceive(dataStream);
        return dataStream.getInt() != 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    void getMetaData() throws SQLException {
        int item;
        EncodedDataStream dataStream = new EncodedDataStream();
        dataStream.startMessage(33);
        this.connection.sendAndReceive(dataStream);
        block7: while ((item = dataStream.getInt()) != 0) {
            switch (item) {
                case 1: {
                    this.productName = dataStream.getString();
                    continue block7;
                }
                case 2: {
                    this.productVersion = dataStream.getString();
                    continue block7;
                }
                case 3: {
                    this.databaseMinorVersion = dataStream.getInt();
                    continue block7;
                }
                case 4: {
                    this.databaseMajorVersion = dataStream.getInt();
                    continue block7;
                }
                case 5: {
                    this.defaultTransactionIsolation = dataStream.getInt();
                    continue block7;
                }
            }
            dataStream.decode();
        }
        this.haveMetaData = true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }
}

