/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import com.nuodb.impl.security.Cipher;
import com.nuodb.impl.security.CipherAES256CTR;
import com.nuodb.impl.security.CipherRC4;
import com.nuodb.impl.security.SessionCiphersInfo;
import com.nuodb.impl.security.StreamCipher;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;

public class CipherFactory {
    public static StreamCipher getCipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        switch (algorithm) {
            case "RC4": {
                return new CipherRC4();
            }
            case "AES-256-CTR": {
                return new CipherAES256CTR();
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static StreamCipher getCipher(SessionCiphersInfo info, Cipher.CipherMode mode) throws GeneralSecurityException {
        StreamCipher cipher = CipherFactory.getCipher(info.getCipherName());
        cipher.initialize(info.getSessionKey(), mode, info.getIV(mode));
        return cipher;
    }
}

