/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.exceptions.ErrorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;

public class LogUtilities {
    public static void logDebug(ErrorException error, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logDebug");
        log.logDebug(names[0], names[1], names[2], error);
        for (ErrorException suppressed : error.getSuppressedCustom()) {
            LogUtilities.logDebug(suppressed, log);
        }
    }

    public static void logDebug(Exception exception, ILogger log) {
        if (exception instanceof ErrorException) {
            LogUtilities.logDebug((ErrorException)exception, log);
            return;
        }
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logDebug");
        log.logDebug(names[0], names[1], names[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logDebug(String message, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logDebug");
        log.logDebug(names[0], names[1], names[2], message);
    }

    public static void logError(ErrorException error, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logError");
        log.logError(names[0], names[1], names[2], error);
        for (ErrorException suppressed : error.getSuppressedCustom()) {
            LogUtilities.logError(suppressed, log);
        }
    }

    public static void logError(Exception exception, ILogger log) {
        if (exception instanceof ErrorException) {
            LogUtilities.logError((ErrorException)exception, log);
            return;
        }
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logError");
        log.logError(names[0], names[1], names[2], LogUtilities.getExceptionMessage(exception));
    }

    public static void logError(String message, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logError");
        log.logError(names[0], names[1], names[2], message);
    }

    public static void logFatal(Exception exception, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.FATAL, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logFatal");
        log.logFatal(names[0], names[1], names[2], LogUtilities.getExceptionMessage(exception));
        if (exception instanceof ErrorException) {
            for (ErrorException suppressed : ((ErrorException)exception).getSuppressedCustom()) {
                LogUtilities.logFatal(suppressed, log);
            }
        }
    }

    public static void logFatal(String message, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.FATAL, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logFatal");
        log.logFatal(names[0], names[1], names[2], message);
    }

    public static void logFunctionEntrance(ILogger log, Object ... arguments) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logFunctionEntrance");
        log.logFunctionEntrance(names[0], names[1], names[2] + LogUtilities.formatArguments(arguments));
    }

    public static void logInfo(Exception exception, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.INFO, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logInfo");
        log.logInfo(names[0], names[1], names[2], LogUtilities.getExceptionMessage(exception));
        if (exception instanceof ErrorException) {
            for (ErrorException suppressed : ((ErrorException)exception).getSuppressedCustom()) {
                LogUtilities.logInfo(suppressed, log);
            }
        }
    }

    public static void logInfo(String message, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.INFO, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logInfo");
        log.logInfo(names[0], names[1], names[2], message);
    }

    public static void logTrace(Exception exception, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logTrace");
        log.logTrace(names[0], names[1], names[2], LogUtilities.getExceptionMessage(exception));
        if (exception instanceof ErrorException) {
            for (ErrorException suppressed : ((ErrorException)exception).getSuppressedCustom()) {
                LogUtilities.logTrace(suppressed, log);
            }
        }
    }

    public static void logTrace(String message, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logTrace");
        log.logTrace(names[0], names[1], names[2], message);
    }

    public static void logWarning(Exception exception, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.WARNING, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logWarning");
        log.logWarning(names[0], names[1], names[2], LogUtilities.getExceptionMessage(exception));
        if (exception instanceof ErrorException) {
            for (ErrorException suppressed : ((ErrorException)exception).getSuppressedCustom()) {
                LogUtilities.logWarning(suppressed, log);
            }
        }
    }

    public static void logWarning(String message, ILogger log) {
        if (!LogUtilities.shouldLogLevel(LogLevel.WARNING, log)) {
            return;
        }
        String[] names = LogUtilities.getNames("logWarning");
        log.logWarning(names[0], names[1], names[2], message);
    }

    public static boolean shouldLogLevel(LogLevel level, ILogger log) {
        return log.isEnabled() && level.ordinal() <= log.getLogLevel().ordinal();
    }

    private static String formatArguments(Object ... arguments) {
        StringBuilder formattedArguments = new StringBuilder("(");
        if (null == arguments) {
            formattedArguments.append("null");
        } else {
            boolean isFirst = true;
            for (Object obj : arguments) {
                if (!isFirst) {
                    formattedArguments.append(", ");
                }
                isFirst = false;
                if (null == obj) {
                    formattedArguments.append("null");
                    continue;
                }
                if (obj instanceof String) {
                    formattedArguments.append("\"").append(obj.toString()).append("\"");
                    continue;
                }
                if (obj instanceof Iterable) {
                    formattedArguments.append("<");
                    isFirst = true;
                    Iterator itr = ((Iterable)obj).iterator();
                    while (itr.hasNext()) {
                        if (!isFirst) {
                            formattedArguments.append(", ");
                        }
                        isFirst = false;
                        Object item = itr.next();
                        if (null == item) {
                            formattedArguments.append("null");
                            continue;
                        }
                        formattedArguments.append(item.toString());
                    }
                    isFirst = false;
                    formattedArguments.append(">");
                    continue;
                }
                formattedArguments.append(obj.toString());
            }
        }
        return formattedArguments.append(")").toString();
    }

    private static String getExceptionMessage(Exception error) {
        StringWriter sw = new StringWriter();
        error.printStackTrace(new PrintWriter(sw));
        return error.getLocalizedMessage() + "\n" + sw.toString();
    }

    private static String[] getNames(String logFunction) {
        StackTraceElement element = LogUtilities.getStackElementAbove(logFunction);
        String[] names = new String[3];
        names[2] = element.getMethodName();
        try {
            Class<?> originatingClass = Class.forName(element.getClassName());
            names[1] = originatingClass.getSimpleName();
            names[0] = "";
            Package originatingPackage = originatingClass.getPackage();
            if (null != originatingPackage) {
                names[0] = originatingPackage.getName();
            }
        }
        catch (ClassNotFoundException e) {
            names[0] = "<error>";
            names[1] = element.getClassName();
        }
        if (names[2].equals("<init>")) {
            names[2] = names[1];
        }
        return names;
    }

    private static StackTraceElement getStackElementAbove(String functionName) {
        boolean returnNextFunction = false;
        for (StackTraceElement s : Thread.currentThread().getStackTrace()) {
            if (returnNextFunction) {
                return s;
            }
            if (!s.getMethodName().equals(functionName)) continue;
            returnNextFunction = true;
        }
        return Thread.currentThread().getStackTrace()[3];
    }
}

