/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.jdbc.VerticaConnectionSharedImpl;
import com.vertica.jdbc.VerticaDatabaseErrorInfo;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.support.LogUtilities;
import java.sql.SQLException;
import java.util.concurrent.Executor;

public class VerticaJdbc4ConnectionImpl
extends S4Connection
implements VerticaConnection {
    int m_milliout;
    String m_schema;
    protected VConnection m_vconn;

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.m_milliout;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.m_milliout = n;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return this.m_schema;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.m_schema = string;
    }

    protected VerticaJdbc4ConnectionImpl(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
        LogUtilities.logFunctionEntrance(iConnection.getConnectionLog(), iConnection, string);
        this.m_vconn = (VConnection)iConnection;
    }

    @Override
    public Object getProperty(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
        return VerticaConnectionSharedImpl.getInstance().getProperty(this.m_vconn, string);
    }

    @Override
    public void setProperty(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
        VerticaConnectionSharedImpl.getInstance().setProperty(this.m_vconn, string, object);
    }

    @Override
    public VerticaDatabaseErrorInfo getLastDatabaseError() {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        return VerticaConnectionSharedImpl.getInstance().getLastDatabaseError(this.m_vconn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        this.m_vconn.lock();
        try {
            super.commit();
        }
        finally {
            this.m_vconn.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        this.m_vconn.lock();
        try {
            super.rollback();
        }
        finally {
            this.m_vconn.unlock();
        }
    }
}

