/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactBase;
import com.onseven.dbvis.util.artifact.ArtifactVersion;
import com.onseven.dbvis.util.artifact.MavenArtifactVersion;
import com.onseven.dbvis.util.artifact.b.b;
import java.io.PrintStream;
import java.util.Objects;

public class MavenArtifact
extends ArtifactBase {
    public static final String JAR_EXTENSION = "jar";
    @JsonProperty(value="groupId")
    private String groupId;
    @JsonProperty(value="artifactId")
    private String artifactId;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="extension")
    private String extension;
    @JsonProperty(value="DownloadDependencies")
    private boolean doDownloadDependencies;
    @JsonProperty(value="versionRange")
    private String versionRange;

    @JsonIgnore
    public boolean isJarExtension() {
        return this.extension == null || JAR_EXTENSION.equalsIgnoreCase(this.extension);
    }

    public MavenArtifact(MavenArtifact mavenArtifact) {
        this.initFrom(mavenArtifact);
        this.groupId = mavenArtifact.groupId;
        this.artifactId = mavenArtifact.artifactId;
        this.version = mavenArtifact.version;
        this.doDownloadDependencies = mavenArtifact.doDownloadDependencies;
        this.extension = mavenArtifact.extension;
        this.versionRange = mavenArtifact.versionRange;
    }

    public MavenArtifact() {
    }

    public MavenArtifact(String string, String string2, String string3) {
        this.groupId = string;
        this.artifactId = string2;
        this.version = string3;
    }

    public MavenArtifact(String string, String string2, String string3, String string4) {
        this.groupId = string;
        this.artifactId = string2;
        this.version = string3;
        this.extension = string4;
    }

    @Override
    public ArtifactVersion getArtifactVersion() {
        return new MavenArtifactVersion(this.version);
    }

    @Override
    public Artifact createCopy() {
        return new MavenArtifact(this);
    }

    @Override
    public String shortId() {
        return this.artifactId != null ? this.artifactId : "Undefined maven artifact";
    }

    @Override
    public String getIdString() {
        if (this.groupId == null || this.groupId.isEmpty() || this.artifactId == null || this.artifactId.isEmpty()) {
            return "Not Defined";
        }
        return b.b(this.groupId, this.artifactId, this.version, this.extension);
    }

    @Override
    public Artifact._b getType() {
        return Artifact._b.f;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String string) {
        this.artifactId = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public boolean doDownloadDependencies() {
        return this.doDownloadDependencies;
    }

    public void setDoDownloadDependencies(boolean bl) {
        this.doDownloadDependencies = bl;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public MavenArtifact setVersionRange(String string) {
        this.versionRange = string;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MavenArtifact)) {
            return false;
        }
        MavenArtifact mavenArtifact = (MavenArtifact)object;
        return Objects.equals(this.groupId, mavenArtifact.groupId) && Objects.equals(this.artifactId, mavenArtifact.artifactId) && Objects.equals(this.version, mavenArtifact.version) && Objects.equals(this.extension, mavenArtifact.extension) && Objects.equals(this.versionRange, mavenArtifact.versionRange) && this.areSame(this);
    }

    public boolean areSameDownloadSettings(MavenArtifact mavenArtifact) {
        if (mavenArtifact == null) {
            return false;
        }
        return Objects.equals(this.groupId, mavenArtifact.groupId) && Objects.equals(this.artifactId, mavenArtifact.artifactId) && Objects.equals(this.version, mavenArtifact.version) && Objects.equals(this.extension, mavenArtifact.extension) && Objects.equals(this.doDownloadDependencies, mavenArtifact.doDownloadDependencies) && Objects.equals(this.isActive(), mavenArtifact.isActive());
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.extension, this.versionRange);
    }

    public String toString() {
        return "MavenArtifact{" + this.idsToString() + "}";
    }

    private String idsToString() {
        String string = this.extension != null ? "groupId='" + this.groupId + "', artifactId='" + this.artifactId + ", extension='" + this.extension + "', version='" + this.version + "'" : "groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "'";
        if (this.versionRange != null) {
            string = string + ", versionRange='" + this.versionRange + "'";
        }
        return string;
    }

    @Override
    public void dump(PrintStream printStream) {
        printStream.print("     Artifact:" + this.getType());
        printStream.print("  " + this.idsToString());
    }

    @Override
    protected String specificExtendedString() {
        return b.b(this.groupId, this.artifactId, this.version, this.extension);
    }
}

