/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactBase;
import com.onseven.dbvis.util.artifact.ArtifactVersion;
import com.onseven.dbvis.util.dc;
import com.onseven.dbvis.util.fc;
import com.onseven.dbvis.util.file.d;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FolderArtifact
extends ArtifactBase {
    private static final DirectoryStream.Filter<Path> JAR_FILTER = fc.d(d.i.c());
    @JsonProperty(value="DirPath")
    private String dirPath;

    @JsonCreator
    public FolderArtifact() {
    }

    private FolderArtifact(FolderArtifact folderArtifact) {
        this.initFrom(folderArtifact);
        this.dirPath = folderArtifact.dirPath;
    }

    public FolderArtifact(String string) {
        this.dirPath = string;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String string) {
        this.dirPath = string;
    }

    @Override
    public ArtifactVersion getArtifactVersion() {
        return null;
    }

    @Override
    public Artifact createCopy() {
        return new FolderArtifact(this);
    }

    @Override
    public String shortId() {
        return this.dirPath != null ? new File(this.dirPath).getName() : "Undefined local dir";
    }

    @Override
    public String getIdString() {
        return this.dirPath != null ? this.dirPath : "Undefined local dir";
    }

    @Override
    public Artifact._b getType() {
        return Artifact._b.c;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FolderArtifact)) {
            return false;
        }
        FolderArtifact folderArtifact = (FolderArtifact)object;
        return Objects.equals(this.dirPath, folderArtifact.dirPath) && this.areSame(this);
    }

    public List<File> listJarFiles() throws IOException {
        return FolderArtifact.listJarFiles(this.dirPath);
    }

    public static List<File> listJarFiles(String string) throws IOException {
        if (string == null) {
            return Collections.emptyList();
        }
        Path path = Paths.get(string, new String[0]);
        ArrayList<File> arrayList = new ArrayList<File>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, JAR_FILTER);){
            for (Path path2 : directoryStream) {
                File file = path2.toFile();
                if (!dc.b(file)) continue;
                arrayList.add(file);
            }
        }
        return arrayList;
    }

    public int hashCode() {
        return Objects.hash(this.dirPath);
    }

    @Override
    public void dump(PrintStream printStream) {
        printStream.print("     Artifact:" + this.getType());
        printStream.print("   " + this.dirPath);
    }

    @Override
    protected String specificExtendedString() {
        return this.dirPath;
    }
}

