/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlCData;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.FolderArtifact;
import com.onseven.dbvis.util.artifact.LocalArtifact;
import com.onseven.dbvis.util.artifact.MavenArtifact;
import com.onseven.dbvis.util.artifact.b;
import com.onseven.dbvis.util.artifact.remote.RemoteArtifact;
import java.util.Objects;

@JsonSubTypes(value={@JsonSubTypes.Type(value=LocalArtifact.class), @JsonSubTypes.Type(value=RemoteArtifact.class), @JsonSubTypes.Type(value=FolderArtifact.class), @JsonSubTypes.Type(value=MavenArtifact.class), @JsonSubTypes.Type(value=b.class)})
public abstract class ArtifactBase
implements Artifact {
    @JsonProperty(value="Label")
    private String label;
    @JsonProperty(value="Description")
    @JacksonXmlCData
    private String description;
    @JsonProperty(value="Active", defaultValue="true", required=false)
    private boolean active = true;

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setLabel(String string) {
        this.label = string;
    }

    @Override
    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void initFrom(ArtifactBase artifactBase) {
        this.label = artifactBase.label;
        this.description = artifactBase.description;
        this.active = artifactBase.active;
    }

    public boolean areSame(ArtifactBase artifactBase) {
        if (this == artifactBase) {
            return true;
        }
        if (!(artifactBase instanceof ArtifactBase)) {
            return false;
        }
        ArtifactBase artifactBase2 = artifactBase;
        return this.active == artifactBase2.active && Objects.equals(this.label, artifactBase2.label) && Objects.equals(this.description, artifactBase2.description);
    }

    @Override
    public String toExtendedString() {
        String string = this.active ? "Activated" : "Deactivated";
        return " " + this.getType().name() + " Artifact (" + string + ") " + this.specificExtendedString();
    }

    protected abstract String specificExtendedString();
}

