/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.comp.CXMLReader;
import oracle.xml.comp.CXMLStream;
import oracle.xml.comp.CXMLWriter;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.ContentModel;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DTDDecl;
import oracle.xml.parser.v2.ParserState;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxName;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementDecl
extends XMLNode
implements Serializable,
Externalizable {
    public static final byte EMPTY = 1;
    public static final byte ANY = 2;
    public static final byte MIXED = 3;
    public static final byte ELEMENTS = 4;
    public static final int ELEMENT = 1001;
    public static final int OR = 1002;
    public static final int COMMA = 1003;
    public static final int QMARK = 1004;
    public static final int ASTERISK = 1005;
    public static final int PLUS = 1006;
    static final int EXTERNAL = 128;
    static final int ELEMENT_DECLARED = 65536;
    static final int ID_ATTR_DECL = 131072;
    private static final int EDECL_DTD = 0;
    private static final int EDECL_QXNAME = 1;
    private static final int EDECL_CMODEL = 2;
    private static final int EDECL_ADECLS = 3;
    private static final int EDECL_DATASZ = 4;

    public ElementDecl() {
        this.xdkSetContentModel(new ContentModel());
        this.setNodeFlag(65536);
    }

    ElementDecl(XMLDocument xMLDocument) {
        super(xMLDocument);
        this.xdkSetContentModel(new ContentModel());
        this.setNodeFlag(65536);
    }

    @Override
    public short getNodeType() {
        return 13;
    }

    @Override
    public String getNodeName() {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetQxName().getQName();
            }
            case 2: {
                return this.xdbGetNodeName(this.xdbGetCtx(), this.nodeId);
            }
        }
        return null;
    }

    public boolean validateContent(Element element) {
        switch (this.flags & 7) {
            case 1: {
                ContentModel contentModel = this.xdkGetContentModel();
                if (contentModel.type == 1) {
                    return !element.hasChildNodes();
                }
                if (contentModel.type == 2) {
                    return true;
                }
                return contentModel.validateContent((XMLElement)element, this.xdkGetDTD());
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    public Vector expectedElements(Element element) {
        switch (this.flags & 7) {
            case 1: {
                ContentModel contentModel = this.xdkGetContentModel();
                if (contentModel.type == 1 || contentModel.type == 2) {
                    return this.getContentElements();
                }
                return contentModel.expectedElements((XMLElement)element, this.xdkGetDTD());
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public NamedNodeMap getAttrDecls() {
        switch (this.flags & 7) {
            case 1: {
                Vector vector = this.xdkGetAttrDecls();
                if (vector != null) {
                    return new DTDDecl(vector);
                }
                return null;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public final AttrDecl findAttrDecl(String string) {
        switch (this.flags & 7) {
            case 1: {
                Vector vector = this.xdkGetAttrDecls();
                if (vector != null) {
                    QxName qxName = QxNameHash.create("", string, "", string);
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        AttrDecl attrDecl = (AttrDecl)enumeration.nextElement();
                        if (!qxName.equals(attrDecl.xdkGetQxName())) continue;
                        return attrDecl;
                    }
                }
                return null;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public int getContentType() {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetContentModel().type;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return -1;
    }

    public final Vector getContentElements() {
        switch (this.flags & 7) {
            case 1: {
                ContentModel contentModel = this.xdkGetContentModel();
                if (!this.isNodeFlag(65536)) {
                    return null;
                }
                Vector vector = new Vector();
                if (contentModel.type == 1) {
                    return null;
                }
                if (contentModel.type == 2) {
                    DTD dTD = this.xdkGetDTD();
                    if (dTD == null) {
                        return null;
                    }
                    Enumeration enumeration = dTD.xdkGetElementDecls().elements();
                    while (enumeration.hasMoreElements()) {
                        vector.addElement(((ElementDecl)enumeration.nextElement()).getNodeName());
                    }
                } else {
                    vector = (Vector)contentModel.getContentElements().clone();
                }
                return vector;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    public final Node getParseTree() {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetContentModel().getRoot();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CXMLStream cXMLStream = new CXMLStream();
        cXMLStream.setObjectOutput(objectOutput);
        CXMLWriter cXMLWriter = (CXMLWriter)cXMLStream.getInfosetWriter();
        cXMLWriter.init();
        this.writeNodeInfo(cXMLWriter, true, false);
        cXMLWriter.close();
        cXMLStream.close();
    }

    @Override
    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl, boolean bl2) {
        if (!(infosetWriter instanceof CXMLWriter)) {
            return;
        }
        try {
            Vector vector;
            CXMLWriter cXMLWriter = (CXMLWriter)infosetWriter;
            cXMLWriter.writeByte(19);
            cXMLWriter.writeUTF(this.getNodeName());
            ContentModel contentModel = this.xdkGetContentModel();
            cXMLWriter.writeByte(contentModel.type);
            if (contentModel.type != 1 && contentModel.type != 2) {
                cXMLWriter.writeUTF(contentModel.getStringValue());
            }
            cXMLWriter.writeBoolean(this.isNodeFlag(65536));
            cXMLWriter.writeBoolean(this.isNodeFlag(131072));
            cXMLWriter.writeBoolean(this.isNodeFlag(128));
            if (bl && (vector = this.xdkGetAttrDecls()) != null) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    AttrDecl attrDecl = (AttrDecl)vector.elementAt(i);
                    attrDecl.writeNodeInfo(infosetWriter, false, false);
                }
            }
            cXMLWriter.writeByte(22);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        CXMLStream cXMLStream = new CXMLStream();
        cXMLStream.setObjectInput(objectInput);
        CXMLReader cXMLReader = (CXMLReader)cXMLStream.getInfosetReader();
        cXMLReader.init();
        this.readNodeInfo(cXMLReader, true);
    }

    @Override
    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        if (!(infosetReader instanceof CXMLReader)) {
            return;
        }
        try {
            CXMLReader cXMLReader = (CXMLReader)infosetReader;
            byte by = cXMLReader.readByte();
            String string = cXMLReader.readUTF();
            this.xdkSetQxName(QxNameHash.create("", string, "", string));
            ContentModel contentModel = this.xdkGetContentModel();
            contentModel.type = cXMLReader.readByte();
            if (contentModel.type != 1 && contentModel.type != 2) {
                contentModel.parseContentModel(cXMLReader.readUTF());
            }
            this.setNodeFlag(65536, cXMLReader.readBoolean());
            this.setNodeFlag(131072, cXMLReader.readBoolean());
            this.setNodeFlag(128, cXMLReader.readBoolean());
            if (bl) {
                XMLDocument xMLDocument = this.getDocument();
                XMLNode xMLNode = null;
                block6: while (true) {
                    switch (cXMLReader.peekByte()) {
                        case 32: {
                            xMLNode = xMLDocument.createNodeFromType((short)14);
                            xMLNode.readNodeInfo(infosetReader, false);
                            this.addAttrDecl((AttrDecl)xMLNode);
                            continue block6;
                        }
                        case 22: {
                            cXMLReader.readByte();
                            return;
                        }
                    }
                    break;
                }
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DTD xdkGetDTD() {
        return (DTD)this.data[(int)this.nodeId + 0];
    }

    void xdkSetDTD(DTD dTD) {
        this.data[(int)this.nodeId + 0] = dTD;
    }

    @Override
    QxName xdkGetQxName() {
        return (QxName)this.data[(int)this.nodeId + 1];
    }

    @Override
    void xdkSetQxName(QxName qxName) {
        this.data[(int)this.nodeId + 1] = qxName;
    }

    ContentModel xdkGetContentModel() {
        return (ContentModel)this.data[(int)this.nodeId + 2];
    }

    void xdkSetContentModel(ContentModel contentModel) {
        this.data[(int)this.nodeId + 2] = contentModel;
    }

    Vector xdkGetAttrDecls() {
        return (Vector)this.data[(int)this.nodeId + 3];
    }

    void xdkSetAttrDecls(Vector vector) {
        this.data[(int)this.nodeId + 3] = vector;
    }

    @Override
    int xdkGetNodeArraySize() {
        return 4;
    }

    boolean checkContent(ParserState parserState, String string) throws XMLParseException {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetContentModel().checkContent(parserState, string);
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    boolean checkAcceptState(ParserState parserState) throws XMLParseException {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetContentModel().checkAcceptState(parserState);
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return false;
    }

    final Vector expectedElements(int n) {
        switch (this.flags & 7) {
            case 1: {
                ContentModel contentModel = this.xdkGetContentModel();
                if (contentModel.type == 1) {
                    return new Vector(0);
                }
                return contentModel.expectedElements(n);
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    @Override
    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        ElementDecl elementDecl = (ElementDecl)xMLDocument.createNodeFromType((short)13);
        elementDecl.xdkSetDTD(this.xdkGetDTD());
        elementDecl.xdkSetQxName(this.xdkGetQxName());
        elementDecl.xdkSetContentModel(this.xdkGetContentModel());
        elementDecl.setNodeFlag(65536, this.isNodeFlag(65536));
        elementDecl.setNodeFlag(128, this.isNodeFlag(128));
        short s = this.getUserDataHandlerOpcode(n);
        this.callUserDataHandlers(s, elementDecl);
        if ((n & 8) == 8) {
            return elementDecl;
        }
        Vector vector = this.xdkGetAttrDecls();
        if (vector == null) {
            return elementDecl;
        }
        this.setNodeFlag(131072, this.isNodeFlag(131072));
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            AttrDecl attrDecl = (AttrDecl)vector.elementAt(i);
            elementDecl.addAttrDecl((AttrDecl)attrDecl.xdkCopyNode(xMLDocument, n));
        }
        return elementDecl;
    }

    final void addAttrDecl(AttrDecl attrDecl) {
        switch (this.flags & 7) {
            case 1: {
                Vector<AttrDecl> vector = this.xdkGetAttrDecls();
                if (vector == null) {
                    vector = new Vector<AttrDecl>();
                    this.xdkSetAttrDecls(vector);
                }
                vector.addElement(attrDecl);
                attrDecl.xdkSetParentNode(this);
                return;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    final int getAttrDeclIndex(String string) {
        switch (this.flags & 7) {
            case 1: {
                Vector vector = this.xdkGetAttrDecls();
                if (vector != null) {
                    QxName qxName = QxNameHash.create("", string, "", string);
                    for (int i = 0; i < vector.size(); ++i) {
                        AttrDecl attrDecl = (AttrDecl)vector.elementAt(i);
                        if (!qxName.equals(attrDecl.xdkGetQxName())) continue;
                        return i;
                    }
                }
                return -1;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return -1;
    }

    final void removeAttrDeclAt(int n) {
        switch (this.flags & 7) {
            case 1: {
                Vector vector = this.xdkGetAttrDecls();
                if (vector != null) {
                    vector.removeElementAt(n);
                }
                return;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
    }

    final XMLElement getContentModelRoot(XMLDocument xMLDocument, ElementDecl elementDecl) {
        switch (this.flags & 7) {
            case 1: {
                return this.xdkGetContentModel().d2sdom(xMLDocument, elementDecl);
            }
            case 2: {
                throw new XMLDOMException(9, 21997, this.getXMLError());
            }
        }
        return null;
    }

    @Override
    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        Vector vector;
        if (bl == this.isNodeFlag(128) && this.isNodeFlag(65536)) {
            xMLOutputStream.writeChars("<!ELEMENT ");
            xMLOutputStream.writeChars(this.getNodeName() + " ");
            this.xdkGetContentModel().print(xMLOutputStream);
            xMLOutputStream.writeChars(">");
            xMLOutputStream.writeNewLine();
        }
        if ((vector = this.xdkGetAttrDecls()) != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                AttrDecl attrDecl = (AttrDecl)vector.elementAt(i);
                attrDecl.print(xMLOutputStream, bl);
            }
        }
    }
}

