/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformation;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanInformationCache;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanIntrospection;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.statement.JavaType;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanRowHandler<T>
implements RowHandler<T> {
    private Logger logger_ = Log.getAPILogger();
    private boolean isRowHandlerForQoc_;
    protected Class<T> beanClass_;
    protected int currentResultSetHashCode_ = -1;
    protected BeanInformation beanInformation_;
    protected Method genericSetMethod_;
    protected Method genericSetMethodWithParameters_;
    protected BeanPropertyInformation[] beanPropertyInformation_;
    protected String[] columnLabels_;
    protected String[] tableNames_;
    protected int minCol_;
    protected int maxCol_;
    protected int[] idColumns_;
    protected boolean usedRow_;

    public BeanRowHandler(Class<T> clazz) {
        this.beanClass_ = clazz;
        this.beanInformation_ = BeanInformationCache.getBeanInformation(clazz);
    }

    public BeanRowHandler(Class<T> clazz, BeanInformation beanInformation) {
        this.beanClass_ = clazz;
        this.beanInformation_ = beanInformation;
    }

    @Override
    public T handle(ResultSet resultSet, T t2) throws SQLException {
        this.mapResultSetToBean(resultSet);
        if (this.isRowHandlerForQoc_) {
            return (T)resultSet.getObject(1);
        }
        try {
            if (t2 == null) {
                t2 = this.beanClass_.newInstance();
            }
            this.updateX(resultSet, t2);
            return t2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_ACC_DEFCONST", new Object[0]), illegalAccessException, 10010);
        }
        catch (InstantiationException instantiationException) {
            throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_DEFCONST_MISS", new Object[0]), instantiationException, 10011);
        }
    }

    protected void mapResultSetToBean(ResultSet resultSet) throws SQLException {
        String[] stringArray;
        if (resultSet.hashCode() == this.currentResultSetHashCode_) {
            return;
        }
        this.currentResultSetHashCode_ = resultSet.hashCode();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        if (n2 == 1) {
            stringArray = resultSetMetaData.getColumnClassName(1);
            try {
                if (this.beanClass_.isAssignableFrom(BeanRowHandler.getClassForNameUseThreadContextClassLoader((String)stringArray))) {
                    this.isRowHandlerForQoc_ = true;
                    return;
                }
            }
            catch (Exception exception) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_CLASS_NOT_FOUND_NAME", new Object[0]), exception, 10012);
            }
        }
        this.beanPropertyInformation_ = new BeanPropertyInformation[n2];
        if (this.columnLabels_ == null) {
            this.minCol_ = 0;
            this.maxCol_ = n2 - 1;
            this.columnLabels_ = new String[n2];
            stringArray = this.columnLabels_;
            this.tableNames_ = new String[n2];
            String[] stringArray2 = this.tableNames_;
            Map<String, BeanPropertyInformation> map = this.beanInformation_.getBeanPropertyMap();
            for (int i10 = 1; i10 <= n2; ++i10) {
                BeanPropertyInformation beanPropertyInformation;
                int n3 = i10 - 1;
                stringArray[n3] = resultSetMetaData.getColumnLabel(i10).toLowerCase();
                if (resultSetMetaData.getTableName(i10) != null) {
                    stringArray2[n3] = resultSetMetaData.getTableName(i10).toLowerCase();
                }
                if ((beanPropertyInformation = BeanIntrospection.getPropertyUsingTableColumnName(stringArray[n3], stringArray2[n3], map)) != null && !beanPropertyInformation.hasJoinPoint_) {
                    this.beanPropertyInformation_[n3] = beanPropertyInformation;
                }
                if (this.beanPropertyInformation_[n3] != null) continue;
                this.genericSetMethodWithParameters_ = this.beanInformation_.getGenericSetWithParamsMethod();
                if (null != this.genericSetMethodWithParameters_) continue;
                this.genericSetMethod_ = this.beanInformation_.getGenericSetMethod();
                if (null != this.genericSetMethod_) continue;
                WarningFactory.createPureQueryWarningForRuntimeLogOnly(Messages.getText("WARN_BEAN_UPD", "" + stringArray2[n3] + "." + stringArray[n3], this.beanClass_.getCanonicalName()), 10291, this.getClass(), "mapResultSetToBean (ResultSet resultSet)");
            }
        } else {
            int n4;
            int n5;
            this.minCol_ = n2;
            this.maxCol_ = 0;
            stringArray = new ArrayList();
            Map<String, BeanPropertyInformation> map = this.beanInformation_.getBeanPropertyMap();
            for (n5 = 1; n5 <= n2; ++n5) {
                n4 = n5 - 1;
                BeanPropertyInformation beanPropertyInformation = this.beanInformation_.getPropertyByTablecolumn(this.columnLabels_[n4], this.tableNames_[n4]);
                if (beanPropertyInformation == null) {
                    beanPropertyInformation = BeanIntrospection.getPropertyUsingTableColumnName(this.columnLabels_[n4], this.tableNames_[n4], map);
                }
                if (beanPropertyInformation == null || beanPropertyInformation.hasJoinPoint_) continue;
                this.beanPropertyInformation_[n4] = beanPropertyInformation;
                if (beanPropertyInformation.isIdProperty()) {
                    stringArray.add(n5);
                }
                if (this.minCol_ == n2) {
                    this.minCol_ = n4;
                }
                if (n4 <= this.maxCol_) continue;
                this.maxCol_ = n4;
            }
            this.idColumns_ = new int[stringArray.size()];
            n4 = this.idColumns_.length;
            for (n5 = 0; n5 < n4; ++n5) {
                this.idColumns_[n5] = (Integer)stringArray.get(n5);
            }
            if (this.logger_.isLoggable(Level.ALL)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.beanInformation_.getBeanClass().getName()).append(" column to bean property map:\n");
                for (n4 = this.minCol_; n4 <= this.maxCol_; ++n4) {
                    if (this.beanPropertyInformation_[n4] != null) {
                        stringBuilder.append("Column ");
                        if (this.tableNames_[n4] != null) {
                            stringBuilder.append(this.tableNames_[n4]).append('.');
                        }
                        stringBuilder.append(this.columnLabels_[n4]).append(" => ").append(this.beanPropertyInformation_[n4].getCaseSensitivePropertyName()).append('\n');
                        continue;
                    }
                    stringBuilder.append("Column ");
                    if (this.tableNames_[n4] != null) {
                        stringBuilder.append(this.tableNames_[n4]).append('.');
                    }
                    stringBuilder.append(this.columnLabels_[n4]).append(" => ").append("none\n");
                }
                this.logger_.logp(Level.ALL, "BeanRowHandler", "mapResultSetToBean", stringBuilder.toString());
            }
        }
    }

    private Object getColumnValue(ResultSet resultSet, int n2, JavaType javaType) throws SQLException {
        Object object = null;
        switch (javaType) {
            case STRING: {
                object = resultSet.getString(n2);
                break;
            }
            case BOOLEAN: {
                object = resultSet.getBoolean(n2);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_BOOLEAN: {
                object = resultSet.getBoolean(n2);
                break;
            }
            case BYTE: {
                object = resultSet.getByte(n2);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_BYTE: {
                object = resultSet.getByte(n2);
                break;
            }
            case SHORT: {
                object = resultSet.getShort(n2);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_SHORT: {
                object = resultSet.getShort(n2);
                break;
            }
            case INTEGER: {
                object = resultSet.getInt(n2);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_INTEGER: {
                object = resultSet.getInt(n2);
                break;
            }
            case LONG: {
                object = resultSet.getLong(n2);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_LONG: {
                object = resultSet.getLong(n2);
                break;
            }
            case FLOAT: {
                object = Float.valueOf(resultSet.getFloat(n2));
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_FLOAT: {
                object = Float.valueOf(resultSet.getFloat(n2));
                break;
            }
            case DOUBLE: {
                object = resultSet.getDouble(n2);
                if (!resultSet.wasNull()) break;
                object = null;
                break;
            }
            case SIMPLE_DOUBLE: {
                object = resultSet.getDouble(n2);
                break;
            }
            case BYTE_ARRAY: {
                object = resultSet.getBytes(n2);
                break;
            }
            case DATE: {
                object = resultSet.getDate(n2);
                break;
            }
            case TIME: {
                object = resultSet.getTime(n2);
                break;
            }
            case TIMESTAMP: {
                object = resultSet.getTimestamp(n2);
                break;
            }
            case TIMESTAMPTZ: {
                object = StatementUtilities.getDBTimestamp(resultSet, n2);
                break;
            }
            case BIGDECIMAL: {
                object = resultSet.getBigDecimal(n2);
                break;
            }
            case BLOB: {
                object = resultSet.getBlob(n2);
                break;
            }
            case CLOB: {
                object = resultSet.getClob(n2);
                break;
            }
            case INPUTSTREAM: {
                object = resultSet.getBinaryStream(n2);
                break;
            }
            case READER: {
                object = resultSet.getCharacterStream(n2);
                break;
            }
            case OBJECT: {
                object = resultSet.getObject(n2);
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateObject(String string, ResultSet resultSet, Object object, int n2) throws SQLException, IllegalAccessException, InvocationTargetException {
        BeanPropertyInformation beanPropertyInformation = this.beanPropertyInformation_[n2 - 1];
        if (null != beanPropertyInformation) {
            Method method = beanPropertyInformation.writeMethod_;
            JavaType javaType = beanPropertyInformation.propertyType_;
            String string2 = beanPropertyInformation.getFormatterClassQualifiedName();
            if (string2 == null) {
                if (null != method) {
                    method.invoke(object, this.getColumnValue(resultSet, n2, javaType));
                    return;
                } else {
                    if (null == beanPropertyInformation.fieldFromIntrospector_) return;
                    beanPropertyInformation.fieldFromIntrospector_.set(object, this.getColumnValue(resultSet, n2, javaType));
                }
                return;
            } else {
                try {
                    String string3 = beanPropertyInformation.getFormattingOptions();
                    Class<?> clazz = Class.forName(string2, true, BeanRowHandler.getContextClassloader());
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object obj = constructor.newInstance(string3);
                    Method method2 = BeanRowHandler.getDeclaredMethodForClass(clazz, "format", Object.class);
                    if (null != method) {
                        method.invoke(object, method2.invoke(obj, this.getColumnValue(resultSet, n2, JavaType.OBJECT)));
                        return;
                    }
                    if (null == beanPropertyInformation.fieldFromIntrospector_) return;
                    beanPropertyInformation.fieldFromIntrospector_.set(object, method2.invoke(obj, this.getColumnValue(resultSet, n2, JavaType.OBJECT)));
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_CLASS_NOT_FOUND_NAME", string2), classNotFoundException, 11214);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "format", string2), noSuchMethodException, 11215);
                }
                catch (InstantiationException instantiationException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "format", string2), instantiationException, 11216);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_BAD_PARSE_OR_FORMAT_METHOD", "format", string2), privilegedActionException, 11726);
                }
            }
        } else if (null != this.genericSetMethodWithParameters_) {
            if ("TIMESTAMP WITH TIME ZONE".equals(resultSet.getMetaData().getColumnTypeName(n2))) {
                this.genericSetMethodWithParameters_.invoke(object, string, this.tableNames_[n2 - 1], n2, StatementUtilities.getDBTimestamp(resultSet, n2));
                return;
            } else {
                this.genericSetMethodWithParameters_.invoke(object, string, this.tableNames_[n2 - 1], n2, resultSet.getObject(n2));
            }
            return;
        } else {
            if (null == this.genericSetMethod_) return;
            if ("TIMESTAMP WITH TIME ZONE".equals(resultSet.getMetaData().getColumnTypeName(n2))) {
                this.genericSetMethod_.invoke(object, string, StatementUtilities.getDBTimestamp(resultSet, n2));
                return;
            } else {
                this.genericSetMethod_.invoke(object, string, resultSet.getObject(n2));
            }
        }
    }

    protected void updateX(ResultSet resultSet, T t2) throws SQLException {
        for (int i10 = this.minCol_; i10 <= this.maxCol_; ++i10) {
            try {
                this.updateObject(this.columnLabels_[i10], resultSet, t2, i10 + 1);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_UPD_BEAN_FIELD", this.columnLabels_[i10]), illegalAccessException, 10267);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_UPD_BEAN_FIELD", this.columnLabels_[i10]), invocationTargetException, 10009);
            }
        }
    }

    protected Object[] getIdValuesOnly(ResultSet resultSet) throws SQLException {
        int n2 = this.idColumns_.length;
        Object[] objectArray = new Object[n2];
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i10 = 0; i10 < n2; ++i10) {
            objectArray[i10] = "TIMESTAMP WITH TIME ZONE".equals(resultSetMetaData.getColumnTypeName(this.idColumns_[i10])) ? StatementUtilities.getDBTimestamp(resultSet, this.idColumns_[i10]) : resultSet.getObject(this.idColumns_[i10]);
            if (!resultSet.wasNull()) continue;
            objectArray[i10] = null;
        }
        return objectArray;
    }

    private static Class<?> getClassForNameUseThreadContextClassLoader(String string) throws Exception {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(BeanRowHandler.getClassForNameUseThreadContextClassLoaderPriv(string));
        }
        return BeanRowHandler.getClassForNameUseThreadContextClassLoaderNonPriv(string);
    }

    private static Class<?> getClassForNameUseThreadContextClassLoaderNonPriv(String string) throws Exception {
        return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
    }

    private static final PrivilegedExceptionAction<Class<?>> getClassForNameUseThreadContextClassLoaderPriv(final String string) {
        return new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws Exception {
                return BeanRowHandler.getClassForNameUseThreadContextClassLoaderNonPriv(string);
            }
        };
    }

    private static ClassLoader getContextClassloader() {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        return Thread.currentThread().getContextClassLoader();
    }

    private static Method getDeclaredMethodForClass(Class<?> clazz, String string, Class<?> ... classArray) throws PrivilegedActionException, SecurityException, NoSuchMethodException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(BeanRowHandler.getDeclaredMethodForClassPrivilegedAction(clazz, string, classArray));
        }
        return BeanRowHandler.getDeclaredMethodForClassNoSM(clazz, string, classArray);
    }

    private static final PrivilegedExceptionAction<Method> getDeclaredMethodForClassPrivilegedAction(final Class<?> clazz, final String string, final Class<?> ... classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return BeanRowHandler.getDeclaredMethodForClassNoSM(clazz, string, classArray);
            }
        };
    }

    static Method getDeclaredMethodForClassNoSM(Class<?> clazz, String string, Class<?> ... classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getDeclaredMethod(string, classArray);
    }
}

