/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util.artifact;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.onseven.dbvis.util.artifact.Artifact;
import com.onseven.dbvis.util.artifact.ArtifactBase;
import com.onseven.dbvis.util.artifact.ArtifactFile;
import com.onseven.dbvis.util.artifact.DriverStatus;
import com.onseven.dbvis.util.artifact.FolderArtifact;
import com.onseven.dbvis.util.artifact.LocalArtifact;
import com.onseven.dbvis.util.artifact.MavenArtifact;
import com.onseven.dbvis.util.artifact.RemoteArtifact;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ArtifactBundle {
    @JacksonXmlElementWrapper(localName="Artifacts")
    @JacksonXmlProperty(localName="Artifact")
    private List<Artifact> artifacts = new ArrayList<Artifact>();
    @JsonIgnore
    private String id;
    @JsonIgnore
    private DriverStatus driverStatus = new DriverStatus();
    @JsonIgnore
    private File bundleRoot;

    public ArtifactBundle(ArtifactBundle artifactBundle) {
        this.bundleRoot = artifactBundle.bundleRoot;
        this.id = artifactBundle.id;
        if (artifactBundle.driverStatus != null) {
            this.driverStatus = new DriverStatus(artifactBundle.driverStatus);
        }
        for (Artifact artifact : artifactBundle.artifacts) {
            this.addArtifact(artifact.createCopy());
        }
    }

    public boolean hasSameMavenArtifactIds(ArtifactBundle artifactBundle) {
        List<MavenArtifact> list = this.getMavenArtifacts();
        if (list.size() != this.artifacts.size()) {
            return false;
        }
        List<MavenArtifact> list2 = artifactBundle.getMavenArtifacts();
        if (list.size() != list2.size()) {
            return false;
        }
        int n2 = 0;
        for (MavenArtifact mavenArtifact : list) {
            MavenArtifact mavenArtifact2 = list2.get(n2);
            if (mavenArtifact.getGroupId().equals(mavenArtifact2.getGroupId()) && mavenArtifact.getArtifactId().equals(mavenArtifact2.getArtifactId())) continue;
            return false;
        }
        return true;
    }

    private List<MavenArtifact> getMavenArtifacts() {
        ArrayList<MavenArtifact> arrayList = new ArrayList<MavenArtifact>();
        for (Artifact artifact : this.artifacts) {
            if (!(artifact instanceof MavenArtifact)) continue;
            MavenArtifact mavenArtifact = (MavenArtifact)artifact;
            arrayList.add(mavenArtifact);
        }
        return arrayList;
    }

    public ArtifactBundle() {
    }

    public void addLocalArtifact(String string) {
        ArtifactFile artifactFile = new ArtifactFile(this.getBundleRoot().getAbsolutePath(), string, null);
        this.addArtifact(new LocalArtifact(artifactFile));
    }

    public void addFolderArtifact(String string) {
        this.addArtifact(new FolderArtifact(string));
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    @JsonIgnore
    public List<Artifact> getActiveArtifacts() {
        if (this.artifacts == null) {
            return null;
        }
        List<Artifact> list = this.artifacts.stream().filter(artifact -> artifact.isActive()).collect(Collectors.toList());
        return list;
    }

    @JsonSetter(nulls=Nulls.AS_EMPTY)
    public void setArtifacts(List<Artifact> list) {
        this.artifacts = list;
    }

    public void addArtifact(Artifact artifact) {
        LocalArtifact localArtifact;
        if (artifact instanceof LocalArtifact && (localArtifact = (LocalArtifact)artifact).getLocalFile() != null && this.getBundleRoot() != null) {
            localArtifact.getLocalFile().setRootPath(this.getBundleRoot().getAbsolutePath());
        }
        this.artifacts.add(artifact);
    }

    public File getBundleRoot() {
        return this.bundleRoot;
    }

    public void setBundleRoot(File file) {
        this.bundleRoot = file;
    }

    public void initBundleRoot(File file) {
        this.bundleRoot = file;
        for (Artifact artifact : this.artifacts) {
            LocalArtifact localArtifact;
            ArtifactFile artifactFile;
            if (!(artifact instanceof LocalArtifact) || (artifactFile = (localArtifact = (LocalArtifact)artifact).getLocalFile()) == null || !artifactFile.isInBundleRoot()) continue;
            artifactFile.setRootPath(file.getAbsolutePath());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public DriverStatus getDriverStatus() {
        return this.driverStatus;
    }

    public void setDriverStatus(DriverStatus driverStatus) {
        this.driverStatus = driverStatus;
    }

    public boolean areSame(ArtifactBundle artifactBundle) {
        if (this == artifactBundle) {
            return true;
        }
        if (this.artifacts == artifactBundle.artifacts) {
            return true;
        }
        if (this.artifacts != null) {
            return this.artifacts.equals(artifactBundle.artifacts);
        }
        return false;
    }

    public boolean hasMavenArtifacts() {
        if (this.artifacts != null) {
            return this.artifacts.stream().anyMatch(MavenArtifact.class::isInstance);
        }
        return false;
    }

    public boolean hasDownloadableArtifacts() {
        return this.hasMavenArtifacts() || this.hasRemoteArtifacts();
    }

    public boolean hasRemoteArtifacts() {
        if (this.artifacts != null) {
            return this.artifacts.stream().anyMatch(RemoteArtifact.class::isInstance);
        }
        return false;
    }

    public void dump(PrintStream printStream) {
        for (Artifact artifact : this.artifacts) {
            artifact.dump(printStream);
            printStream.println();
        }
    }

    public List<FolderArtifact> getFolderArtifacts() {
        ArrayList<FolderArtifact> arrayList = new ArrayList<FolderArtifact>();
        for (Artifact artifact : this.artifacts) {
            if (!(artifact instanceof FolderArtifact)) continue;
            arrayList.add((FolderArtifact)artifact);
        }
        return arrayList;
    }

    public boolean hasLocalArtifactStoredInRoot() {
        for (Artifact artifact : this.artifacts) {
            String string;
            File file;
            ArtifactBase artifactBase;
            if (!(artifact instanceof LocalArtifact ? ((LocalArtifact)(artifactBase = (LocalArtifact)artifact)).getLocalFile().isInBundleRoot() : artifact instanceof FolderArtifact && !(file = new File(string = ((FolderArtifact)(artifactBase = (FolderArtifact)artifact)).getDirPath())).isAbsolute())) continue;
            return true;
        }
        return false;
    }
}

