/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.obf.Fd;
import com.yworks.yguard.obf.LineNumberTableMapper;
import com.yworks.yguard.obf.Md;
import com.yworks.yguard.obf.NameListDown;
import com.yworks.yguard.obf.NameListUp;
import com.yworks.yguard.obf.NameMaker;
import com.yworks.yguard.obf.NameMakerFactory;
import com.yworks.yguard.obf.ObfuscationConfig;
import com.yworks.yguard.obf.PkCl;
import com.yworks.yguard.obf.TreeItem;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.FieldInfo;
import com.yworks.yguard.obf.classfile.Logger;
import com.yworks.yguard.obf.classfile.MethodInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Cl
extends PkCl
implements NameListUp,
NameListDown {
    private boolean sourceFileMappingSet;
    private static boolean pedantic = false;
    private static ClassResolver resolver = new DefaultClassResolver();
    private Hashtable mds = new Hashtable();
    private Hashtable fds = new Hashtable();
    private boolean isResolved = false;
    private boolean isScanned = false;
    private String superClass;
    private String[] superInterfaces;
    private boolean isInnerClass;
    private ObfuscationConfig obfuscationConfig;
    private String sourceFileMapping;
    private int classFileAccess;
    private LineNumberTableMapper lineNumberTableMapper;
    private Vector nameListUps = new Vector();
    private Vector nameListDowns = new Vector();
    public static int nameSpace = 0;
    private static NameMaker methodNameMaker;
    private static NameMaker fieldNameMaker;
    private Map innerClassModifiers = new HashMap();
    private Set attributesToKeep = new HashSet();
    private static Hashtable extNameListUpCache;

    public Set getAttributesToKeep() {
        return this.attributesToKeep;
    }

    public static ClassResolver getClassResolver() {
        return resolver;
    }

    public static void setPedantic(boolean val) {
        pedantic = val;
    }

    public static void setClassResolver(ClassResolver res) {
        resolver = res != null ? res : new DefaultClassResolver();
    }

    public Cl(TreeItem parent, boolean isInnerClass, String name, String superClass, String[] superInterfaces, int modifiers, ObfuscationConfig obfuscationConfig) {
        super(parent, name);
        this.superClass = superClass;
        this.superInterfaces = superInterfaces;
        this.isInnerClass = isInnerClass;
        this.obfuscationConfig = obfuscationConfig;
        this.access = modifiers;
        if (parent == null || name.equals("")) {
            System.err.println("Internal error: class must have parent and name");
        }
        if (parent instanceof Cl) {
            this.sep = "$";
        }
        if (isInnerClass && Character.isDigit(name.charAt(0))) {
            this.setOutName(this.getInName());
        }
    }

    void setClassFileAccess(int classFileAccess) {
        this.classFileAccess = classFileAccess;
    }

    public LineNumberTableMapper getLineNumberTableMapper() {
        return this.lineNumberTableMapper;
    }

    public void setLineNumberTableMapper(LineNumberTableMapper lineNumberTableMapper) {
        this.lineNumberTableMapper = lineNumberTableMapper;
    }

    public String getSourceFileMapping() {
        return this.sourceFileMapping;
    }

    public void setSourceFileMapping(String sourceFileMapping) {
        this.sourceFileMappingSet = true;
        this.sourceFileMapping = sourceFileMapping;
    }

    public boolean isSourceFileMappingSet() {
        return this.sourceFileMappingSet;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.superInterfaces;
    }

    public void setInnerClassModifiers(Map map) {
        this.innerClassModifiers.putAll(map);
    }

    public int getInnerClassModifier(String fqn) {
        Integer i = (Integer)this.innerClassModifiers.get(fqn);
        if (i == null) {
            return 2;
        }
        return i;
    }

    public boolean isInnerClass() {
        return this.isInnerClass;
    }

    public Md getMethod(String name, String descriptor) {
        return (Md)this.mds.get(name + descriptor);
    }

    public Fd getField(String name) {
        return (Fd)this.fds.get(name);
    }

    public Enumeration getMethodEnum() {
        return this.mds.elements();
    }

    public Enumeration getFieldEnum() {
        return this.fds.elements();
    }

    public boolean isWildcardMatch(String pattern) {
        return Cl.isMatch(pattern, this.getFullInName());
    }

    public boolean isNRWildcardMatch(String pattern) {
        return Cl.isNRMatch(pattern, this.getFullInName());
    }

    public boolean hasAsSuper(String queryName) throws ClassNotFoundException {
        if (this.superClass == null) {
            return false;
        }
        try {
            if (this.superClass.equals(queryName)) {
                return true;
            }
            Cl superClassItem = this.classTree.getCl(this.superClass);
            if (superClassItem != null) {
                return superClassItem.hasAsSuper(queryName);
            }
            for (Class extSuper = resolver.resolve(ClassFile.translate(this.superClass)); extSuper != null; extSuper = extSuper.getSuperclass()) {
                if (!extSuper.getName().equals(ClassFile.translate(queryName))) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            if (pedantic) {
                throw cnfe;
            }
            return false;
        }
    }

    @Override
    public Cl addClass(Object[] classInfo) {
        return this.addClass(true, classInfo);
    }

    public Cl addClass(Cl cl) {
        this.cls.put(cl.getInName(), cl);
        return cl;
    }

    @Override
    public Cl addPlaceholderClass(String name) {
        return this.addPlaceholderClass(true, name);
    }

    public Md addMethod(MethodInfo methodInfo) {
        boolean isSynthetic = methodInfo.isSynthetic();
        String name = methodInfo.getName();
        String descriptor = methodInfo.getDescriptor();
        int access = methodInfo.getAccessFlags();
        if (name.charAt(0) == '<') {
            return null;
        }
        Md md = this.getMethod(name, descriptor);
        if (md == null) {
            md = new Md(this, isSynthetic, name, descriptor, access, methodInfo.getObfuscationConfig());
            this.mds.put(name + descriptor, md);
        }
        int PublicStatic = 9;
        if ((this.classFileAccess & 0x4000) == 16384 && (access & 9) == 9) {
            String desc = "(Ljava/lang/String;)L" + this.getFullInName() + ';';
            if ("valueOf".equals(name) && desc.equals(descriptor)) {
                md.setOutName(name);
            } else if ("values".equals(name) && descriptor.equals("()[L" + this.getFullInName() + ';')) {
                md.setOutName(name);
            }
        }
        return md;
    }

    public Fd addField(FieldInfo fieldInfo) {
        boolean isSynthetic = fieldInfo.isSynthetic();
        String name = fieldInfo.getName();
        String descriptor = fieldInfo.getDescriptor();
        int access = fieldInfo.getAccessFlags();
        Fd fd = this.getField(name);
        if (fd == null) {
            fd = new Fd(this, isSynthetic, name, descriptor, access, fieldInfo.getObfuscationConfig());
            this.fds.put(name, fd);
        }
        return fd;
    }

    public void resetResolve() {
        this.isScanned = false;
        this.isResolved = false;
        this.nameListDowns.removeAllElements();
    }

    public void setupNameListDowns() {
        if (this.superClass == null) {
            return;
        }
        Cl superClassItem = this.classTree.getCl(this.superClass);
        if (superClassItem != null) {
            superClassItem.nameListDowns.addElement(this);
        }
        for (int i = 0; i < this.superInterfaces.length; ++i) {
            Cl interfaceItem = this.classTree.getCl(this.superInterfaces[i]);
            if (interfaceItem == null) continue;
            interfaceItem.nameListDowns.addElement(this);
        }
    }

    public void resolveOptimally() throws ClassNotFoundException {
        if (!this.isResolved) {
            Vector methods = new Vector();
            Vector fields = new Vector();
            this.scanNameSpaceExcept(null, methods, fields);
            String[] methodNames = new String[methods.size()];
            for (int i = 0; i < methodNames.length; ++i) {
                methodNames[i] = (String)methods.elementAt(i);
            }
            String[] fieldNames = new String[fields.size()];
            for (int i = 0; i < fieldNames.length; ++i) {
                fieldNames[i] = (String)fields.elementAt(i);
            }
            NameMakerFactory nmf = NameMakerFactory.getInstance();
            methodNameMaker = nmf.getMethodNameMaker(methodNames, this.getFullInName());
            fieldNameMaker = nmf.getFieldNameMaker(fieldNames, this.getFullInName());
            this.resolveNameSpaceExcept(null);
            ++nameSpace;
        }
    }

    private void scanNameSpaceExcept(Cl ignoreCl, Vector methods, Vector fields) throws ClassNotFoundException {
        if (this.superClass == null) {
            return;
        }
        if (!this.isScanned) {
            Cl superCl = this.classTree.getCl(this.superClass);
            if (superCl != null) {
                if (superCl != ignoreCl) {
                    superCl.scanNameSpaceExcept(this, methods, fields);
                }
            } else {
                this.scanExtSupers(this.superClass, methods, fields);
            }
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                Cl interfaceItem = this.classTree.getCl(this.superInterfaces[i]);
                if (interfaceItem != null) {
                    if (interfaceItem == ignoreCl) continue;
                    interfaceItem.scanNameSpaceExcept(this, methods, fields);
                    continue;
                }
                this.scanExtSupers(this.superInterfaces[i], methods, fields);
            }
            if (!this.isScanned) {
                this.scanThis(methods, fields);
                this.isScanned = true;
            }
            Enumeration clEnum = this.nameListDowns.elements();
            while (clEnum.hasMoreElements()) {
                Cl cl = (Cl)clEnum.nextElement();
                if (cl == ignoreCl) continue;
                cl.scanNameSpaceExcept(this, methods, fields);
            }
        }
    }

    private void scanExtSupers(String name, Vector methods, Vector fields) throws ClassNotFoundException {
        try {
            Class extClass = resolver.resolve(ClassFile.translate(name));
            this.scanExtSupers(extClass, methods, fields);
        }
        catch (ClassNotFoundException cnfe) {
            if (pedantic) {
                throw cnfe;
            }
            Logger.getInstance().warningToLogfile("Unresolved external dependency: " + Conversion.toJavaClass(name) + " not found!");
            Logger.getInstance().setUnresolved();
        }
    }

    private void scanExtSupers(Class extClass, Vector methods, Vector fields) throws ClassNotFoundException {
        Field[] allPubFields;
        Method[] allPubMethods = extClass.getMethods();
        if (allPubMethods != null) {
            for (int i = 0; i < allPubMethods.length; ++i) {
                String methodName = allPubMethods[i].getName();
                if (methods.indexOf(methodName) != -1) continue;
                methods.addElement(methodName);
            }
        }
        if ((allPubFields = extClass.getFields()) != null) {
            for (int i = 0; i < allPubFields.length; ++i) {
                String fieldName = allPubFields[i].getName();
                if (fields.indexOf(fieldName) != -1) continue;
                fields.addElement(fieldName);
            }
        }
        while (extClass != null) {
            Field[] allClassFields;
            Method[] allClassMethods = extClass.getDeclaredMethods();
            if (allClassMethods != null) {
                for (int i = 0; i < allClassMethods.length; ++i) {
                    String methodName;
                    if (Modifier.isPublic(allClassMethods[i].getModifiers()) || methods.indexOf(methodName = allClassMethods[i].getName()) != -1) continue;
                    methods.addElement(methodName);
                }
            }
            if ((allClassFields = extClass.getDeclaredFields()) != null) {
                for (int i = 0; i < allClassFields.length; ++i) {
                    String fieldName;
                    if (Modifier.isPublic(allClassFields[i].getModifiers()) || fields.indexOf(fieldName = allClassFields[i].getName()) != -1) continue;
                    fields.addElement(fieldName);
                }
            }
            extClass = extClass.getSuperclass();
        }
    }

    private void scanThis(Vector methods, Vector fields) {
        String name;
        Enumeration mdEnum = this.mds.elements();
        while (mdEnum.hasMoreElements()) {
            Md md = (Md)mdEnum.nextElement();
            if (!md.isFixed() || methods.indexOf(name = md.getOutName()) != -1) continue;
            methods.addElement(name);
        }
        Enumeration fdEnum = this.fds.elements();
        while (fdEnum.hasMoreElements()) {
            Fd fd = (Fd)fdEnum.nextElement();
            if (!fd.isFixed() || fields.indexOf(name = fd.getOutName()) != -1) continue;
            fields.addElement(name);
        }
    }

    private void resolveNameSpaceExcept(Cl ignoreCl) throws ClassNotFoundException {
        if (this.superClass == null) {
            return;
        }
        if (!this.isResolved) {
            Cl superCl = this.classTree.getCl(this.superClass);
            if (superCl != null && superCl != ignoreCl) {
                superCl.resolveNameSpaceExcept(this);
            }
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                Cl interfaceItem = this.classTree.getCl(this.superInterfaces[i]);
                if (interfaceItem == null || interfaceItem == ignoreCl) continue;
                interfaceItem.resolveNameSpaceExcept(this);
            }
            if (!this.isResolved) {
                this.resolveThis();
                this.isResolved = true;
            }
            Enumeration clEnum = this.nameListDowns.elements();
            while (clEnum.hasMoreElements()) {
                Cl cl = (Cl)clEnum.nextElement();
                if (cl == ignoreCl) continue;
                cl.resolveNameSpaceExcept(this);
            }
        }
    }

    private void resolveThis() throws ClassNotFoundException {
        String theOutName;
        Enumeration nlEnum;
        if (this.superClass == null) {
            return;
        }
        Cl superClassItem = this.classTree.getCl(this.superClass);
        this.nameListUps.addElement(superClassItem != null ? superClassItem : this.getExtNameListUp(this.superClass));
        for (int i = 0; i < this.superInterfaces.length; ++i) {
            Cl interfaceItem = this.classTree.getCl(this.superInterfaces[i]);
            this.nameListUps.addElement(interfaceItem != null ? interfaceItem : this.getExtNameListUp(this.superInterfaces[i]));
        }
        Enumeration mdEnum = this.mds.elements();
        block1: while (mdEnum.hasMoreElements()) {
            Md md = (Md)mdEnum.nextElement();
            if (!md.isFixed()) {
                if (!Modifier.isPrivate(md.getModifiers())) {
                    nlEnum = this.nameListDowns.elements();
                    while (nlEnum.hasMoreElements()) {
                        theOutName = ((NameListDown)nlEnum.nextElement()).getMethodObfNameDown(this, md.getInName(), md.getDescriptor());
                        if (theOutName == null) continue;
                        md.setOutName(theOutName);
                        continue block1;
                    }
                    nlEnum = this.nameListUps.elements();
                    while (nlEnum.hasMoreElements()) {
                        theOutName = ((NameListUp)nlEnum.nextElement()).getMethodOutNameUp(md.getInName(), md.getDescriptor());
                        if (theOutName == null) continue;
                        md.setOutName(theOutName);
                        continue block1;
                    }
                }
                md.setOutName(methodNameMaker.nextName(md.getDescriptor()));
                continue;
            }
            if (!Modifier.isNative(md.access) || md.getParent().getFullOutName().equals(md.getParent().getFullInName())) continue;
            Logger.getInstance().warning("Method " + md.getOutName() + " is native but " + md.getParent().getFullInName() + " is not kept/exposed.");
        }
        Enumeration fdEnum = this.fds.elements();
        block4: while (fdEnum.hasMoreElements()) {
            Fd fd = (Fd)fdEnum.nextElement();
            if (fd.isFixed()) continue;
            if (!Modifier.isPrivate(fd.getModifiers())) {
                nlEnum = this.nameListDowns.elements();
                while (nlEnum.hasMoreElements()) {
                    theOutName = ((NameListDown)nlEnum.nextElement()).getFieldObfNameDown(this, fd.getInName());
                    if (theOutName == null) continue;
                    fd.setOutName(theOutName);
                    continue block4;
                }
                nlEnum = this.nameListUps.elements();
                while (nlEnum.hasMoreElements()) {
                    String superOutName = ((NameListUp)nlEnum.nextElement()).getFieldOutNameUp(fd.getInName());
                    if (superOutName == null) continue;
                    fd.setOutName(superOutName);
                    continue block4;
                }
            }
            fd.setOutName(fieldNameMaker.nextName(null));
        }
    }

    @Override
    public String getMethodOutNameUp(String name, String descriptor) throws ClassNotFoundException {
        Enumeration enumeration = this.nameListUps.elements();
        while (enumeration.hasMoreElements()) {
            String superOutName = ((NameListUp)enumeration.nextElement()).getMethodOutNameUp(name, descriptor);
            if (superOutName == null) continue;
            return superOutName;
        }
        Md md = this.getMethod(name, descriptor);
        if (md != null && !Modifier.isPrivate(md.access)) {
            return md.getOutName();
        }
        return null;
    }

    @Override
    public String getMethodObfNameUp(String name, String descriptor) throws ClassNotFoundException {
        Enumeration enumeration = this.nameListUps.elements();
        while (enumeration.hasMoreElements()) {
            String superObfName = ((NameListUp)enumeration.nextElement()).getMethodObfNameUp(name, descriptor);
            if (superObfName == null) continue;
            return superObfName;
        }
        Md md = this.getMethod(name, descriptor);
        if (md != null && !Modifier.isPrivate(md.access)) {
            return md.getObfName();
        }
        return null;
    }

    @Override
    public String getFieldOutNameUp(String name) throws ClassNotFoundException {
        Enumeration enumeration = this.nameListUps.elements();
        while (enumeration.hasMoreElements()) {
            String superOutName = ((NameListUp)enumeration.nextElement()).getFieldOutNameUp(name);
            if (superOutName == null) continue;
            return superOutName;
        }
        Fd fd = this.getField(name);
        if (fd != null && !Modifier.isPrivate(fd.access)) {
            return fd.getOutName();
        }
        return null;
    }

    @Override
    public String getFieldObfNameUp(String name) throws ClassNotFoundException {
        Enumeration enumeration = this.nameListUps.elements();
        while (enumeration.hasMoreElements()) {
            String superObfName = ((NameListUp)enumeration.nextElement()).getFieldObfNameUp(name);
            if (superObfName == null) continue;
            return superObfName;
        }
        Fd fd = this.getField(name);
        if (fd != null && !Modifier.isPrivate(fd.access)) {
            return fd.getObfName();
        }
        return null;
    }

    @Override
    public String getMethodObfNameDown(Cl caller, String name, String descriptor) throws ClassNotFoundException {
        Md md = this.getMethod(name, descriptor);
        if (md != null && md.isFixed()) {
            return md.getOutName();
        }
        String theObfName = null;
        if (this.superClass != null) {
            Cl nl;
            Cl superClassItem = this.classTree.getCl(this.superClass);
            if (superClassItem != caller && (theObfName = (nl = superClassItem != null ? superClassItem : this.getExtNameListUp(this.superClass)).getMethodObfNameUp(name, descriptor)) != null) {
                return theObfName;
            }
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                Cl nl2;
                Cl interfaceItem = this.classTree.getCl(this.superInterfaces[i]);
                if (interfaceItem == caller || (theObfName = (nl2 = interfaceItem != null ? interfaceItem : this.getExtNameListUp(this.superInterfaces[i])).getMethodObfNameUp(name, descriptor)) == null) continue;
                return theObfName;
            }
        }
        Enumeration enumeration = this.nameListDowns.elements();
        while (enumeration.hasMoreElements()) {
            theObfName = ((NameListDown)enumeration.nextElement()).getMethodObfNameDown(this, name, descriptor);
            if (theObfName == null) continue;
            return theObfName;
        }
        return null;
    }

    @Override
    public String getFieldObfNameDown(Cl caller, String name) throws ClassNotFoundException {
        Fd fd = this.getField(name);
        if (fd != null && fd.isFixed()) {
            return fd.getOutName();
        }
        String theObfName = null;
        if (this.superClass != null) {
            Cl nl;
            Cl superClassItem = this.classTree.getCl(this.superClass);
            if (superClassItem != caller && (theObfName = (nl = superClassItem != null ? superClassItem : this.getExtNameListUp(this.superClass)).getFieldObfNameUp(name)) != null) {
                return theObfName;
            }
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                Cl nl2;
                Cl interfaceItem = this.classTree.getCl(this.superInterfaces[i]);
                if (interfaceItem == caller || (theObfName = (nl2 = interfaceItem != null ? interfaceItem : this.getExtNameListUp(this.superInterfaces[i])).getFieldObfNameUp(name)) == null) continue;
                return theObfName;
            }
        }
        Enumeration enumeration = this.nameListDowns.elements();
        while (enumeration.hasMoreElements()) {
            theObfName = ((NameListDown)enumeration.nextElement()).getFieldObfNameDown(this, name);
            if (theObfName == null) continue;
            return theObfName;
        }
        return null;
    }

    private NameListUp getExtNameListUp(String name) throws ClassNotFoundException {
        NameListUp nl = (NameListUp)extNameListUpCache.get(name);
        if (nl == null) {
            nl = new ExtNameListUp(name);
            extNameListUpCache.put(name, nl);
        }
        return nl;
    }

    public ObfuscationConfig getObfuscationConfig() {
        return this.obfuscationConfig;
    }

    static {
        extNameListUpCache = new Hashtable();
    }

    class ExtNameListUp
    implements NameListUp {
        private Class extClass;
        private Method[] methods = null;

        public ExtNameListUp(String name) throws ClassNotFoundException {
            try {
                this.extClass = resolver.resolve(ClassFile.translate(name));
            }
            catch (ClassNotFoundException cnfe) {
                if (pedantic) {
                    throw cnfe;
                }
                Logger.getInstance().warningToLogfile("Unresolved external dependency: " + Conversion.toJavaClass(name) + " not found!");
                Logger.getInstance().setUnresolved();
            }
        }

        public ExtNameListUp(Class extClass) {
            this.extClass = extClass;
        }

        @Override
        public String getMethodObfNameUp(String name, String descriptor) {
            return this.getMethodOutNameUp(name, descriptor);
        }

        @Override
        public String getMethodOutNameUp(String name, String descriptor) {
            if (this.extClass == null) {
                return name;
            }
            if (this.methods == null) {
                int i;
                this.methods = this.getAllDeclaredMethods(this.extClass);
                Vector<Method> pruned = new Vector<Method>();
                for (i = 0; i < this.methods.length; ++i) {
                    int modifiers = this.methods[i].getModifiers();
                    if (Modifier.isPrivate(modifiers)) continue;
                    pruned.addElement(this.methods[i]);
                }
                this.methods = new Method[pruned.size()];
                for (i = 0; i < this.methods.length; ++i) {
                    this.methods[i] = (Method)pruned.elementAt(i);
                }
            }
            block2: for (int i = 0; i < this.methods.length; ++i) {
                if (!name.equals(this.methods[i].getName())) continue;
                String[] paramAndReturnNames = ClassFile.parseDescriptor(descriptor);
                Class<?>[] paramTypes = this.methods[i].getParameterTypes();
                Class<?> returnType = this.methods[i].getReturnType();
                if (paramAndReturnNames.length != paramTypes.length + 1) continue;
                for (int j = 0; j < paramAndReturnNames.length - 1; ++j) {
                    if (!paramAndReturnNames[j].equals(paramTypes[j].getName())) continue block2;
                }
                String returnName = returnType.getName();
                if (!paramAndReturnNames[paramAndReturnNames.length - 1].equals(returnName)) continue;
                return name;
            }
            return null;
        }

        @Override
        public String getFieldObfNameUp(String name) {
            return this.getFieldOutNameUp(name);
        }

        @Override
        public String getFieldOutNameUp(String name) {
            int modifiers;
            if (this.extClass == null) {
                return name;
            }
            Field field = this.getAllDeclaredField(this.extClass, name);
            if (field != null && !Modifier.isPrivate(modifiers = field.getModifiers())) {
                return name;
            }
            return null;
        }

        private Method[] getAllDeclaredMethods(Class theClass) {
            Vector<Method[]> ma = new Vector<Method[]>();
            int length = 0;
            Method[] allPubMethods = theClass.getMethods();
            ma.addElement(allPubMethods);
            length += allPubMethods.length;
            while (theClass != null) {
                Method[] methods = theClass.getDeclaredMethods();
                ma.addElement(methods);
                length += methods.length;
                theClass = theClass.getSuperclass();
            }
            Method[] allMethods = new Method[length];
            int pos = 0;
            Enumeration enumeration = ma.elements();
            while (enumeration.hasMoreElements()) {
                Method[] methods = (Method[])enumeration.nextElement();
                System.arraycopy(methods, 0, allMethods, pos, methods.length);
                pos += methods.length;
            }
            return allMethods;
        }

        private Field getAllDeclaredField(Class theClass, String name) {
            Class origClass = theClass;
            while (theClass != null) {
                Field field = null;
                try {
                    field = theClass.getDeclaredField(name);
                }
                catch (Exception e) {
                    field = null;
                }
                if (field != null) {
                    return field;
                }
                theClass = theClass.getSuperclass();
            }
            try {
                return origClass.getField(name);
            }
            catch (SecurityException nsfe) {
                return null;
            }
            catch (NoSuchFieldException nsfe) {
                return null;
            }
        }
    }

    private static final class DefaultClassResolver
    implements ClassResolver {
        private DefaultClassResolver() {
        }

        @Override
        public Class resolve(String className) throws ClassNotFoundException {
            return Class.forName(className, false, this.getClass().getClassLoader());
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static interface ClassResolver
    extends AutoCloseable {
        public Class resolve(String var1) throws ClassNotFoundException;
    }
}

