/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.ExtractDelegatePermission;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.NullProxy;
import oracle.jdbc.proxy.WeakIdentityHashMap;
import oracle.jdbc.proxy._Proxy_;

public class ProxyFactory {
    public static final String DEFAULT_PROXY_PACKAGE = "oracle.jdbc.proxy";
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private static final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private final Map<Class<?>, Constructor<?>> delegateClassToProxyConstructor = new ConcurrentHashMap();
    private final Map<Object, WeakReference<?>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<Class<?>, Class<?>> delegateToMostSuitableIface = new ConcurrentHashMap();
    private static final Object STALE_DELEGATE = new Object();
    private static final Class<EMPTY_CLASS> EMPTY_VALUE = EMPTY_CLASS.class;
    private ClassLoader classLoader = null;
    private final String proxyPackage;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();

    private ProxyFactory(String string) {
        this.proxyPackage = string;
    }

    public static ProxyFactory createProxyFactory(String string, Class<?> ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(string);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createProxyFactory(Class<?> ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(String string, Class<?> ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(string);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class<?> ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public final boolean isProxied(Class<?> clazz) {
        return this.annotationsRegistry.containsKey(clazz);
    }

    public final <T> T proxyFor(T t2) {
        return this.proxyFor(t2, this);
    }

    public final <T> T proxyFor(T t2, Object object) {
        return this.proxyForCache(t2, object, null, null);
    }

    public final <T> T proxyForType(Class<?> clazz) {
        return this.proxyForType(clazz, this);
    }

    public final <T> T proxyForType(Class<?> clazz, Object object) {
        if (Objects.isNull(clazz)) {
            return null;
        }
        Class<?> clazz2 = this.findMostSuitableIface(clazz);
        if (Objects.isNull(clazz2)) {
            return null;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (Objects.isNull(value)) {
            return null;
        }
        WeakIdentityHashMap<Object, WeakReference<?>> weakIdentityHashMap = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        try {
            Constructor<?> constructor = this.getProxyConstructor(clazz2, clazz);
            if (null == constructor) {
                return this.createProxy(clazz2, null, object, weakIdentityHashMap);
            }
            return (T)constructor.newInstance(null, object, this, weakIdentityHashMap);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public final <T> T proxyForCreate(T t2, Object object, Map<Object, WeakReference<?>> map, Method method) {
        Constructor<?> constructor;
        if (null == t2) {
            return null;
        }
        Class<?> clazz = t2.getClass();
        Class<?> clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        if (null == map) {
            Map<Object, Object> map2 = map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (constructor = this.getProxyConstructor(clazz2, clazz))) {
            return this.createProxy(clazz2, t2, object, map);
        }
        try {
            return (T)constructor.newInstance(t2, object, this, map);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public final <T> T proxyForCache(T t2, Object object, Map<Object, WeakReference<?>> map, Method method) {
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        Class<?> clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        Method method2 = value.getProxyAccessGetter();
        Method method3 = value.getProxyAccessSetter();
        if (null == map) {
            map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        try {
            Object object2;
            WeakReference<?> weakReference;
            if (null != method2) {
                weakReference = method2.invoke(t2, new Object[0]);
                if (null != weakReference) {
                    return (T)weakReference;
                }
            } else {
                weakReference = map.get(t2);
                if (null != weakReference && null != (object2 = weakReference.get())) {
                    if (STALE_DELEGATE == object2) {
                        throw new RuntimeException("stale delegate");
                    }
                    return object2;
                }
            }
            if (null == (weakReference = this.getProxyConstructor(clazz2, clazz))) {
                object2 = this.createProxy(clazz2, t2, object, map);
                if (null != method3) {
                    method3.invoke(t2, object2);
                } else {
                    map.put(t2, new WeakReference(object2));
                }
                return object2;
            }
            object2 = ((Constructor)((Object)weakReference)).newInstance(t2, object, this, map);
            if (null != method3) {
                method3.invoke(t2, object2);
            } else {
                map.put(t2, new WeakReference(object2));
            }
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public final <T> T proxyForCreateCache(T t2, Object object, Map<Object, WeakReference<?>> map, Method method) {
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        Class<?> clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        if (null == map) {
            map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        Method method2 = value.getProxyAccessSetter();
        Constructor<?> constructor = this.getProxyConstructor(clazz2, clazz);
        try {
            if (null == constructor) {
                T t3 = this.createProxy(clazz2, t2, object, map);
                if (null != method2) {
                    method2.invoke(t2, t3);
                } else {
                    map.put(t2, new WeakReference<T>(t3));
                }
                return t3;
            }
            Object obj = constructor.newInstance(t2, object, this, map);
            if (null != method2) {
                method2.invoke(t2, obj);
            } else {
                map.put(t2, new WeakReference(obj));
            }
            return (T)obj;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public <T> void updateDelegate(Object object, T t2, T t3) {
        this.delegateToProxy.put(t2, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(t3, new WeakReference<Object>(object));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static final <T> T extractDelegate(_Proxy_<T> _Proxy_2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        return _Proxy_2._getDelegate_();
    }

    private <T> T createProxy(Class<?> clazz, T t2, Object object, Map<Object, WeakReference<?>> map) {
        if (null == clazz) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz);
        Class<?> clazz2 = value.getSuperclass();
        Constructor<?> constructor = this.prepareProxy(this.proxyPackage, clazz, clazz2);
        try {
            return (T)constructor.newInstance(t2, object, this, map);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Constructor<?> prepareProxy(String string, Class<?> clazz, Class<?> clazz2) {
        Constructor<?> constructor;
        block14: {
            GeneratedProxiesRegistry.Value value = generatedRegistry.get(string, clazz, clazz2);
            if (null != value) {
                return value.getConstructor();
            }
            Class<?> clazz3 = null;
            clazz3 = Class.forName(new GeneratedProxiesRegistry.Key(string, clazz, clazz2).toString(), true, null == this.classLoader ? clazz2.getClassLoader() : this.classLoader);
            if (Objects.isNull(clazz3)) {
                throw new IllegalStateException("cannot resolve or generate proxy");
            }
            try {
                constructor = clazz3.getConstructor(clazz, Object.class, ProxyFactory.class, Map.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            generatedRegistry.put(string, clazz, clazz2, new GeneratedProxiesRegistry.Value(null, null, clazz3, constructor));
            break block14;
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz3 = ClassGenerator.generate(string, clazz, clazz2, this.annotationsRegistry, this.classLoader);
                }
                catch (Throwable throwable) {
                    Constructor<?> constructor2;
                    if (Objects.isNull(clazz3)) {
                        throw new IllegalStateException("cannot resolve or generate proxy");
                    }
                    try {
                        constructor2 = clazz3.getConstructor(clazz, Object.class, ProxyFactory.class, Map.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw new RuntimeException(noSuchMethodException);
                    }
                    generatedRegistry.put(string, clazz, clazz2, new GeneratedProxiesRegistry.Value(null, null, clazz3, constructor2));
                    throw throwable;
                }
                if (Objects.isNull(clazz3)) {
                    throw new IllegalStateException("cannot resolve or generate proxy");
                }
                try {
                    constructor = clazz3.getConstructor(clazz, Object.class, ProxyFactory.class, Map.class);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                generatedRegistry.put(string, clazz, clazz2, new GeneratedProxiesRegistry.Value(null, null, clazz3, constructor));
            }
        }
        return constructor;
    }

    private Constructor<?> getProxyConstructor(Class<?> clazz, Class<?> clazz2) {
        if (null == clazz2) {
            return null;
        }
        Object object = this.delegateClassToProxyConstructor.get(clazz2);
        if (null != object) {
            return object;
        }
        if (null == clazz) {
            return null;
        }
        object = generatedRegistry.get(this.proxyPackage, clazz, this.annotationsRegistry.get(clazz).getSuperclass());
        if (null == object) {
            return null;
        }
        Constructor<?> constructor = ((GeneratedProxiesRegistry.Value)object).getConstructor();
        if (null != constructor) {
            this.delegateClassToProxyConstructor.put(clazz2, constructor);
        }
        return constructor;
    }

    private Class<?> findMostSuitableIface(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        Class<?> clazz2 = this.delegateToMostSuitableIface.get(clazz);
        if (null != clazz2) {
            return EMPTY_VALUE != clazz2 ? clazz2 : null;
        }
        int n2 = -1;
        Class<EMPTY_CLASS> clazz3 = null;
        for (Class<?> clazz4 : this.annotationsRegistry.keySet()) {
            int n3 = this.intersectionCardinality(clazz, clazz4);
            if (n3 < 1 || n3 <= n2) continue;
            n2 = n3;
            clazz3 = clazz4;
        }
        this.delegateToMostSuitableIface.put(clazz, null != clazz3 ? clazz3 : EMPTY_VALUE);
        return clazz3;
    }

    private int intersectionCardinality(Class<?> clazz, Class<?> clazz2) {
        HashSet hashSet = new HashSet();
        this.collectIfaces(clazz2, hashSet);
        HashSet hashSet2 = new HashSet();
        this.collectIfaces(clazz, hashSet2);
        int n2 = hashSet.size();
        hashSet.removeAll(hashSet2);
        if (hashSet.size() > 0) {
            return -1;
        }
        return n2;
    }

    private void collectIfaces(Class<?> clazz, Set<Class<?>> set) {
        if (clazz.isInterface()) {
            set.add(clazz);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectIfaces(clazz2, set);
        }
        Class<?> clazz3 = clazz.getSuperclass();
        if (null != clazz3) {
            this.collectIfaces(clazz3, set);
        }
    }

    private static final class EMPTY_CLASS {
        private EMPTY_CLASS() {
        }
    }
}

