/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryParameterStream
extends AbstractParameterStream {
    public BinaryParameterStream(InputStream stream, long streamLength) {
        super(stream, streamLength);
    }

    @Deprecated
    public BinaryParameterStream(InputStream stream, long streamLength, ParameterMetadata paramMeta, int type) {
        super(stream, streamLength, paramMeta, type);
    }

    @Override
    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        if (null == this.m_parameterMetadata) {
            throw new InputOutputException(1, JDBCMessageKey.NULL_PARAM_METADATA.name());
        }
        if (!this.m_valuesPushed) {
            this.m_valuesPushed = true;
        }
        int numBytesToFetch = this.getNumToFetch();
        byte[] byteArray = new byte[numBytesToFetch];
        int numBytesRead = 0;
        try {
            numBytesRead = this.m_stream.read(byteArray, 0, numBytesToFetch);
        }
        catch (IOException e) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
        }
        this.m_numRead += (long)numBytesRead;
        if (-1L != this.m_streamLength) {
            if (-1 == numBytesRead) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = numBytesRead;
            if (numBytesRead < byteArray.length && -1 != numBytesRead) {
                byte[] temp = new byte[numBytesRead];
                System.arraycopy(byteArray, 0, temp, 0, numBytesRead);
                byteArray = temp;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == numBytesRead) {
                byteArray = new byte[]{};
            }
        }
        DataWrapper data = new DataWrapper();
        if (-3 == this.m_parameterMetadata.getTypeMetadata().getType()) {
            data.setVarBinary(byteArray);
        } else {
            data.setLongVarBinary(byteArray);
        }
        return new ParameterInputValue(this.m_parameterMetadata, data);
    }
}

