/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.SQLException;
import java.sql.Savepoint;

public class SSavepoint
implements Savepoint {
    private int m_id = 0;
    private String m_name = null;
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    protected SSavepoint(int id, ILogger logger, IWarningListener warningListener) {
        this.m_logger = logger;
        LogUtilities.logFunctionEntrance(this.m_logger, id, logger);
        this.m_warningListener = warningListener;
        this.m_id = id;
    }

    protected SSavepoint(String name, ILogger logger, IWarningListener warningListener) {
        this.m_logger = logger;
        LogUtilities.logFunctionEntrance(this.m_logger, name, logger);
        this.m_warningListener = warningListener;
        this.m_name = name;
    }

    @Override
    public int getSavepointId() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_name) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_ID_FROM_NAMED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        return this.m_id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_name) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_ID_FROM_NAMED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        return this.m_name;
    }

    boolean isNamed() {
        return null != this.m_name;
    }
}

