/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.TypeNames;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class SResultSetMetaData
implements ResultSetMetaData {
    private List<? extends IColumn> m_columnMetaData = new ArrayList<IColumn>();
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    protected SResultSetMetaData(List<? extends IColumn> metadata, ILogger logger, IWarningListener warningListener) {
        this.m_logger = logger;
        LogUtilities.logFunctionEntrance(this.m_logger, metadata, logger);
        this.m_warningListener = warningListener;
        this.m_columnMetaData = metadata;
    }

    @Override
    public String getCatalogName(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getCatalogName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            TypeMetadata typeMeta = this.getTypeMetadata(columnIndex);
            return TypeNames.getTypeClassName(typeMeta.getType());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            return this.m_columnMetaData.size();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            long displaySize = colMeta.getDisplaySize();
            return displaySize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)displaySize;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getLabel();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            TypeMetadata typeMeta = this.getTypeMetadata(columnIndex);
            return TypeUtilities.mapDataTypes(typeMeta.getType());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            TypeMetadata typeMeta = this.getTypeMetadata(columnIndex);
            return typeMeta.getTypeName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            TypeMetadata typeMeta = colMeta.getTypeMetadata();
            short sqlType = typeMeta.getType();
            if (typeMeta.isCharacterOrBinaryType()) {
                long precision = colMeta.getColumnLength();
                return precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)precision;
            }
            if (91 == sqlType || 92 == sqlType || 93 == sqlType) {
                return (int)colMeta.getDisplaySize();
            }
            if (typeMeta.isIntervalType()) {
                return typeMeta.getIntervalPrecision();
            }
            return typeMeta.getPrecision();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            TypeMetadata typeMeta = this.getTypeMetadata(columnIndex);
            return typeMeta.getScale();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchemaName(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getSchemaName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getTableName(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getTableName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.isAutoUnique();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.isCaseSensitive();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCurrency(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            return this.getColumnMetadata(columnIndex).getTypeMetadata().isCurrency();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            return this.getColumnMetadata(columnIndex).isDefinitelyWritable();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int isNullable(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            switch (colMeta.getNullable()) {
                case NO_NULLS: {
                    return 0;
                }
                case NULLABLE: {
                    return 1;
                }
            }
            return 2;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isReadOnly(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getUpdatable() == Updatable.READ_ONLY || colMeta.getUpdatable() == Updatable.UNKNOWN;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSearchable(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getSearchable() != Searchable.PREDICATE_NONE;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isSigned(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            TypeMetadata typeMeta = this.getTypeMetadata(columnIndex);
            return typeMeta.isSigned();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWritable(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            IColumn colMeta = this.getColumnMetadata(columnIndex);
            return colMeta.getUpdatable() == Updatable.WRITE;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    private IColumn getColumnMetadata(int columnIndex) throws SQLException {
        if (!this.isValidIndex(columnIndex)) {
            SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(columnIndex));
            LogUtilities.logError(exception, this.m_logger);
            throw exception;
        }
        return this.m_columnMetaData.get(columnIndex - 1);
    }

    private TypeMetadata getTypeMetadata(int columnIndex) throws SQLException {
        IColumn colMeta = this.getColumnMetadata(columnIndex);
        return colMeta.getTypeMetadata();
    }

    private boolean isValidIndex(int columnIndex) {
        return 0 < columnIndex && this.m_columnMetaData.size() >= columnIndex;
    }
}

