/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.yworks.yguard.common.ResourcePolicy;
import com.yworks.yguard.common.ShrinkBag;
import com.yworks.yshrink.core.OutputVisitor;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.util.JarStreamProvider;
import com.yworks.yshrink.util.Logger;
import com.yworks.yshrink.util.Util;
import com.yworks.yshrink.util.Version;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Writer {
    private static final String MANIFEST_FILENAME = "META-INF/MANIFEST.MF";
    private static final String SIGNATURE_FILE_PREFIX = "META-INF/";
    private static final String SIGNATURE_FILE_SUFFIX = ".SF";
    private final boolean createStubs;
    private final MessageDigest[] digests;

    public Writer(boolean createStubs, String digestNamesStr) {
        int i;
        this.createStubs = createStubs;
        String[] digestNames = digestNamesStr.trim().equalsIgnoreCase("none") ? new String[]{} : digestNamesStr.split(",");
        for (i = 0; i < digestNames.length; ++i) {
            digestNames[i] = digestNames[i].trim();
        }
        this.digests = new MessageDigest[digestNames.length];
        for (i = digestNames.length - 1; i >= 0; --i) {
            try {
                this.digests[i] = MessageDigest.getInstance(digestNames[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                Logger.err("Unknwon digest algorithm: " + digestNames[i]);
                this.digests[i] = null;
            }
        }
    }

    public void write(Model model, ShrinkBag bag) throws IOException {
        File in = bag.getIn();
        File out = bag.getOut();
        Logger.log("writing shrinked " + in + " to " + out + ".");
        Logger.shrinkLog("<inOutPair in=\"" + in + "\" out=\"" + out + "\">");
        long inLength = in.length();
        JarFile inJar = new JarFile(in);
        JarStreamProvider jarStreamProvider = new JarStreamProvider(in.toURL());
        DataInputStream stream = jarStreamProvider.getNextClassEntryStream();
        if (!out.exists()) {
            out.createNewFile();
        }
        Manifest newManifest = new Manifest(inJar.getManifest());
        JarWriter writer = new JarWriter(out, newManifest);
        int numClasses = 0;
        int numObsoleteClasses = 0;
        int numObsoleteMethods = 0;
        int numObsoleteFields = 0;
        int numRemovedResources = 0;
        HashSet<String> nonEmptyDirs = new HashSet<String>(5);
        Logger.shrinkLog("\t<removed-code>");
        while (stream != null) {
            String entryName = jarStreamProvider.getCurrentEntryName();
            ++numClasses;
            ClassDescriptor cd = model.getClassDescriptor(entryName.substring(0, entryName.lastIndexOf(".class")));
            boolean obsolete = model.isObsolete(cd.getNode());
            if (!obsolete) {
                nonEmptyDirs.add(jarStreamProvider.getCurrentDir());
                ClassWriter cw = new ClassWriter(1);
                OutputVisitor outputVisitor = new OutputVisitor((ClassVisitor)cw, model, this.createStubs);
                ClassReader cr = new ClassReader((InputStream)stream);
                cr.accept((ClassVisitor)outputVisitor, 0);
                numObsoleteMethods += outputVisitor.getNumObsoleteMethods();
                numObsoleteFields += outputVisitor.getNumObsoleteFields();
                byte[] modifiedClass = cw.toByteArray();
                writer.addEntry(entryName, modifiedClass);
            } else {
                newManifest.getEntries().remove(entryName);
                ++numObsoleteClasses;
                Logger.shrinkLog("\t\t<class name=\"" + Util.toJavaClass(entryName) + "\" />");
            }
            stream = jarStreamProvider.getNextClassEntryStream();
        }
        Logger.shrinkLog("\t</removed-code>");
        Logger.shrinkLog("\t<removed-resources>");
        ResourcePolicy resourcePolicy = bag.getResources();
        if (!resourcePolicy.equals((Object)ResourcePolicy.NONE)) {
            jarStreamProvider.reset();
            stream = jarStreamProvider.getNextResourceEntryStream();
            while (stream != null) {
                String entryName = jarStreamProvider.getCurrentEntryName();
                if (!resourcePolicy.equals((Object)ResourcePolicy.NONE) && (resourcePolicy.equals((Object)ResourcePolicy.COPY) || resourcePolicy.equals((Object)ResourcePolicy.AUTO) && nonEmptyDirs.contains(jarStreamProvider.getCurrentDir()))) {
                    this.copyResource(entryName, jarStreamProvider, stream, writer);
                } else {
                    ++numRemovedResources;
                    Logger.shrinkLog("\t<resource dir=\"" + jarStreamProvider.getCurrentDir() + "\" name=\"" + jarStreamProvider.getCurrentFilename() + "\" />");
                }
                stream = jarStreamProvider.getNextResourceEntryStream();
            }
        }
        Logger.shrinkLog("\t</removed-resources>");
        writer.close();
        long outLength = out.length();
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(2);
        String percent = nf.format(1.0 - (double)outLength / (double)inLength);
        Logger.log("\tshrinked " + in + " BY " + percent + ".");
        Logger.log("\tsize before: " + inLength / 1024L + " KB, size after: " + outLength / 1024L + " KB.");
        Logger.log("\tremoved " + numObsoleteClasses + " classes, " + numObsoleteMethods + " methods, " + numObsoleteFields + " fields, " + numRemovedResources + " resources.");
        Logger.log("\t" + (numClasses - numObsoleteClasses) + " classes remaining of " + numClasses + " total.");
        Logger.shrinkLog("</inOutPair>");
    }

    private void copyResource(String entryName, JarStreamProvider jarStreamProvider, DataInputStream stream, JarWriter writer) throws IOException {
        int entrySize;
        if (!(entryName.equals(MANIFEST_FILENAME) || entryName.endsWith(SIGNATURE_FILE_SUFFIX) && entryName.startsWith(SIGNATURE_FILE_PREFIX) || -1 == (entrySize = (int)jarStreamProvider.currentEntry().getSize()))) {
            byte[] data = new byte[entrySize];
            stream.readFully(data);
            writer.addEntry(entryName, data);
        }
    }

    private class JarWriter {
        private Set<String> directoriesWritten = new HashSet<String>();
        private final FileOutputStream fos;
        private final JarOutputStream jos;
        private Manifest manifest;

        public JarWriter(File outFile, Manifest manifest) throws IOException {
            this.manifest = null != manifest ? manifest : new Manifest();
            this.fos = new FileOutputStream(outFile);
            this.jos = new JarOutputStream(new BufferedOutputStream(this.fos));
        }

        private void addDigests(String entryName) {
            Attributes oldEntryAttributes = this.manifest.getAttributes(entryName);
            Attributes newEntryAttributes = new Attributes(Writer.this.digests.length + 1);
            if (null != oldEntryAttributes) {
                Set<Object> keys = oldEntryAttributes.keySet();
                for (Object key : keys) {
                    if (((Attributes.Name)key).toString().indexOf("Digest") != -1) continue;
                    newEntryAttributes.put(key, oldEntryAttributes.get(key));
                }
            }
            StringBuffer digestsList = new StringBuffer();
            for (int i = 0; i < Writer.this.digests.length; ++i) {
                MessageDigest digest = Writer.this.digests[i];
                if (null == digest) continue;
                String digestKey = digest.getAlgorithm() + "-Digest";
                digestsList.append(digest.getAlgorithm());
                if (i < Writer.this.digests.length - 1) {
                    digestsList.append(", ");
                }
                String digestVal = Util.toBase64(digest.digest());
                newEntryAttributes.putValue(digestKey, digestVal);
            }
            newEntryAttributes.putValue("Digest-Algorithms", digestsList.toString());
            this.manifest.getEntries().put(entryName, newEntryAttributes);
        }

        private void addEntry(String fileName, byte[] data) throws IOException {
            JarEntry outEntry = new JarEntry(fileName);
            this.addDirectory(fileName);
            this.jos.putNextEntry(outEntry);
            this.jos.write(data);
            this.jos.closeEntry();
            this.calcDigests(data);
            this.addDigests(fileName);
        }

        private void calcDigests(byte[] data) {
            for (int i = Writer.this.digests.length - 1; i >= 0; --i) {
                if (null == Writer.this.digests[i]) continue;
                Writer.this.digests[i].reset();
                Writer.this.digests[i].update(data);
            }
        }

        private void addDirectory(String fileName) throws IOException {
            int index = 0;
            while ((index = fileName.indexOf("/", index + 1)) >= 0) {
                String directory = fileName.substring(0, index + 1);
                if (this.directoriesWritten.contains(directory)) continue;
                this.directoriesWritten.add(directory);
                JarEntry directoryEntry = new JarEntry(directory);
                this.jos.putNextEntry(directoryEntry);
                this.jos.closeEntry();
            }
        }

        private void close() throws IOException {
            this.finishManifest();
            if (this.jos != null) {
                this.jos.finish();
                this.jos.close();
            }
            if (this.fos != null) {
                this.fos.close();
            }
        }

        private void finishManifest() throws IOException {
            this.manifest.getMainAttributes().putValue("Created-by", "yGuard Bytecode Obfuscator: Shrinker " + Version.getVersion());
            this.addDirectory(Writer.MANIFEST_FILENAME);
            this.jos.putNextEntry(new JarEntry(Writer.MANIFEST_FILENAME));
            this.manifest.write(this.jos);
            this.jos.closeEntry();
        }
    }
}

