/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Connection;
import com.nuodb.jdbc.ConnectionKey;
import com.nuodb.jdbc.ConnectionUrl;
import com.nuodb.jdbc.Driver;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemSQLUtils;
import com.nuodb.jdbc.RemStatement;
import com.nuodb.jdbc.StatementKey;
import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.logger.LoggerManager;
import com.nuodb.jdbc.pool.DefaultObjectPool;
import com.nuodb.jdbc.pool.ObjectFactory;
import com.nuodb.jdbc.pool.ObjectPool;
import com.nuodb.jdbc.pool.ObjectPoolConfig;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class DataSource
implements javax.sql.DataSource,
ConnectionPoolDataSource,
Closeable {
    public static final String PROP_URL = "url";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_SCHEMA = "defaultSchema";
    public static final String PROP_SQL_ENGINE = "SQLEngine";
    public static final String PROP_MAXACTIVE = "maxActive";
    public static final String PROP_MAXIDLE = "maxIdle";
    public static final String PROP_MINIDLE = "minIdle";
    public static final String PROP_INITIALSIZE = "initialSize";
    public static final String PROP_MAXWAIT = "maxWait";
    public static final String PROP_MAXAGE = "maxAge";
    public static final String PROP_DEFAULTREADONLY = "defaultReadOnly";
    public static final String PROP_DEFAULTAUTOCOMMIT = "defaultAutoCommit";
    public static final String PROP_TESTONRETURN = "testOnReturn";
    public static final String PROP_TESTONBORROW = "testOnBorrow";
    public static final String PROP_TESTWHILEIDLE = "testWhileIdle";
    public static final String PROP_VALIDATIONQUERY = "validationQuery";
    public static final String PROP_VALIDATIONINTERVAL = "validationInterval";
    public static final String PROP_IDLEVALIDATIONINTERVAL = "timeBetweenEvictionRunsMillis";
    public static final String PROP_MAXSTATEMENTS = "maxStatements";
    public static final String PROP_MAXSTATEMENTSPERCONNECTION = "maxStatementsPerConnection";
    public static final String PROP_URLDELIMITER = "url-delimiter";
    public static final String DEFAULT_URL = "jdbc:com.nuodb://localhost:48004/";
    public static final int DEFAULT_MAXSTATEMENTS = 0;
    public static final int DEFAULT_MAXSTATEMENTSPERCONNECTION = 0;
    public static final long DEFAULT_INITIALSIZE = 10L;
    public static final String[] ALL_PROPERTIES = DataSource.getAllProperties();
    private static final ClassLoader CLASS_LOADER = DataSource.class.getClassLoader();
    private static final String STATEMENT_POOL_NAME = "statement";
    private static final String CONNECTION_POOL_NAME = "connection";
    protected String url;
    private String urlDelimiter;
    protected String user;
    protected String password;
    protected String schema;
    protected String sqlEngine;
    private Driver driver;
    private Properties properties;
    private ObjectPool<ConnectionKey, Connection, ConnectionHelper> connectionPool;
    private ObjectPool<StatementKey, Statement, StatementHelper> statementPool;
    private Boolean defaultAutoCommit;
    private Boolean defaultReadOnly;
    private volatile boolean initialized;
    private Logger logger;
    private PrintWriter logWriter = null;
    private Properties loggerProperties = new Properties();
    public static final String DRIVER_URL_PREFIX = "jdbc:com.nuodb:";
    public static final String DRIVER_CLASS_NAME = "com.nuodb.jdbc.Driver";
    public static final String HIBERNATE_DRIVER_URL_PREFIX = "jdbc:com.nuodb.hib:";
    public static final String HIBERNATE_DRIVER_CLASS_NAME = "com.nuodb.hibernate.NuoHibernateDriver";
    private static final Map<String, String> DRIVERS = DataSource.getDrivers();

    private static String[] getAllProperties() {
        HashSet<String> properties = new HashSet<String>();
        properties.addAll(Arrays.asList(PROP_URL, PROP_SCHEMA, PROP_USERNAME, PROP_PASSWORD, PROP_MAXACTIVE, PROP_MAXIDLE, PROP_MINIDLE, PROP_INITIALSIZE, PROP_DEFAULTREADONLY, PROP_DEFAULTAUTOCOMMIT, PROP_MAXWAIT, PROP_MAXAGE, PROP_TESTONRETURN, PROP_TESTONBORROW, PROP_TESTWHILEIDLE, PROP_VALIDATIONQUERY, PROP_VALIDATIONINTERVAL, PROP_IDLEVALIDATIONINTERVAL, PROP_MAXSTATEMENTS, PROP_MAXSTATEMENTSPERCONNECTION, PROP_URLDELIMITER, PROP_SQL_ENGINE));
        properties.addAll(LoggerManager.getLoggerProperties());
        return properties.toArray(new String[properties.size()]);
    }

    private static Map<String, String> getDrivers() {
        HashMap<String, String> drivers = new HashMap<String, String>();
        drivers.put(DRIVER_URL_PREFIX, DRIVER_CLASS_NAME);
        drivers.put(HIBERNATE_DRIVER_URL_PREFIX, HIBERNATE_DRIVER_CLASS_NAME);
        return Collections.unmodifiableMap(drivers);
    }

    public DataSource() {
        this.setProperties(new Properties());
        this.createConnectionAndStatementPools();
    }

    public DataSource(Properties info) {
        this.setProperties(info);
        this.createConnectionAndStatementPools();
        this.createInitialConnections();
    }

    public void setProperties(Properties info) {
        this.checkInitialized();
        this.properties = info;
        this.setUrl(info.getProperty(PROP_URL, String.valueOf(DEFAULT_URL)));
        ConnectionUrl connectionUrl = this.getConnectionUrl(this.url, info);
        this.properties = connectionUrl.getProperties();
        this.urlDelimiter = this.properties.getProperty(PROP_URLDELIMITER, this.urlDelimiter);
        this.user = this.properties.getProperty(PROP_USER, this.user);
        this.user = this.properties.getProperty(PROP_USERNAME, this.user);
        this.password = this.properties.getProperty(PROP_PASSWORD, this.password);
        this.schema = this.properties.getProperty(PROP_SCHEMA, this.schema);
        this.sqlEngine = this.properties.getProperty(PROP_SQL_ENGINE, this.sqlEngine);
        if (this.properties.containsKey(PROP_DEFAULTAUTOCOMMIT)) {
            this.defaultAutoCommit = Boolean.parseBoolean(this.properties.getProperty(PROP_DEFAULTAUTOCOMMIT));
        }
        if (this.properties.containsKey(PROP_DEFAULTREADONLY)) {
            this.defaultReadOnly = Boolean.parseBoolean(this.properties.getProperty(PROP_DEFAULTREADONLY));
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String property = (String)entry.getKey();
            if (!LoggerManager.isLoggerProperty(property)) continue;
            this.loggerProperties.put(property, entry.getValue());
        }
        this.getLogger();
    }

    private void createConnectionAndStatementPools() {
        this.connectionPool = this.createConnectionPool();
        this.statementPool = this.createStatementPool();
    }

    private synchronized void createInitialConnections() {
        ObjectPoolConfig connectionPoolConfig;
        String validationQuery = this.properties.getProperty(PROP_VALIDATIONQUERY);
        if (validationQuery != null) {
            validationQuery = validationQuery.trim();
        }
        if (((connectionPoolConfig = this.connectionPool.getObjectPoolConfig()).isTestOnBorrow() || connectionPoolConfig.isTestOnReturn()) && (validationQuery == null || validationQuery.isEmpty())) {
            throw new IllegalArgumentException(String.format("When either %s or %s is set to true, %s must also be specified", PROP_TESTONBORROW, PROP_TESTONRETURN, PROP_VALIDATIONQUERY));
        }
        this.connectionPool.setObjectFactory(new ConnectionFactory(validationQuery));
        for (long i = 0L; i < this.connectionPool.getObjectPoolConfig().getInitialSize(); ++i) {
            try {
                ConnectionKey connectionKey = new ConnectionKey(this.user, this.password);
                this.connectionPool.addObject(connectionKey, this.createConnectionHelper(connectionKey));
                continue;
            }
            catch (Exception exception) {
                break;
            }
        }
        this.connectionPool.setFillCallback(new ObjectPool.FillCallbackRunnable(){

            @Override
            public void run() throws Exception {
                try {
                    ConnectionKey connectionKey = new ConnectionKey(DataSource.this.user, DataSource.this.password);
                    DataSource.this.connectionPool.addObject(connectionKey, DataSource.this.createConnectionHelper(connectionKey));
                }
                catch (Exception ex) {
                    DataSource.this.logger.error("Filling connection pool failed", ex);
                    throw ex;
                }
            }
        });
        if (this.connectionPool.getObjectPoolConfig().getInitialSize() == 0L || this.connectionPool.getIdleObjects() > 0L) {
            this.initialized = true;
        }
        this.writeConfigurationToLogger();
    }

    private synchronized void writeConfigurationToLogger() {
        if (this.logger != null) {
            this.logger.info(this.toString());
            if (this.connectionPool != null) {
                this.logger.info("Connection pool: " + this.connectionPool.getObjectPoolConfig().toString());
            }
            this.warnIfStatementCacheEnabled();
        }
    }

    private synchronized void warnIfStatementCacheEnabled() {
        int maxStatements = Integer.parseInt(this.properties.getProperty(PROP_MAXSTATEMENTS, String.valueOf(0)));
        int maxStatementsPerConnection = Integer.parseInt(this.properties.getProperty(PROP_MAXSTATEMENTSPERCONNECTION, String.valueOf(0)));
        if (maxStatements > 0) {
            this.logger.warn("Ignoring value of " + maxStatements + " for maxStatements, as statement caching feature is not supported.");
        }
        if (maxStatementsPerConnection > 0) {
            this.logger.warn("Ignoring value of " + maxStatementsPerConnection + " for maxStatementsPerConnection, as statement caching feature is not supported.");
        }
    }

    protected Driver getDriver(String url) {
        Driver driver = null;
        for (Map.Entry<String, String> entry : DRIVERS.entrySet()) {
            String urlPrefix = entry.getKey();
            String driverClassName = entry.getValue();
            if (!url.startsWith(urlPrefix)) continue;
            try {
                driver = (Driver)Class.forName(driverClassName).newInstance();
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException exception) {
                throw new IllegalArgumentException(String.format("Driver %s can not be loaded", driverClassName), exception);
            }
        }
        if (driver == null || !driver.acceptsURL(url)) {
            throw new IllegalArgumentException(String.format("No driver found which accepts %s connection url", url));
        }
        return driver;
    }

    protected ObjectPool<StatementKey, Statement, StatementHelper> createStatementPool() {
        return null;
    }

    protected ObjectPool<ConnectionKey, Connection, ConnectionHelper> createConnectionPool() {
        DefaultObjectPool<ConnectionKey, Connection, ConnectionHelper> connectionPool = new DefaultObjectPool<ConnectionKey, Connection, ConnectionHelper>();
        connectionPool.setName(CONNECTION_POOL_NAME);
        connectionPool.setLogger(this.logger);
        long initialSize = Long.parseLong(this.properties.getProperty(PROP_INITIALSIZE, String.valueOf(10L)));
        DataSource.assertNonNegative(PROP_INITIALSIZE, initialSize);
        ObjectPoolConfig objectPoolConfig = this.createObjectPoolConfig(initialSize);
        connectionPool.setObjectPoolConfig(objectPoolConfig);
        return connectionPool;
    }

    protected ObjectPoolConfig createObjectPoolConfig(long initialSize) {
        ObjectPoolConfig objectPoolConfig = new ObjectPoolConfig();
        this.updateObjectPoolConfig(objectPoolConfig, initialSize);
        return objectPoolConfig;
    }

    private void updateObjectPoolConfig(ObjectPoolConfig objectPoolConfig) {
        this.updateObjectPoolConfig(objectPoolConfig, -1L);
    }

    private void updateObjectPoolConfig(ObjectPoolConfig objectPoolConfig, long initialSize) {
        long maxActive = Long.parseLong(this.properties.getProperty(PROP_MAXACTIVE, String.valueOf(100L)));
        long maxIdle = Long.parseLong(this.properties.getProperty(PROP_MAXIDLE, String.valueOf(maxActive)));
        long initSize = initialSize == -1L ? Long.parseLong(this.properties.getProperty(PROP_INITIALSIZE, String.valueOf(10L))) : initialSize;
        long minIdle = Long.parseLong(this.properties.getProperty(PROP_MINIDLE, String.valueOf(initSize)));
        long maxWait = Long.parseLong(this.properties.getProperty(PROP_MAXWAIT, String.valueOf(0L)));
        long maxAge = Long.parseLong(this.properties.getProperty(PROP_MAXAGE, String.valueOf(0L)));
        long validationInterval = Long.parseLong(this.properties.getProperty(PROP_VALIDATIONINTERVAL, String.valueOf(30000)));
        long idleValidationInterval = Long.parseLong(this.properties.getProperty(PROP_IDLEVALIDATIONINTERVAL, String.valueOf(5000)));
        boolean testOnReturn = Boolean.parseBoolean(this.properties.getProperty(PROP_TESTONRETURN, String.valueOf(false)));
        boolean testOnBorrow = Boolean.parseBoolean(this.properties.getProperty(PROP_TESTONBORROW, String.valueOf(false)));
        boolean testWhileIdle = Boolean.parseBoolean(this.properties.getProperty(PROP_TESTWHILEIDLE, String.valueOf(false)));
        if (maxActive < 1L) {
            this.logger.warn("maxActive is smaller than 1, setting maxActive to: 100");
            maxActive = 100L;
        }
        if (initSize > maxActive) {
            this.logger.warn("initialSize is larger than maxActive, setting initialSize to: " + maxActive);
            initSize = maxActive;
        }
        if (minIdle > maxActive) {
            this.logger.warn("minIdle is larger than maxActive, setting minIdle to: " + maxActive);
            minIdle = maxActive;
        }
        if (maxIdle > maxActive) {
            this.logger.warn("maxIdle is larger than maxActive, setting maxIdle to: " + maxActive);
            maxIdle = maxActive;
        }
        if (maxIdle < minIdle) {
            this.logger.warn("maxIdle is smaller than minIdle, setting maxIdle to: " + minIdle);
            maxIdle = minIdle;
        }
        DataSource.assertNonNegative(PROP_MINIDLE, minIdle);
        DataSource.assertNonNegative(PROP_MAXIDLE, maxIdle);
        DataSource.assertNonNegative(PROP_MAXACTIVE, maxActive);
        DataSource.assertNonNegative(PROP_MAXAGE, maxAge);
        DataSource.assertNonNegative(PROP_MAXWAIT, maxWait);
        DataSource.assertNonNegative(PROP_VALIDATIONINTERVAL, validationInterval);
        DataSource.assertNonNegative(PROP_IDLEVALIDATIONINTERVAL, idleValidationInterval);
        objectPoolConfig.setInitialSize(initSize);
        objectPoolConfig.setMaxActive(maxActive);
        objectPoolConfig.setMaxIdle(maxIdle);
        objectPoolConfig.setMinIdle(minIdle);
        objectPoolConfig.setMaxWait(maxWait);
        objectPoolConfig.setMaxAge(maxAge);
        objectPoolConfig.setTestOnReturn(testOnReturn);
        objectPoolConfig.setTestOnBorrow(testOnBorrow);
        objectPoolConfig.setTestWhileIdle(testWhileIdle);
        objectPoolConfig.setValidationInterval(validationInterval);
        objectPoolConfig.setIdleValidationInterval(idleValidationInterval);
    }

    private static void assertNonNegative(String property, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("%s cannot be set to a negative value", property));
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
        if (logWriter == null) {
            this.loggerProperties.remove("standardLogger.logWriter");
        } else {
            this.loggerProperties.put("standardLogger.logWriter", logWriter);
        }
        Logger logger = this.initLogger(true);
        if (this.statementPool != null) {
            this.statementPool.setLogger(logger);
        }
        if (this.connectionPool != null) {
            this.connectionPool.setLogger(logger);
        }
        this.writeConfigurationToLogger();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.statementPool != null) {
                this.statementPool.close();
            }
            if (this.connectionPool != null) {
                this.connectionPool.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected Logger getLogger() {
        return this.initLogger(false);
    }

    protected Logger initLogger(boolean reset) {
        if (this.logger == null || reset) {
            this.logger = LoggerManager.getLoggerManager(this.loggerProperties).getLoggerFactory().getLogger();
        }
        return this.logger;
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int loginTimeout) {
        DriverManager.setLoginTimeout(loginTimeout);
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        return LoggerManager.getParentLogger();
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        throw new SQLException(String.format("%s is not a wrapper for an object implementing any interface", this.getClass().getName()));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getConnection(new ConnectionKey(user, password));
    }

    public ConnectionHelper createConnectionHelper(ConnectionKey connectionKey) {
        StatementHelper statementHelper = new StatementHelper();
        statementHelper.setStatementPool(this.statementPool);
        ConnectionHelper connectionHelper = new ConnectionHelper();
        connectionHelper.setConnectionKey(connectionKey);
        connectionHelper.setConnectionPool(this.connectionPool);
        connectionHelper.setStatementHelper(statementHelper);
        return connectionHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(ConnectionKey connectionKey) throws SQLException {
        if (!this.initialized) {
            DataSource dataSource = this;
            synchronized (dataSource) {
                if (!this.initialized) {
                    this.createInitialConnections();
                }
            }
        }
        try {
            final ConnectionHelper connectionHelper = this.createConnectionHelper(connectionKey);
            connectionHelper.setConnection(this.connectionPool.borrowObject(connectionKey, connectionHelper));
            return DataSource.createConnectionProxy(new ConnectionHandle(connectionHelper, new Callable(){

                @Override
                public void call() throws Exception {
                    connectionHelper.returnOrCloseConnection();
                }
            }, this.logger));
        }
        catch (SQLException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public javax.sql.PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.user, this.password);
    }

    @Override
    public javax.sql.PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.getPooledConnection(new ConnectionKey(user, password));
    }

    public static boolean connectionsAreIdentical(java.sql.Connection lhs, java.sql.Connection rhs) {
        if (lhs instanceof Proxy && rhs instanceof Proxy) {
            InvocationHandler lhsHandler = Proxy.getInvocationHandler(lhs);
            InvocationHandler rhsHandler = Proxy.getInvocationHandler(rhs);
            if (lhsHandler instanceof ConnectionHandle && rhsHandler instanceof ConnectionHandle) {
                Connection t2;
                Connection t1 = (Connection)((ConnectionHandle)lhsHandler).getTarget();
                return t1 == (t2 = (Connection)((ConnectionHandle)rhsHandler).getTarget());
            }
        }
        return false;
    }

    public long getPoolIdleConnectionSize() {
        return this.connectionPool.getIdleObjects();
    }

    public long getPoolActiveConnectionSize() {
        return this.connectionPool.getActiveObjects();
    }

    protected PooledConnection getPooledConnection(ConnectionKey connectionKey) throws SQLException {
        return new PooledConnection(connectionKey, this.connect(connectionKey, new PooledConnectionHandler()));
    }

    protected Connection connect(ConnectionKey connectionKey, RemConnection.ErrorHandler errorHandler) throws SQLException {
        String password;
        Properties properties = new Properties();
        String user = connectionKey.getUser();
        if (user != null) {
            properties.setProperty(PROP_USER, user);
        }
        if ((password = connectionKey.getPassword()) != null) {
            properties.setProperty(PROP_PASSWORD, password);
        }
        if (this.schema != null) {
            properties.setProperty("schema", this.schema);
        }
        if (this.urlDelimiter != null) {
            properties.setProperty(PROP_URLDELIMITER, this.urlDelimiter);
        }
        if (this.sqlEngine != null) {
            properties.setProperty(PROP_SQL_ENGINE, this.sqlEngine);
        }
        ConnectionUrl connectionUrl = this.getConnectionUrl(this.url, properties);
        Connection connection = this.getDriver().connect(connectionUrl, errorHandler, this.logger);
        if (this.defaultAutoCommit != null) {
            connection.setAutoCommit(this.defaultAutoCommit);
        }
        if (this.defaultReadOnly != null) {
            connection.setReadOnly(this.defaultReadOnly);
        }
        return connection;
    }

    private Driver getDriver() {
        return this.driver;
    }

    private String getPrefix() {
        return this.driver.getPrefix();
    }

    private ConnectionUrl getConnectionUrl(String url, Properties properties) {
        return new ConnectionUrl(this.getPrefix(), url, properties);
    }

    private static Connection createConnectionProxy(ConnectionHandle connectionHandle) {
        Connection connectionProxy = (Connection)Proxy.newProxyInstance(CLASS_LOADER, new Class[]{Connection.class}, (InvocationHandler)connectionHandle);
        connectionHandle.setTargetProxy(connectionProxy);
        return connectionProxy;
    }

    private static Statement createStatementProxy(Class statementClass, StatementHandle statementHandle) {
        Statement statementProxy = (Statement)Proxy.newProxyInstance(CLASS_LOADER, new Class[]{statementClass}, (InvocationHandler)statementHandle);
        statementHandle.setTargetProxy(statementProxy);
        return statementProxy;
    }

    private static ResultSet createResultSetProxy(Statement statementProxy, ResultSet resultSet, Logger logger) {
        ResultSetHandle resultSetHandle = new ResultSetHandle(statementProxy, resultSet, logger);
        ResultSet resultSetProxy = resultSet != null ? (ResultSet)Proxy.newProxyInstance(CLASS_LOADER, new Class[]{ResultSet.class}, (InvocationHandler)resultSetHandle) : null;
        resultSetHandle.setTargetProxy(resultSetProxy);
        return resultSetProxy;
    }

    public void setUrl(String url) {
        this.checkInitialized();
        if (url == null) {
            throw new IllegalArgumentException(String.format("The %s must not be empty", PROP_URL));
        }
        this.url = url;
        this.properties.setProperty(PROP_URL, url);
        this.driver = this.getDriver(this.url);
    }

    public void setUrlDelimiter(String urlDelimiter) {
        this.checkInitialized();
        this.urlDelimiter = urlDelimiter;
        this.properties.setProperty(PROP_URLDELIMITER, urlDelimiter);
    }

    public void setUser(String user) {
        this.checkInitialized();
        this.user = user;
        this.properties.setProperty(PROP_USER, user);
    }

    public void setUsername(String username) {
        this.checkInitialized();
        this.user = username;
        this.properties.setProperty(PROP_USERNAME, username);
    }

    public void setPassword(String password) {
        this.checkInitialized();
        this.password = password;
        this.properties.setProperty(PROP_PASSWORD, password);
    }

    public void setSchema(String schema) {
        this.checkInitialized();
        this.setDefaultSchema(schema);
    }

    public void setDefaultSchema(String schema) {
        this.checkInitialized();
        this.schema = schema;
        this.properties.setProperty(PROP_SCHEMA, schema);
    }

    public void setSQLEngine(String engine) {
        this.checkInitialized();
        this.sqlEngine = engine;
        this.properties.setProperty(PROP_SQL_ENGINE, engine);
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.checkInitialized();
        this.defaultReadOnly = defaultReadOnly;
        this.properties.setProperty(PROP_DEFAULTREADONLY, String.valueOf(defaultReadOnly));
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.checkInitialized();
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public void setInitialSize(long initialSize) {
        this.checkInitialized();
        DataSource.assertNonNegative(PROP_INITIALSIZE, initialSize);
        this.properties.setProperty(PROP_INITIALSIZE, String.valueOf(initialSize));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setMaxActive(long maxActive) {
        this.checkInitialized();
        this.properties.setProperty(PROP_MAXACTIVE, String.valueOf(maxActive));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
        this.connectionPool.initializeActiveCounter();
    }

    public void setMaxIdle(long maxIdle) {
        this.checkInitialized();
        this.properties.setProperty(PROP_MAXIDLE, String.valueOf(maxIdle));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setMinIdle(long minIdle) {
        this.checkInitialized();
        this.properties.setProperty(PROP_MINIDLE, String.valueOf(minIdle));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setMaxWait(long maxWait) {
        this.checkInitialized();
        this.properties.setProperty(PROP_MAXWAIT, String.valueOf(maxWait));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setMaxAge(long maxAge) {
        this.checkInitialized();
        this.properties.setProperty(PROP_MAXAGE, String.valueOf(maxAge));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setMaxStatementsPerConnection(long maxStatementsPerConnection) {
        this.checkInitialized();
        this.properties.setProperty(PROP_MAXSTATEMENTSPERCONNECTION, String.valueOf(maxStatementsPerConnection));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
        this.statementPool = this.createStatementPool();
        if (this.logger != null) {
            this.warnIfStatementCacheEnabled();
        }
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.checkInitialized();
        this.properties.setProperty(PROP_TESTONRETURN, String.valueOf(testOnReturn));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.checkInitialized();
        this.properties.setProperty(PROP_TESTONBORROW, String.valueOf(testOnBorrow));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.checkInitialized();
        this.properties.setProperty(PROP_TESTWHILEIDLE, String.valueOf(testWhileIdle));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setValidationQuery(String validationQuery) {
        this.checkInitialized();
        this.properties.setProperty(PROP_VALIDATIONQUERY, validationQuery);
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setValidationInterval(long validationInterval) {
        this.checkInitialized();
        this.properties.setProperty(PROP_VALIDATIONINTERVAL, String.valueOf(validationInterval));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.checkInitialized();
        this.properties.setProperty(PROP_IDLEVALIDATIONINTERVAL, String.valueOf(timeBetweenEvictionRunsMillis));
        this.updateObjectPoolConfig(this.connectionPool.getObjectPoolConfig());
        ((DefaultObjectPool)this.connectionPool).initEvictionTaskIfNeeded();
    }

    private void checkInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("DataSource properties cannot be changed once initialized.");
        }
    }

    public String toString() {
        StringBuilder dataSourceConfig = new StringBuilder();
        dataSourceConfig.append("DataSource Configuration:");
        Enumeration<?> enums = this.properties.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            if (key.equals(PROP_PASSWORD)) continue;
            dataSourceConfig.append(" ");
            dataSourceConfig.append(key);
            dataSourceConfig.append("=");
            dataSourceConfig.append(this.properties.getProperty(key));
        }
        return dataSourceConfig.toString();
    }

    static interface Callable {
        public void call() throws Exception;
    }

    static abstract class Handle<T>
    implements InvocationHandler {
        protected static final String CLOSE = "close";
        protected static final String IS_CLOSED = "isClosed";
        protected static final String IS_VALID = "isValid";
        protected static final String EQUALS = "equals";
        protected String name;
        protected T target;
        protected Callable close;
        protected Logger logger;
        protected T targetProxy;
        private boolean closed;

        protected Handle(T target, Callable close, Logger logger) {
            this.target = target;
            this.close = close;
            this.logger = logger;
        }

        protected Handle(String name, T target, Callable close, Logger logger) {
            this.name = name;
            this.target = target;
            this.close = close;
            this.logger = logger;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            this.checkOpen(method);
            switch (method.getName()) {
                case "close": {
                    this.close();
                    break;
                }
                case "isClosed": {
                    result = this.isClosed();
                    break;
                }
                case "isValid": {
                    if ((Integer)args[0] < 0) {
                        throw new SQLException("Timeout value should be 0 or positive");
                    }
                    result = this.isClosed() ? Boolean.valueOf(false) : Handle.invokeMethod(this.getTarget(), method, args);
                    break;
                }
                case "equals": {
                    InvocationHandler handler;
                    Object arg = args[0];
                    if (arg != null && Proxy.isProxyClass(arg.getClass()) && (handler = Proxy.getInvocationHandler(proxy)) instanceof Handle) {
                        result = Handle.invokeMethod(this.getTarget(), method, new Object[]{((Handle)handler).getTarget()});
                        break;
                    }
                    result = Handle.invokeMethod(this.getTarget(), method, args);
                    break;
                }
                default: {
                    result = Handle.invokeMethod(this.getTarget(), method, args);
                }
            }
            return result;
        }

        protected void checkOpen(Method method) throws Exception {
            if (this.isClosed() && this.getCheckOpenMethods().contains(method)) {
                throw new SQLException(String.format("%s is already closed", this.getName()));
            }
        }

        protected Collection<Method> getCheckOpenMethods() {
            return Collections.emptySet();
        }

        protected String getName() {
            return this.name;
        }

        protected void close() throws Exception {
            if (this.isClosed()) {
                return;
            }
            this.closed = true;
            this.close.call();
        }

        public static Object invokeMethod(Object object, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(object, args);
            }
            catch (InvocationTargetException exception) {
                throw exception.getTargetException();
            }
        }

        public boolean isClosed() {
            return this.target == null || this.closed;
        }

        public void setClosed(boolean closed) {
            this.closed = closed;
        }

        public T getTarget() {
            return this.target;
        }

        public void setTarget(T target) {
            this.target = target;
        }

        public void setTargetProxy(T targetProxy) {
            this.targetProxy = targetProxy;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public void setLogger(Logger logger) {
            this.logger = logger;
        }
    }

    static class ResultSetHandle
    extends Handle<ResultSet> {
        private static final String GET_STATEMENT = "getStatement";
        private static final String NAME = "ResultSet";
        private final Statement statementProxy;

        public ResultSetHandle(Statement statementProxy, final ResultSet resultSet, final Logger logger) {
            super(NAME, resultSet, new Callable(){

                @Override
                public void call() throws Exception {
                    RemSQLUtils.close(resultSet, logger);
                }
            }, logger);
            this.statementProxy = statementProxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            switch (method.getName()) {
                case "getStatement": {
                    result = this.statementProxy;
                    break;
                }
                default: {
                    result = super.invoke(proxy, method, args);
                }
            }
            return result;
        }
    }

    static class StatementHandle
    extends Handle<Statement> {
        private static final Collection<Method> CHECK_OPEN_METHODS = StatementHandle.createCheckOpenMethods();
        private static final String STATEMENT = "Statement";
        private static final String PREPARED_STATEMENT = "PreparedStatement";
        private static final String CALLABLE_STATEMENT = "CallableStatement";
        private static final String IS_POOLABLE = "isPoolable";
        private static final String SET_POOLABLE = "setPoolable";
        private static final String GET_CONNECTION = "getConnection";
        private final Connection connectionProxy;
        private final StatementKey statementKey;
        private ResultSet resultSet;
        private boolean poolable;

        private static Collection<Method> createCheckOpenMethods() {
            HashSet<Method> checkOpenMethods = new HashSet<Method>();
            for (Class type : new Class[]{Statement.class, PreparedStatement.class, CallableStatement.class}) {
                Method[] methods;
                block9: for (Method method : methods = type.getMethods()) {
                    switch (method.getName()) {
                        case "close": 
                        case "isClosed": 
                        case "isValid": {
                            continue block9;
                        }
                        default: {
                            checkOpenMethods.add(method);
                        }
                    }
                }
            }
            return Collections.unmodifiableCollection(checkOpenMethods);
        }

        public StatementHandle(StatementHelper statementHelper, Connection connectionProxy, StatementKey statementKey, Statement statement, Callable close, Logger logger) {
            super(StatementHandle.getName(statement), statement, close, logger);
            this.connectionProxy = connectionProxy;
            this.statementKey = statementKey;
            this.poolable = statementHelper.isPoolable(statementKey);
        }

        private static String getName(Statement statement) {
            String name = statement instanceof CallableStatement ? CALLABLE_STATEMENT : (statement instanceof PreparedStatement ? PREPARED_STATEMENT : STATEMENT);
            return name;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            this.checkOpen(method);
            switch (method.getName()) {
                case "isPoolable": {
                    result = this.isPoolable();
                    break;
                }
                case "setPoolable": {
                    this.setPoolable((Boolean)args[0]);
                    break;
                }
                case "getConnection": {
                    result = this.connectionProxy;
                    break;
                }
                default: {
                    Class<?> returnType = method.getReturnType();
                    if (returnType.equals(ResultSet.class)) {
                        this.resultSet = (ResultSet)StatementHandle.invokeMethod(this.target, method, args);
                        result = DataSource.createResultSetProxy((Statement)this.targetProxy, this.resultSet, this.logger);
                        break;
                    }
                    result = super.invoke(proxy, method, args);
                }
            }
            return result;
        }

        @Override
        protected Collection<Method> getCheckOpenMethods() {
            return CHECK_OPEN_METHODS;
        }

        private boolean isPoolable() {
            return this.poolable;
        }

        private void setPoolable(boolean poolable) {
            this.poolable = poolable;
        }

        private StatementKey getStatementKey() {
            return this.statementKey;
        }
    }

    static class ConnectionHandle
    extends Handle<Connection> {
        private static final Collection<Method> CHECK_OPEN_METHODS = ConnectionHandle.createCheckOpenMethods();
        private static final String SIMPLE_NAME = "Connection";
        private static final String CREATE_STATEMENT = "createStatement";
        private static final String PREPARE_STATEMENT = "prepareStatement";
        private static final String PREPARE_CALL = "prepareCall";
        private final ConnectionKey connectionKey;
        private final StatementHelper statementHelper;

        private static Collection<Method> createCheckOpenMethods() {
            HashSet<Method> checkOpenMethods = new HashSet<Method>();
            for (Class type : new Class[]{java.sql.Connection.class, Connection.class}) {
                Method[] methods;
                block9: for (Method method : methods = type.getMethods()) {
                    switch (method.getName()) {
                        case "close": 
                        case "isClosed": 
                        case "isValid": {
                            continue block9;
                        }
                        default: {
                            checkOpenMethods.add(method);
                        }
                    }
                }
            }
            return Collections.unmodifiableCollection(checkOpenMethods);
        }

        public ConnectionHandle(ConnectionHelper connectionHelper, Callable close, Logger logger) {
            super(SIMPLE_NAME, connectionHelper.getConnection(), close, logger);
            this.connectionKey = connectionHelper.getConnectionKey();
            this.statementHelper = connectionHelper.getStatementHelper();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            this.checkOpen(method);
            switch (method.getName()) {
                case "createStatement": 
                case "prepareStatement": 
                case "prepareCall": {
                    result = this.createStatement(method, args);
                    break;
                }
                default: {
                    result = super.invoke(proxy, method, args);
                }
            }
            return result;
        }

        @Override
        protected Collection<Method> getCheckOpenMethods() {
            return CHECK_OPEN_METHODS;
        }

        private Statement createStatement(Method method, Object[] args) throws Throwable {
            StatementKey statementKey = this.getStatementKey(method, args);
            ObjectPool<StatementKey, Statement, StatementHelper> statementPool = this.statementHelper.getStatementPool();
            final Statement statement = this.statementHelper.isPoolable(statementKey) ? statementPool.borrowObject(statementKey, this.statementHelper) : (Statement)ConnectionHandle.invokeMethod(this.target, method, args);
            StatementHandle statementHandle = new StatementHandle(this.statementHelper, (Connection)this.targetProxy, statementKey, statement, new Callable(){

                @Override
                public void call() throws Exception {
                    statementHelper.closeResultSets(statement);
                    statementHelper.returnOrCloseStatement(statement);
                }
            }, this.logger);
            this.statementHelper.addStatement(statement, statementHandle);
            return DataSource.createStatementProxy(statementKey.getStatementType().getStatementClass(), statementHandle);
        }

        private StatementKey getStatementKey(Method method, Object[] args) {
            StatementKey statementKey = null;
            switch (method.getName()) {
                case "createStatement": {
                    statementKey = this.getStatementKey(args);
                    break;
                }
                case "prepareStatement": {
                    statementKey = this.getPreparedStatementKey(method, args);
                    break;
                }
                case "prepareCall": {
                    statementKey = this.getCallableStatementKey(args);
                }
            }
            return statementKey;
        }

        private StatementKey getStatementKey(Object[] args) {
            int argsCount;
            StatementKey statementKey = null;
            int n = argsCount = args != null ? args.length : 0;
            if (argsCount == 0) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target);
            } else if (argsCount == 2) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, (Integer)args[0], (Integer)args[1]);
            } else if (argsCount == 3) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, (Integer)args[0], (Integer)args[1], (int)((Integer)args[2]));
            }
            return statementKey;
        }

        private StatementKey getPreparedStatementKey(Method method, Object[] args) {
            int argsCount;
            StatementKey statementKey = null;
            int n = argsCount = args != null ? args.length : 0;
            if (argsCount == 1) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.PREPARED_STATEMENT, (String)args[0]);
            } else if (argsCount == 2) {
                Class<?> secondParameterType = method.getParameterTypes()[1];
                if (Integer.TYPE.equals(secondParameterType)) {
                    statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.PREPARED_STATEMENT, (String)args[0], (int)((Integer)args[1]));
                } else if (int[].class.equals(secondParameterType)) {
                    statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.PREPARED_STATEMENT, (String)args[0], (int[])args[1]);
                } else if (String[].class.equals(secondParameterType)) {
                    statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.PREPARED_STATEMENT, (String)args[0], (String[])args[1]);
                }
            } else if (argsCount == 3) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.PREPARED_STATEMENT, (String)args[0], (Integer)args[1], (Integer)args[2]);
            } else if (argsCount == 4) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.PREPARED_STATEMENT, (String)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3]);
            }
            return statementKey;
        }

        private StatementKey getCallableStatementKey(Object[] args) {
            int argsCount;
            StatementKey statementKey = null;
            int n = argsCount = args != null ? args.length : 0;
            if (argsCount == 1) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.CALLABLE_STATEMENT, (String)args[0]);
            } else if (argsCount == 3) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.CALLABLE_STATEMENT, (String)args[0], (Integer)args[1], (Integer)args[2]);
            } else if (argsCount == 4) {
                statementKey = new StatementKey(this.connectionKey, (Connection)this.target, StatementKey.StatementType.CALLABLE_STATEMENT, (String)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3]);
            }
            return statementKey;
        }
    }

    static class PooledConnectionHandler
    implements RemConnection.ErrorHandler {
        private PooledConnection pooledConnection;

        PooledConnectionHandler() {
        }

        @Override
        public void connectionErrorOccurred(SQLException exception) {
            PooledConnection pooledConnection = this.getPooledConnection();
            if (pooledConnection != null) {
                pooledConnection.connectionErrorOccurred(exception);
            }
        }

        public PooledConnection getPooledConnection() {
            return this.pooledConnection;
        }

        public void setPooledConnection(PooledConnection pooledConnection) {
            this.pooledConnection = pooledConnection;
        }
    }

    class PooledConnection
    implements javax.sql.PooledConnection {
        private final Collection<ConnectionEventListener> connectionEventListeners = new ArrayList<ConnectionEventListener>();
        private final Collection<StatementEventListener> statementEventListeners = new ArrayList<StatementEventListener>();
        private Connection connection;
        private ConnectionHelper connectionHelper;
        private Connection proxyConnection;
        private boolean closed;

        public PooledConnection(ConnectionKey connectionKey, Connection connection) throws SQLException {
            this.connection = connection;
            StatementHelper statementHelper = new StatementHelper(){

                @Override
                protected void statementReturned(Statement statement) {
                }

                @Override
                protected void statementClosed(Statement statement) {
                    if (statement instanceof PreparedStatement) {
                        PooledConnection.this.statementClosed((PreparedStatement)statement);
                    }
                }
            };
            statementHelper.setStatementPool(DataSource.this.statementPool);
            ConnectionHelper connectionHelper = new ConnectionHelper();
            connectionHelper.setConnection(connection);
            connectionHelper.setConnectionKey(connectionKey);
            connectionHelper.setConnectionPool(DataSource.this.connectionPool);
            connectionHelper.setStatementHelper(statementHelper);
            RemConnection.ErrorHandler errorHandler = ((RemConnection)connection).getErrorHandler();
            ((PooledConnectionHandler)errorHandler).setPooledConnection(this);
            this.connectionHelper = connectionHelper;
        }

        @Override
        public Connection getConnection() throws SQLException {
            this.checkOpen();
            if (this.proxyConnection != null) {
                this.proxyConnection.close();
                this.proxyConnection = null;
                this.connection.rollback();
                this.connection.clearWarnings();
                if (DataSource.this.defaultAutoCommit != null) {
                    this.connection.setAutoCommit(DataSource.this.defaultAutoCommit);
                }
                if (DataSource.this.defaultReadOnly != null) {
                    this.connection.setReadOnly(DataSource.this.defaultReadOnly);
                }
            }
            this.proxyConnection = DataSource.createConnectionProxy(new ConnectionHandle(this.connectionHelper, new Callable(){

                @Override
                public void call() throws Exception {
                    PooledConnection.this.connectionHelper.returnOrCloseStatements();
                    PooledConnection.this.connectionClosed();
                }
            }, DataSource.this.logger));
            return this.proxyConnection;
        }

        private boolean isClosed() {
            return this.closed;
        }

        private void checkOpen() throws SQLException {
            if (this.isClosed()) {
                throw new SQLException("The pooled connection is already closed");
            }
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.connectionEventListeners.add(listener);
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.connectionEventListeners.remove(listener);
        }

        @Override
        public void addStatementEventListener(StatementEventListener listener) {
            this.statementEventListeners.add(listener);
        }

        @Override
        public void removeStatementEventListener(StatementEventListener listener) {
            this.statementEventListeners.remove(listener);
        }

        @Override
        public void close() throws SQLException {
            block5: {
                if (this.isClosed()) {
                    return;
                }
                if (DataSource.this.logger.isTraceEnabled()) {
                    DataSource.this.logger.trace("Closing pooled connection");
                }
                this.closed = true;
                this.statementEventListeners.clear();
                this.connectionEventListeners.clear();
                try {
                    if (this.proxyConnection != null) {
                        this.proxyConnection.close();
                        this.proxyConnection = null;
                    }
                }
                catch (SQLException exception) {
                    if (!DataSource.this.logger.isWarnEnabled()) break block5;
                    DataSource.this.logger.warn("Error closing logical connection", exception);
                }
            }
            this.connectionHelper.closeConnection();
        }

        private void connectionClosed() {
            ConnectionEventListener[] connectionEventListeners;
            if (DataSource.this.logger.isTraceEnabled()) {
                DataSource.this.logger.trace("The logical connection is closed");
            }
            if ((connectionEventListeners = this.getConnectionEventListeners()).length > 0) {
                ConnectionEvent connectionEvent = new ConnectionEvent(this);
                for (ConnectionEventListener connectionEventListener : connectionEventListeners) {
                    connectionEventListener.connectionClosed(connectionEvent);
                }
            }
        }

        private void connectionErrorOccurred(SQLException exception) {
            ConnectionEventListener[] connectionEventListeners;
            if (DataSource.this.logger.isTraceEnabled()) {
                DataSource.this.logger.trace("Connection error occurred and the pooled connection can no longer be used", exception);
            }
            if ((connectionEventListeners = this.getConnectionEventListeners()).length > 0) {
                ConnectionEvent connectionEvent = new ConnectionEvent(this, exception);
                for (ConnectionEventListener connectionEventListener : connectionEventListeners) {
                    connectionEventListener.connectionErrorOccurred(connectionEvent);
                }
            }
        }

        private ConnectionEventListener[] getConnectionEventListeners() {
            return this.connectionEventListeners.toArray(new ConnectionEventListener[this.connectionEventListeners.size()]);
        }

        private void statementClosed(PreparedStatement statement) {
            StatementEventListener[] statementEventListeners = this.getStatementEventListeners();
            if (statementEventListeners.length > 0) {
                StatementEvent statementEvent = new StatementEvent(this, statement);
                for (StatementEventListener statementEventListener : statementEventListeners) {
                    statementEventListener.statementClosed(statementEvent);
                }
            }
        }

        private StatementEventListener[] getStatementEventListeners() {
            return this.statementEventListeners.toArray(new StatementEventListener[this.statementEventListeners.size()]);
        }
    }

    class ConnectionFactory
    implements ObjectFactory<ConnectionKey, Connection, ConnectionHelper> {
        private final String validationQuery;

        public ConnectionFactory(String validationQuery) {
            this.validationQuery = validationQuery;
        }

        @Override
        public Connection createObject(ConnectionKey connectionKey, ConnectionHelper connectionHelper) throws Exception {
            Connection connection = DataSource.this.connect(connectionKey, null);
            connectionHelper.setConnection(connection);
            if (DataSource.this.logger != null) {
                DataSource.this.logger.trace("Created " + connection);
            }
            return connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateObject(ConnectionKey connectionKey, Connection connection, ConnectionHelper connectionHelper) {
            if (DataSource.this.logger != null) {
                DataSource.this.logger.trace("Validate " + connection);
            }
            boolean result = true;
            if (this.validationQuery != null) {
                Statement statement = null;
                try {
                    ((RemConnection)connection).setSocketTimeout(10000);
                    statement = connection.createStatement();
                    statement.execute(this.validationQuery);
                    RemSQLUtils.close((RemStatement)statement);
                    connection.rollback();
                    result = true;
                }
                catch (SQLException exception) {
                    if (DataSource.this.logger.isWarnEnabled()) {
                        DataSource.this.logger.warn(connection + " failed validation query '" + this.validationQuery + "'", exception);
                    }
                    result = false;
                }
                finally {
                    ((RemConnection)connection).setSocketTimeout(0);
                }
            }
            if (DataSource.this.logger != null) {
                DataSource.this.logger.trace("Validation done " + connection);
            }
            return result;
        }

        @Override
        public void activateObject(ConnectionKey connectionKey, Connection connection, ConnectionHelper connectionHelper) throws Exception {
        }

        @Override
        public boolean passivateObject(ConnectionKey connectionKey, Connection connection, ConnectionHelper connectionHelper) {
            try {
                connectionHelper.returnOrCloseStatements();
                connection.rollback();
                return true;
            }
            catch (SQLException e) {
                if (DataSource.this.connectionPool.getLogger() != null) {
                    DataSource.this.connectionPool.getLogger().warn("Failed trying to passivate connection", e);
                }
                return false;
            }
        }

        @Override
        public void closeObject(ConnectionKey connectionKey, Connection connection, ConnectionHelper connectionHelper) {
            if (DataSource.this.logger != null) {
                DataSource.this.logger.trace("Close physical " + connection);
            }
            connectionHelper.closeConnection();
        }
    }

    class StatementFactory
    implements ObjectFactory<StatementKey, Statement, StatementHelper> {
        StatementFactory() {
        }

        @Override
        public Statement createObject(StatementKey statementKey, StatementHelper statementHelper) throws Exception {
            Statement statement = null;
            switch (statementKey.getStatementType()) {
                case STATEMENT: {
                    statement = this.createStatement(statementKey);
                    break;
                }
                case PREPARED_STATEMENT: {
                    statement = this.prepareStatement(statementKey);
                    break;
                }
                case CALLABLE_STATEMENT: {
                    statement = this.prepareCall(statementKey);
                }
            }
            return statement;
        }

        protected Statement createStatement(StatementKey statementKey) throws Exception {
            Connection connection = statementKey.getConnection();
            Integer resultSetType = statementKey.getResultSetType();
            Integer resultSetConcurrency = statementKey.getResultSetConcurrency();
            Integer resultSetHoldability = statementKey.getResultSetHoldability();
            Statement statement = resultSetType != null && resultSetConcurrency != null && resultSetHoldability != null ? connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability) : (resultSetType != null && resultSetConcurrency != null ? connection.createStatement(resultSetType, resultSetConcurrency) : connection.createStatement());
            return statement;
        }

        protected Statement prepareStatement(StatementKey statementKey) throws Exception {
            Connection connection = statementKey.getConnection();
            String sql = statementKey.getSql();
            Integer resultSetType = statementKey.getResultSetType();
            Integer resultSetConcurrency = statementKey.getResultSetConcurrency();
            Integer resultSetHoldability = statementKey.getResultSetHoldability();
            Integer autoGeneratedKeys = statementKey.getAutoGeneratedKeys();
            int[] columnIndexes = statementKey.getColumnIndexes();
            String[] columnNames = statementKey.getColumnNames();
            PreparedStatement statement = resultSetType != null && resultSetConcurrency != null && resultSetHoldability != null ? connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability) : (resultSetType != null && resultSetConcurrency != null ? connection.prepareStatement(sql, resultSetType, resultSetConcurrency) : (columnNames != null ? connection.prepareStatement(sql, columnNames) : (columnIndexes != null ? connection.prepareStatement(sql, columnIndexes) : (autoGeneratedKeys != null ? connection.prepareStatement(sql, autoGeneratedKeys) : connection.prepareStatement(sql)))));
            return statement;
        }

        protected Statement prepareCall(StatementKey statementKey) throws Exception {
            Connection connection = statementKey.getConnection();
            String sql = statementKey.getSql();
            Integer resultSetType = statementKey.getResultSetType();
            Integer resultSetConcurrency = statementKey.getResultSetConcurrency();
            Integer resultSetHoldability = statementKey.getResultSetHoldability();
            CallableStatement statement = resultSetType != null && resultSetConcurrency != null && resultSetHoldability != null ? connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability) : (resultSetType != null && resultSetConcurrency != null ? connection.prepareCall(sql, resultSetType, resultSetConcurrency) : connection.prepareCall(sql));
            return statement;
        }

        @Override
        public void activateObject(StatementKey statementKey, Statement statement, StatementHelper statementHelper) throws Exception {
        }

        @Override
        public boolean passivateObject(StatementKey statementKey, Statement statement, StatementHelper statementHelper) {
            statementHelper.closeResultSets(statement);
            return true;
        }

        @Override
        public boolean validateObject(StatementKey statementKey, Statement statement, StatementHelper statementHelper) {
            return true;
        }

        @Override
        public void closeObject(StatementKey statementKey, Statement statement, StatementHelper statementHelper) {
            block2: {
                try {
                    statementHelper.closeStatement(statement);
                }
                catch (Exception e) {
                    if (DataSource.this.connectionPool.getLogger() == null) break block2;
                    DataSource.this.connectionPool.getLogger().warn("Failure while cleaning up to close connection", e);
                }
            }
        }
    }

    static class StatementHelper {
        private ObjectPool<StatementKey, Statement, StatementHelper> statementPool;
        private Map<Statement, StatementHandle> statements = new HashMap<Statement, StatementHandle>();

        StatementHelper() {
        }

        public boolean isPoolable(StatementKey statementKey) {
            boolean poolable = false;
            if (this.statementPool != null) {
                switch (statementKey.getStatementType()) {
                    case PREPARED_STATEMENT: 
                    case CALLABLE_STATEMENT: {
                        poolable = true;
                    }
                }
            }
            return poolable;
        }

        public void addStatement(Statement statement, StatementHandle statementHandle) {
            this.statements.put(statement, statementHandle);
        }

        public void closeResultSets(Statement statement) {
            ((RemStatement)statement).closeResultSets();
        }

        public void returnOrCloseStatements() throws SQLException {
            Iterator<Map.Entry<Statement, StatementHandle>> iterator = this.statements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Statement, StatementHandle> entry = iterator.next();
                this.returnOrCloseStatement(entry.getValue(), entry.getKey());
                iterator.remove();
            }
        }

        public void returnOrCloseStatement(Statement statement) throws Exception {
            StatementHandle statementHandle = this.statements.remove(statement);
            if (statementHandle != null) {
                this.returnOrCloseStatement(statementHandle, statement);
            }
        }

        private void returnOrCloseStatement(StatementHandle statementHandle, Statement statement) throws SQLException {
            StatementKey statementKey = statementHandle.getStatementKey();
            if (statementHandle.isPoolable() && this.statementPool != null) {
                this.returnStatement(statementKey, statement);
            } else {
                this.closeStatement(statementKey, statement);
            }
        }

        private void returnStatement(StatementKey statementKey, Statement statement) throws SQLException {
            try {
                this.statementPool.returnObject(statementKey, statement, this);
            }
            catch (SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException(exception);
            }
            this.statementReturned(statement);
        }

        public void closeStatements() throws SQLException {
            Iterator<Map.Entry<Statement, StatementHandle>> iterator = this.statements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Statement, StatementHandle> entry = iterator.next();
                this.closeStatement(entry.getValue().getStatementKey(), entry.getKey());
                iterator.remove();
            }
        }

        public void closeStatement(Statement statement) throws SQLException {
            StatementHandle statementHandle = this.statements.remove(statement);
            if (statementHandle != null) {
                this.closeStatement(statementHandle.getStatementKey(), statement);
            }
        }

        private void closeStatement(StatementKey statementKey, Statement statement) throws SQLException {
            try {
                if (this.statementPool != null) {
                    this.statementPool.removeObject(statementKey, statement);
                }
            }
            catch (SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException(exception);
            }
            RemSQLUtils.close((RemStatement)statement);
            this.statementClosed(statement);
        }

        protected void statementReturned(Statement statement) {
        }

        protected void statementClosed(Statement statement) {
        }

        public ObjectPool<StatementKey, Statement, StatementHelper> getStatementPool() {
            return this.statementPool;
        }

        public void setStatementPool(ObjectPool<StatementKey, Statement, StatementHelper> statementPool) {
            this.statementPool = statementPool;
        }
    }

    static class ConnectionHelper {
        private Connection connection;
        private ConnectionKey connectionKey;
        private ObjectPool<ConnectionKey, Connection, ConnectionHelper> connectionPool;
        private StatementHelper statementHelper;

        ConnectionHelper() {
        }

        public void returnOrCloseStatements() throws SQLException {
            this.statementHelper.returnOrCloseStatements();
        }

        public void closeStatements() throws SQLException {
            this.statementHelper.closeStatements();
        }

        public void returnOrCloseConnection() throws SQLException {
            try {
                this.connectionPool.returnObject(this.connectionKey, this.connection, this);
            }
            catch (Exception exception) {
                throw new SQLException(exception);
            }
        }

        public void closeConnection() {
            block2: {
                ((RemConnection)this.connection).setSocketTimeout(10000);
                try {
                    this.closeStatements();
                }
                catch (SQLException e) {
                    if (this.connectionPool.getLogger() == null) break block2;
                    this.connectionPool.getLogger().warn("Failure while cleaning up to close connection", e);
                }
            }
            RemSQLUtils.close((RemConnection)this.connection);
        }

        public Connection getConnection() {
            return this.connection;
        }

        public void setConnection(Connection connection) {
            this.connection = connection;
        }

        public ConnectionKey getConnectionKey() {
            return this.connectionKey;
        }

        public void setConnectionKey(ConnectionKey connectionKey) {
            this.connectionKey = connectionKey;
        }

        public ObjectPool<ConnectionKey, Connection, ConnectionHelper> getConnectionPool() {
            return this.connectionPool;
        }

        public void setConnectionPool(ObjectPool<ConnectionKey, Connection, ConnectionHelper> connectionPool) {
            this.connectionPool = connectionPool;
        }

        public void setStatementHelper(StatementHelper statementHelper) {
            this.statementHelper = statementHelper;
        }

        public StatementHelper getStatementHelper() {
            return this.statementHelper;
        }
    }
}

