/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.D;
import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class SimpleScrollPane
extends JScrollPane
implements ChangeListener,
MouseWheelListener {
    private AbstractButton \u0109;
    private AbstractButton \u0102;
    private AbstractButton \u0105;
    private AbstractButton \u010a;
    private int \u0101 = 10;
    private boolean \u0107 = false;
    private int \u0108 = 10;
    private boolean \u0103 = false;
    private int \u0106 = 50;
    private boolean \u0104 = true;
    public static final String SCROLL_UP_BUTTON = "SCROLL_UP_BUTTON";
    public static final String SCROLL_DOWN_BUTTON = "SCROLL_DOWN_BUTTON";
    public static final String SCROLL_LEFT_BUTTON = "SCROLL_LEFT_BUTTON";
    public static final String SCROLL_RIGHT_BUTTON = "SCROLL_RIGHT_BUTTON";

    public SimpleScrollPane(Component component, int n2, int n3) {
        this.setLayout(new D.A());
        this.setVerticalScrollBarPolicy(n2);
        this.setHorizontalScrollBarPolicy(n3);
        this.setViewport(this.createViewport());
        this.setScrollUpButton(this.createScrollButton(1));
        this.setScrollDownButton(this.createScrollButton(5));
        this.setScrollLeftButton(this.createScrollButton(7));
        this.setScrollRightButton(this.createScrollButton(3));
        if (null != component) {
            this.setViewportView(component);
        }
        this.updateButtonState();
        this.setOpaque(true);
        this.setFocusable(false);
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setVisible(false);
            this.getHorizontalScrollBar().setFocusable(false);
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setVisible(false);
            this.getVerticalScrollBar().setFocusable(false);
        }
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
        if (this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
    }

    public SimpleScrollPane(Component component) {
        this(component, 20, 30);
    }

    public SimpleScrollPane(int n2, int n3) {
        this(null, n2, n3);
    }

    public SimpleScrollPane() {
        this(null, 20, 30);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setLayout(new D.A());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
        this.getViewport().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getViewport()) {
            this.updateButtonState();
        }
    }

    public AbstractButton getScrollUpButton() {
        return this.\u0109;
    }

    public void setScrollUpButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollUpButton();
        this.\u0109 = abstractButton;
        this.add((Component)this.\u0109, SCROLL_UP_BUTTON);
        this.firePropertyChange("scrollUpButton", abstractButton2, this.\u0109);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollDownButton() {
        return this.\u0102;
    }

    public void setScrollDownButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollDownButton();
        this.\u0102 = abstractButton;
        this.add((Component)this.\u0102, SCROLL_DOWN_BUTTON);
        this.firePropertyChange("scrollDownButton", abstractButton2, this.\u0102);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollLeftButton() {
        return this.\u0105;
    }

    public void setScrollLeftButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollLeftButton();
        this.\u0105 = abstractButton;
        this.add((Component)this.\u0105, SCROLL_LEFT_BUTTON);
        this.firePropertyChange("scrollLeftButton", abstractButton2, this.\u0105);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollRightButton() {
        return this.\u010a;
    }

    public void setScrollRightButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollRightButton();
        this.\u010a = abstractButton;
        this.add((Component)this.\u010a, SCROLL_RIGHT_BUTTON);
        this.firePropertyChange("scrollRightButton", abstractButton2, this.\u010a);
        this.revalidate();
        this.repaint();
    }

    protected AbstractButton createScrollButton(int n2) {
        return new ScrollButton(n2);
    }

    protected void updateButtonState() {
        Point point = this.viewport.getViewPosition();
        this.\u0109.setEnabled(point.y != 0);
        this.\u0102.setEnabled(point.y != this.viewport.getViewSize().height - this.viewport.getViewRect().height);
        this.\u0105.setEnabled(point.x != 0);
        this.\u010a.setEnabled(point.x != this.viewport.getViewSize().width - this.viewport.getViewRect().width);
        this.revalidate();
        this.repaint();
    }

    public void scroll(JViewport jViewport, int n2) {
        Point point = jViewport.getViewPosition();
        JViewport jViewport2 = this.getViewport();
        switch (n2) {
            case 1: {
                if (!this.\u0103 && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y -= scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                } else {
                    point.y -= this.getVerticalUnitIncrement();
                }
                if (point.y >= 0) break;
                point.y = 0;
                break;
            }
            case 5: {
                if (!this.\u0103 && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y += scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                } else {
                    point.y += this.getVerticalUnitIncrement();
                }
                if (point.y + jViewport.getViewRect().height <= jViewport.getViewSize().height) break;
                point.y = jViewport.getViewSize().height - jViewport.getViewRect().height;
                break;
            }
            case 7: {
                if (!this.\u0107 && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x -= scrollable.getScrollableUnitIncrement(rectangle, 0, -1);
                } else {
                    point.x -= this.getHorizontalUnitIncrement();
                }
                if (point.x >= 0) break;
                point.x = 0;
                break;
            }
            case 3: {
                if (!this.\u0107 && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x += scrollable.getScrollableUnitIncrement(rectangle, 0, 1);
                } else {
                    point.x += this.getHorizontalUnitIncrement();
                }
                if (point.x + jViewport.getViewRect().width <= jViewport.getViewSize().width) break;
                point.x = jViewport.getViewSize().width - jViewport.getViewRect().width;
            }
        }
        jViewport.setViewPosition(point);
    }

    @Override
    public Rectangle getViewportBorderBounds() {
        Rectangle rectangle = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this.\u0109 != null && this.\u0109.isVisible()) {
            rectangle.y += this.\u0109.getHeight();
            rectangle.height -= this.\u0109.getHeight();
        }
        if (this.\u0105 != null && this.\u0105.isVisible()) {
            rectangle.x += this.\u0105.getWidth();
            rectangle.width -= this.\u0105.getWidth();
        }
        if (this.\u0102 != null && this.\u0102.isVisible()) {
            rectangle.height -= this.\u0102.getHeight();
        }
        if (this.\u010a != null && this.\u010a.isVisible()) {
            rectangle.width -= this.\u010a.getWidth();
        }
        return rectangle;
    }

    public int getHorizontalUnitIncrement() {
        return this.\u0101;
    }

    public void setHorizontalUnitIncrement(int n2) {
        this.\u0107 = true;
        if (n2 != this.\u0101) {
            int n3 = this.\u0101;
            this.\u0101 = n2;
            this.firePropertyChange("horizontalUnitIncrement", n3, this.\u0101);
        }
    }

    public int getVerticalUnitIncrement() {
        return this.\u0108;
    }

    public void setVerticalUnitIncrement(int n2) {
        this.\u0103 = true;
        if (n2 != this.\u0108) {
            int n3 = this.\u0108;
            this.\u0108 = n2;
            this.firePropertyChange("verticalUnitIncrement", n3, this.\u0108);
        }
    }

    public boolean isScrollOnRollover() {
        return this.\u0104;
    }

    public void setScrollOnRollover(boolean bl) {
        if (this.\u0104 != bl) {
            boolean bl2 = this.\u0104;
            this.\u0104 = bl;
            this.firePropertyChange("scrollOnRollover", bl2, this.\u0104);
        }
    }

    public int getRepeatDelay() {
        return this.\u0106;
    }

    public void setRepeatDelay(int n2) {
        if (n2 != this.\u0106) {
            int n3 = this.\u0106;
            this.\u0106 = n2;
            this.firePropertyChange("repeatDelay", n3, this.\u0106);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
            boolean bl = mouseWheelEvent.getWheelRotation() >= 0;
            int n2 = 0;
            if (!this.\u0101(bl)) {
                return;
            }
            n2 = this.\u0102(bl);
            if (n2 != 0) {
                this.scroll(this.getViewport(), n2);
            }
        }
    }

    private boolean \u0101(boolean bl) {
        if (bl) {
            return this.\u0109 != null && this.\u0109.isVisible() || this.\u0105 != null && this.\u0105.isVisible();
        }
        return this.\u0102 != null && this.\u0102.isVisible() || this.\u010a != null && this.\u010a.isVisible();
    }

    private int \u0102(boolean bl) {
        if (bl) {
            if (this.\u0109 != null && this.\u0109.isVisible()) {
                return 5;
            }
            if (this.\u0105 != null && this.\u0105.isVisible()) {
                return 3;
            }
        } else {
            if (this.\u0102 != null && this.\u0102.isVisible()) {
                return 1;
            }
            if (this.\u010a != null && this.\u010a.isVisible()) {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public void setWheelScrollingEnabled(boolean bl) {
        if (bl && !this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
        if (!bl && this.isWheelScrollingEnabled()) {
            this.removeMouseWheelListener(this);
        }
        super.setWheelScrollingEnabled(bl);
    }

    public class ScrollButton
    extends JideButton
    implements MouseListener,
    ActionListener,
    UIResource {
        private int \u1ecb;
        private Timer \u1ecc;

        public ScrollButton(int n2) {
            this.\u1ecb = n2;
            switch (n2) {
                case 1: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_up.gif"));
                    break;
                }
                case 5: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
                    break;
                }
                case 7: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
                    break;
                }
                case 3: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
                }
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimpleScrollPane.this.scroll(SimpleScrollPane.this.getViewport(), this.\u1ecb);
            SimpleScrollPane.this.updateButtonState();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.\u0101(mouseEvent, 500);
            } else {
                this.\u0107(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.\u0392();
            } else {
                this.\u0107(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.\u0101(mouseEvent, 500);
            }
        }

        private void \u0107(MouseEvent mouseEvent) {
            if (this.\u1ecc != null) {
                this.\u1ecc.setDelay(this.\u0108(mouseEvent));
            }
        }

        private void \u0101(MouseEvent mouseEvent, int n2) {
            this.\u0392();
            this.\u1ecc = new Timer(this.\u0108(mouseEvent), this);
            this.\u1ecc.setInitialDelay(n2);
            this.\u1ecc.start();
        }

        private void \u0392() {
            if (this.\u1ecc != null) {
                this.\u1ecc.stop();
                this.\u1ecc = null;
            }
        }

        private int \u0108(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                return SwingUtilities.isLeftMouseButton(mouseEvent) ? SimpleScrollPane.this.getRepeatDelay() : SimpleScrollPane.this.getRepeatDelay() * 2;
            }
            return SimpleScrollPane.this.getRepeatDelay();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.\u0392();
            }
        }
    }
}

