/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.plaf.basic.ExComboBoxPopup;
import com.jidesoft.popup.JidePopup;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class AquaExComboBoxPopup
extends ExComboBoxPopup {
    static final Insets \u0106 = new Insets(5, 6, 5, 6);
    protected Component topStrut;
    protected Component bottomStrut;
    protected boolean isPopDown = false;

    public AquaExComboBoxPopup(JComboBox jComboBox) {
        super(jComboBox);
    }

    @Override
    protected void configurePopup() {
        super.configurePopup();
        this.setBorderPainted(false);
        this.setBorder(null);
        this.updateContents(false);
        this.putClientProperty("apple.awt._windowFadeOut", 150);
    }

    public void updateContents(boolean bl) {
        this.isPopDown = this.isPopdown();
        if (this.isPopDown) {
            if (bl) {
                if (this.topStrut != null) {
                    this.remove(this.topStrut);
                }
                if (this.bottomStrut != null) {
                    this.remove(this.bottomStrut);
                }
            } else {
                this.add(this.scroller);
            }
        } else {
            if (this.topStrut == null) {
                this.topStrut = Box.createVerticalStrut(4);
                this.bottomStrut = Box.createVerticalStrut(4);
            }
            if (bl) {
                this.remove(this.scroller);
            }
            this.add(this.topStrut);
            this.add(this.scroller);
            this.add(this.bottomStrut);
        }
    }

    protected Dimension getBestPopupSizeForRowCount(int n2) {
        int n3 = this.comboBox.getModel().getSize();
        if (n3 > 0) {
            int n4 = Math.min(n2, n3);
            Dimension dimension = new Dimension();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            for (int i2 = 0; i2 < n4; ++i2) {
                Object e2 = this.list.getModel().getElementAt(i2);
                Component component = listCellRenderer.getListCellRendererComponent(this.list, e2, i2, false, false);
                Dimension dimension2 = component.getPreferredSize();
                dimension.height += dimension2.height;
                dimension.width = Math.max(dimension2.width, dimension.width);
            }
            dimension.width += 10;
            return dimension;
        }
        return this._popupPanel.getActualPreferredSize();
    }

    protected boolean shouldScroll() {
        return this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount();
    }

    protected boolean isPopdown() {
        return this.shouldScroll() || AquaExComboBoxPopup.isPopdown(this.comboBox);
    }

    protected static boolean isPopdown(JComboBox jComboBox) {
        return jComboBox.isEditable() || Boolean.TRUE.equals(jComboBox.getClientProperty("JComboBox.isPopDown"));
    }

    @Override
    protected Point calculatePopupLocation() {
        if (this.isPopdown()) {
            Point point = super.calculatePopupLocation();
            point.y -= 4;
            point.x += 6;
            return point;
        }
        Rectangle rectangle = this.adjustPopupAndGetBounds();
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, this.comboBox);
        if (!this._comboBox.isStretchToFit()) {
            point.x += rectangle.width - this._popupPanel.getActualPreferredSize().width;
        }
        point.x -= 11;
        point.y += 4;
        return point;
    }

    @Override
    protected int getPreferredWidth() {
        return this.adjustPopupAndGetBounds().width;
    }

    @Override
    protected void customizePopup(JidePopup jidePopup) {
        super.customizePopup(jidePopup);
        jidePopup.putClientProperty("windowOpaque", null);
    }

    @Override
    protected void customizePopupPanel(PopupPanel popupPanel) {
        popupPanel.setBorder(BorderFactory.createEmptyBorder());
    }

    protected JList createList() {
        return new JList(){

            @Override
            public void ensureIndexIsVisible(int n2) {
                if (n2 != -1) {
                    super.ensureIndexIsVisible(n2);
                }
            }
        };
    }

    protected Rectangle adjustPopupAndGetBounds() {
        if (this.isPopDown != this.isPopdown()) {
            this.updateContents(true);
        }
        Dimension dimension = this.getBestPopupSizeForRowCount(this.comboBox.getMaximumRowCount());
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        if (rectangle == null) {
            return null;
        }
        Dimension dimension2 = rectangle.getSize();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        this.list.invalidate();
        int n2 = this.comboBox.getSelectedIndex();
        if (n2 == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n2);
        }
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        return rectangle;
    }

    Rectangle \u0101(Point point) {
        Rectangle rectangle;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        Rectangle rectangle2 = this.comboBox.getBounds();
        if (graphicsDeviceArray.length == 1) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + rectangle2.width < 0 || point.y + rectangle2.height < 0 || point.x > dimension.width || point.y > dimension.height) {
                return null;
            }
            return new Rectangle(0, 22, dimension.width, dimension.height - 22);
        }
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.contains(point)) continue;
                return rectangle;
            }
        }
        rectangle2.setLocation(point);
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                rectangle = graphicsConfiguration.getBounds();
                if (!rectangle.intersects(rectangle2)) continue;
                return rectangle;
            }
        }
        return null;
    }

    protected static boolean isTableCellEditor(JComponent jComponent) {
        return Boolean.TRUE.equals(jComponent.getClientProperty("JComboBox.isTableCellEditor"));
    }

    @Override
    protected Rectangle computePopupBounds(int n2, int n3, int n4, int n5) {
        boolean bl;
        int n6 = this.comboBox.getModel().getSize();
        boolean bl2 = this.isPopdown();
        boolean bl3 = AquaExComboBoxPopup.isTableCellEditor(this.comboBox);
        if (bl2 && !bl3) {
            n3 = Math.min(n3 / 2 + 9, n3);
        }
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.comboBox);
        Rectangle rectangle = this.\u0101(point);
        if (rectangle == null) {
            return super.computePopupBounds(n2, n3, n4, n5);
        }
        Insets insets = this.comboBox.getInsets();
        Rectangle rectangle2 = this.comboBox.getBounds();
        if (this.shouldScroll()) {
            n4 += 15;
        }
        if (bl2) {
            n4 += 4;
        }
        int n7 = rectangle2.width - (insets.left + insets.right);
        n4 = Math.max(n7, n4);
        boolean bl4 = bl = this.comboBox.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT;
        if (bl) {
            n2 += insets.left;
            if (!this.isPopDown) {
                n2 -= AquaExComboBoxPopup.\u0106.left;
            }
        } else {
            n2 = rectangle2.width - n4 - insets.right;
            if (!this.isPopDown) {
                n2 += AquaExComboBoxPopup.\u0106.right;
            }
        }
        point.x += n2;
        point.y += (n3 -= insets.bottom);
        if (point.x < rectangle.x) {
            n2 -= point.x + rectangle.x;
        }
        if (point.y < rectangle.y) {
            n3 -= point.y + rectangle.y;
        }
        Point point2 = new Point(0, 0);
        SwingUtilities.convertPointFromScreen(point2, this.comboBox);
        int n8 = Math.min(rectangle.width, point2.x + rectangle.x + rectangle.width) - 2;
        n4 = Math.min(n8, n4);
        if (n4 < n7) {
            n2 -= n7 - n4;
            n4 = n7;
        }
        if (!bl2) {
            return this.computePopupBoundsForMenu(n2, n3, n4 -= 6, n5, n6, rectangle);
        }
        if (!bl3) {
            n4 -= AquaExComboBoxPopup.\u0106.left + AquaExComboBoxPopup.\u0106.right;
            if (bl) {
                n2 += AquaExComboBoxPopup.\u0106.left;
            }
        }
        Rectangle rectangle3 = new Rectangle(n2, n3, n4, n5);
        if (rectangle3.y + rectangle3.height < point2.y + rectangle.y + rectangle.height) {
            return rectangle3;
        }
        return new Rectangle(n2, -rectangle3.height + insets.top, rectangle3.width, rectangle3.height);
    }

    protected Rectangle computePopupBoundsForMenu(int n2, int n3, int n4, int n5, int n6, Rectangle rectangle) {
        boolean bl;
        int n7;
        Rectangle rectangle2;
        int n8 = 0;
        if (this.list != null && n6 > 0 && (rectangle2 = this.list.getCellBounds(0, 0)) != null) {
            n8 = rectangle2.height;
        }
        if ((n7 = this.comboBox.getSelectedIndex()) < 0) {
            n7 = 0;
        }
        this.list.setSelectedIndex(n7);
        int n9 = this.list.getModel().getSize() > 0 ? n8 * n7 : 0;
        Point point = new Point(0, rectangle.y);
        Point point2 = new Point(0, rectangle.y + rectangle.height - 20);
        SwingUtilities.convertPointFromScreen(point, this.comboBox);
        SwingUtilities.convertPointFromScreen(point2, this.comboBox);
        Rectangle rectangle3 = new Rectangle(n2, n3, n4, n5);
        int n10 = n5 - n9;
        boolean bl2 = n9 > -point.y;
        boolean bl3 = bl = n10 > point2.y;
        if (bl2) {
            rectangle3.y = point.y + 1;
            rectangle3.y = rectangle3.y / n8 * n8;
        } else {
            rectangle3.y = bl ? point2.y - rectangle3.height : -n9;
        }
        int n11 = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int n12 = n11 - (insets.top + insets.bottom);
        int n13 = (n12 - n8) / 2 + insets.top;
        rectangle3.y += n13 - AquaExComboBoxPopup.\u0106.bottom;
        return rectangle3;
    }
}

