/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.shadow.com.formdev.flatlaf.icons;

import com.install4j.shadow.com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.install4j.shadow.com.formdev.flatlaf.ui.FlatButtonUI;
import com.install4j.shadow.com.formdev.flatlaf.ui.FlatStylingSupport;
import com.install4j.shadow.com.formdev.flatlaf.ui.FlatUIUtils;
import com.install4j.shadow.com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.Map;
import javax.swing.UIManager;

public class FlatHelpButtonIcon
extends FlatAbstractIcon {
    @FlatStylingSupport.Styleable
    protected int focusWidth = UIManager.getInt("Component.focusWidth");
    @FlatStylingSupport.Styleable
    protected Color focusColor = UIManager.getColor("Component.focusColor");
    @FlatStylingSupport.Styleable
    protected float innerFocusWidth = FlatUIUtils.getUIFloat("HelpButton.innerFocusWidth", FlatUIUtils.getUIFloat("Component.innerFocusWidth", 0.0f));
    @FlatStylingSupport.Styleable
    protected int borderWidth = FlatUIUtils.getUIInt("HelpButton.borderWidth", 1);
    @FlatStylingSupport.Styleable
    protected Color borderColor = UIManager.getColor("HelpButton.borderColor");
    @FlatStylingSupport.Styleable
    protected Color disabledBorderColor = UIManager.getColor("HelpButton.disabledBorderColor");
    @FlatStylingSupport.Styleable
    protected Color focusedBorderColor = UIManager.getColor("HelpButton.focusedBorderColor");
    @FlatStylingSupport.Styleable
    protected Color hoverBorderColor = UIManager.getColor("HelpButton.hoverBorderColor");
    @FlatStylingSupport.Styleable
    protected Color background = UIManager.getColor("HelpButton.background");
    @FlatStylingSupport.Styleable
    protected Color disabledBackground = UIManager.getColor("HelpButton.disabledBackground");
    @FlatStylingSupport.Styleable
    protected Color focusedBackground = UIManager.getColor("HelpButton.focusedBackground");
    @FlatStylingSupport.Styleable
    protected Color hoverBackground = UIManager.getColor("HelpButton.hoverBackground");
    @FlatStylingSupport.Styleable
    protected Color pressedBackground = UIManager.getColor("HelpButton.pressedBackground");
    @FlatStylingSupport.Styleable
    protected Color questionMarkColor = UIManager.getColor("HelpButton.questionMarkColor");
    @FlatStylingSupport.Styleable
    protected Color disabledQuestionMarkColor = UIManager.getColor("HelpButton.disabledQuestionMarkColor");

    public FlatHelpButtonIcon() {
        super(0, 0, null);
    }

    public Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
    }

    public Map<String, Class<?>> getStyleableInfos() {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    protected void paintIcon(Component c, Graphics2D g2) {
        boolean enabled = c.isEnabled();
        boolean focused = FlatUIUtils.isPermanentFocusOwner(c);
        float xy = 0.5f;
        float wh = this.iconSize() - 1;
        if (focused && FlatButtonUI.isFocusPainted(c)) {
            g2.setColor(this.focusColor);
            g2.fill(new Ellipse2D.Float(xy, xy, wh, wh));
        }
        g2.setColor(FlatButtonUI.buttonStateColor(c, this.borderColor, this.disabledBorderColor, this.focusedBorderColor, this.hoverBorderColor, null));
        g2.fill(new Ellipse2D.Float(xy += (float)this.focusWidth, xy, wh -= (float)(this.focusWidth * 2), wh));
        xy += (float)this.borderWidth;
        wh -= (float)(this.borderWidth * 2);
        if (this.innerFocusWidth > 0.0f && focused && FlatButtonUI.isFocusPainted(c)) {
            g2.setColor(this.focusColor);
            g2.fill(new Ellipse2D.Float(xy, xy, wh, wh));
            xy += this.innerFocusWidth;
            wh -= this.innerFocusWidth * 2.0f;
        }
        g2.setColor(FlatUIUtils.deriveColor(FlatButtonUI.buttonStateColor(c, this.background, this.disabledBackground, this.focusedBackground, this.hoverBackground, this.pressedBackground), this.background));
        g2.fill(new Ellipse2D.Float(xy, xy, wh, wh));
        Path2D.Float q = new Path2D.Float();
        ((Path2D)q).moveTo(11.0, 5.0);
        ((Path2D)q).curveTo(8.8, 5.0, 7.0, 6.8, 7.0, 9.0);
        ((Path2D)q).lineTo(9.0, 9.0);
        ((Path2D)q).curveTo(9.0, 7.9, 9.9, 7.0, 11.0, 7.0);
        ((Path2D)q).curveTo(12.1, 7.0, 13.0, 7.9, 13.0, 9.0);
        ((Path2D)q).curveTo(13.0, 11.0, 10.0, 10.75, 10.0, 14.0);
        ((Path2D)q).lineTo(12.0, 14.0);
        ((Path2D)q).curveTo(12.0, 11.75, 15.0, 11.5, 15.0, 9.0);
        ((Path2D)q).curveTo(15.0, 6.8, 13.2, 5.0, 11.0, 5.0);
        q.closePath();
        g2.translate(this.focusWidth, this.focusWidth);
        g2.setColor(enabled ? this.questionMarkColor : this.disabledQuestionMarkColor);
        g2.fill(q);
        g2.fillRect(10, 15, 2, 2);
    }

    @Override
    public int getIconWidth() {
        return UIScale.scale(this.iconSize());
    }

    @Override
    public int getIconHeight() {
        return UIScale.scale(this.iconSize());
    }

    private int iconSize() {
        return 22 + this.focusWidth * 2;
    }
}

