/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import java.util.regex.Pattern;

public final class TextUtil {
    private static char[] extracFirstWordPatternInstructions = new char[]{'|', '\u0000', ']', '^', '\u0000', '\u0003', '|', '\u0000', '\f', '\\', 's', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '(', '\u0001', '\u0003', '|', '\u0000', '\u0012', '\\', 'w', '\u0003', '|', '\u0000', '\u0006', 'G', '\u0000', '\ufffa', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0001', '\u0003', '\\', 's', '\u0003', '|', '\u0000', '\u0006', 'G', '\u0000', '\ufffa', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '(', '\u0002', '\u0003', '|', '\u0000', '\u0015', '|', '\u0000', '\f', '.', '\u0000', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0002', '\u0003', '$', '\u0000', '\u0003', 'E', '\u0000', '\u0000'};
    private static char[] trimPatternInstructions = new char[]{'|', '\u0000', '?', '^', '\u0000', '\u0003', '|', '\u0000', '\f', '\\', 's', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '(', '\u0001', '\u0003', '|', '\u0000', '\f', '8', '\u0000', '\t', '.', '\u0000', '\u0003', 'E', '\u0000', '\u0000', ')', '\u0001', '\u0003', '|', '\u0000', '\f', '\\', 's', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '$', '\u0000', '\u0003', 'E', '\u0000', '\u0000'};
    private static char[] stripQuotesPatternInstructions = new char[]{'|', '\u0000', ',', '^', '\u0000', '\u0003', 'A', '\u0001', '\u0004', '\"', '(', '\u0001', '\u0003', '|', '\u0000', '\u0015', '|', '\u0000', '\f', '.', '\u0000', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0001', '\u0003', 'A', '\u0001', '\u0004', '\"', '$', '\u0000', '\u0003', 'E', '\u0000', '\u0000'};
    public static final int NORMAL = 0;
    public static final int MULTILINECOMMENT = 1;
    public static final int COMMENT = 2;
    public static final int SINGLEQUOTE = 3;
    public static final int DOUBLEQUOTE = 4;

    public static String[] split(String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        return pattern.split(string2, 0);
    }

    public static final String stripQuotes(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return string.substring(1, string.length() - 2);
        }
        return string;
    }

    public static synchronized String removeAllSQLComments(String string) {
        String[] stringArray = TextUtil.tokenize(string);
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string2 = string2 + " ";
        }
        return string2;
    }

    public static synchronized String[] getSQLandComments(String string) {
        String[] stringArray = TextUtil.tokenizeSqlAndComments(string);
        String[] stringArray2 = new String[]{"", ""};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("/*") || stringArray[i].startsWith("*/") || stringArray[i].startsWith("--")) {
                String string2 = stringArray[i];
                if (string2.startsWith("--") && string2.length() >= 2) {
                    if (string2.length() > 2) {
                        string2 = stringArray[i].substring(2, string2.length() - 1);
                    } else if (string2.length() == 2) {
                        string2 = "";
                    }
                    string2 = "/*" + string2 + "*/";
                }
                stringArray2[0] = stringArray2[0] + string2;
                continue;
            }
            stringArray2[1] = stringArray2[1] + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            stringArray2[1] = stringArray2[1] + " ";
        }
        return stringArray2;
    }

    public static String[] tokenizeSqlAndComments(String string) {
        String[] stringArray = new String[]{};
        char[] cArray = string.toCharArray();
        IndexOfResult indexOfResult = IndexOfResult.getIndex(0, 0);
        IndexOfResult indexOfResult2 = IndexOfResult.getIndex(0, 0);
        while (indexOfResult2.index != -1) {
            indexOfResult = TextUtil.firstNotWhiteSpaceC(string, indexOfResult2.index);
            if (indexOfResult.index == -1) break;
            indexOfResult2 = TextUtil.firstWhiteSpaceC(string, indexOfResult.index, string.length() - indexOfResult.index, indexOfResult.state);
            int n = indexOfResult2.index;
            if (n == -1) {
                n = cArray.length;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = new String(cArray, indexOfResult.index, n - indexOfResult.index);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static String[] tokenize(String string) {
        String[] stringArray = new String[]{};
        char[] cArray = string.toCharArray();
        IndexOfResult indexOfResult = IndexOfResult.getIndex(0, 0);
        IndexOfResult indexOfResult2 = IndexOfResult.getIndex(0, 0);
        while (indexOfResult2.index != -1) {
            indexOfResult = TextUtil.firstNotWhiteSpace(string, indexOfResult2.index);
            if (indexOfResult.index == -1) break;
            indexOfResult2 = TextUtil.firstWhiteSpace(string, indexOfResult.index);
            int n = indexOfResult2.index;
            if (n == -1) {
                n = cArray.length;
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = new String(cArray, indexOfResult.index, n - indexOfResult.index);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static IndexOfResult firstWhiteSpaceC(String string, int n) {
        return TextUtil.firstWhiteSpaceC(string, n, string.length() - n);
    }

    public static IndexOfResult firstWhiteSpaceC(String string, int n, int n2) {
        return TextUtil.firstWhiteSpaceC(string, n, n2, 0);
    }

    public static IndexOfResult firstWhiteSpaceC(String string, int n, int n2, int n3) {
        char c;
        if (string == null) {
            return IndexOfResult.getMinusOne(n3);
        }
        int n4 = n + n2;
        if (n2 == 0) {
            return IndexOfResult.getMinusOne(n3);
        }
        char c2 = c = string.charAt(n);
        block6: for (int i = n; i < n4; ++i) {
            boolean bl;
            c = c2;
            boolean bl2 = bl = i == n4 - 1;
            if (!bl) {
                c2 = string.charAt(i + 1);
            }
            switch (n3) {
                case 0: {
                    if (c == '\'' || c == '\"') {
                        if (c == '\'') {
                            n3 = 3;
                            continue block6;
                        }
                        n3 = 4;
                        continue block6;
                    }
                    if (Character.isWhitespace(c)) {
                        return IndexOfResult.getIndex(i, n3);
                    }
                    if (bl || (c != '-' || c2 != '-') && (c != '/' || c2 != '*')) continue block6;
                    return IndexOfResult.getIndex(i, n3);
                }
                case 3: 
                case 4: {
                    if ((n3 != 3 || c != '\'') && (n3 != 4 || c != '\"')) continue block6;
                    n3 = 0;
                    continue block6;
                }
                case 1: {
                    if (bl || c != '*' || c2 != '/') continue block6;
                    return IndexOfResult.getIndex(i + 2, 0);
                }
                case 2: {
                    if (c != '\r' && c != '\n' && c != '\f') continue block6;
                    return IndexOfResult.getIndex(i, 0);
                }
            }
        }
        return IndexOfResult.getMinusOne(n3);
    }

    public static IndexOfResult firstNotWhiteSpaceC(String string, int n) {
        return TextUtil.firstNotWhiteSpaceC(string, n, string.length() - n, 0);
    }

    public static IndexOfResult firstNotWhiteSpaceC(String string, int n, int n2) {
        return TextUtil.firstNotWhiteSpaceC(string, n, n2, 0);
    }

    public static IndexOfResult firstNotWhiteSpaceC(String string, int n, int n2, int n3) {
        return TextUtil.firstNotWhiteSpaceC(null, string, n, n2, n3);
    }

    public static IndexOfResult firstNotWhiteSpaceC(char[] cArray, int n, int n2, int n3) {
        return TextUtil.firstNotWhiteSpaceC(cArray, null, n, n2, n3);
    }

    public static IndexOfResult firstNotWhiteSpaceC(char[] cArray, String string, int n, int n2, int n3) {
        if (n2 == 0) {
            return IndexOfResult.MINUS_ONE_STATE_NORMAL;
        }
        int n4 = n + n2;
        char c = cArray != null ? cArray[n] : string.charAt(n);
        char c2 = c;
        for (int i = n; i < n4; ++i) {
            boolean bl;
            c = c2;
            boolean bl2 = bl = i == n4 - 1;
            if (!bl) {
                c2 = cArray != null ? cArray[i + 1] : string.charAt(i + 1);
            }
            if (bl) {
                if (Character.isWhitespace(c)) continue;
                return IndexOfResult.getIndex(i, 0);
            }
            if (c == '-' && c2 == '-' || c == '/' && c2 == '*') {
                if (c == '-') {
                    return IndexOfResult.getIndex(i, 2);
                }
                return IndexOfResult.getIndex(i, 1);
            }
            if (Character.isWhitespace(c)) continue;
            return IndexOfResult.getIndex(i, 0);
        }
        return IndexOfResult.getMinusOne(n3);
    }

    public static IndexOfResult firstWhiteSpace(String string, int n) {
        return TextUtil.firstWhiteSpace(string, n, string.length() - n);
    }

    public static IndexOfResult firstWhiteSpace(String string, int n, int n2) {
        return TextUtil.firstWhiteSpace(string, n, n2, 0);
    }

    public static IndexOfResult firstWhiteSpace(String string, int n, int n2, int n3) {
        char c;
        if (string == null) {
            return IndexOfResult.getMinusOne(n3);
        }
        int n4 = n + n2;
        if (n2 == 0) {
            return IndexOfResult.getMinusOne(n3);
        }
        char c2 = c = string.charAt(n);
        block6: for (int i = n; i < n4; ++i) {
            boolean bl;
            c = c2;
            boolean bl2 = bl = i == n4 - 1;
            if (!bl) {
                c2 = string.charAt(i + 1);
            }
            switch (n3) {
                case 0: {
                    if (c == '\'' || c == '\"') {
                        if (c == '\'') {
                            n3 = 3;
                            continue block6;
                        }
                        n3 = 4;
                        continue block6;
                    }
                    if (Character.isWhitespace(c)) {
                        return IndexOfResult.getIndex(i, n3);
                    }
                    if (bl || (c != '-' || c2 != '-') && (c != '/' || c2 != '*')) continue block6;
                    return IndexOfResult.getIndex(i, n3);
                }
                case 3: 
                case 4: {
                    if ((n3 != 3 || c != '\'') && (n3 != 4 || c != '\"')) continue block6;
                    n3 = 0;
                    continue block6;
                }
                case 1: {
                    if (bl || c != '*' || c2 != '/') continue block6;
                    n3 = 0;
                    if (++i >= n4 - 1) continue block6;
                    c2 = string.charAt(i + 1);
                    continue block6;
                }
                case 2: {
                    if (c != '\r' && c != '\n' && c != '\f') continue block6;
                    n3 = 0;
                    if (bl || c != '\r' || c2 != '\n' || ++i >= n4 - 1) continue block6;
                    c2 = string.charAt(i + 1);
                    continue block6;
                }
            }
        }
        return IndexOfResult.getMinusOne(n3);
    }

    public static IndexOfResult firstNotWhiteSpace(String string, int n) {
        return TextUtil.firstNotWhiteSpace(string, n, string.length() - n, 0);
    }

    public static IndexOfResult firstNotWhiteSpace(String string, int n, int n2) {
        return TextUtil.firstNotWhiteSpace(string, n, n2, 0);
    }

    public static IndexOfResult firstNotWhiteSpace(String string, int n, int n2, int n3) {
        return TextUtil.firstNotWhiteSpace(null, string, n, n2, n3);
    }

    public static IndexOfResult firstNotWhiteSpace(char[] cArray, int n, int n2, int n3) {
        return TextUtil.firstNotWhiteSpace(cArray, null, n, n2, n3);
    }

    public static IndexOfResult firstNotWhiteSpace(char[] cArray, String string, int n, int n2, int n3) {
        if (n2 == 0) {
            return IndexOfResult.MINUS_ONE_STATE_NORMAL;
        }
        int n4 = n + n2;
        char c = cArray != null ? cArray[n] : string.charAt(n);
        char c2 = c;
        block5: for (int i = n; i < n4; ++i) {
            boolean bl;
            c = c2;
            boolean bl2 = bl = i == n4 - 1;
            if (!bl) {
                c2 = cArray != null ? cArray[i + 1] : string.charAt(i + 1);
            }
            switch (n3) {
                case 0: {
                    if (bl) {
                        if (Character.isWhitespace(c)) continue block5;
                        return IndexOfResult.getIndex(i, 0);
                    }
                    if (c == '-' && c2 == '-' || c == '/' && c2 == '*') {
                        n3 = c == '-' ? 2 : 1;
                        if (++i >= n4 - 1) continue block5;
                        if (cArray != null) {
                            c2 = cArray[i + 1];
                            continue block5;
                        }
                        c2 = string.charAt(i + 1);
                        continue block5;
                    }
                    if (Character.isWhitespace(c)) continue block5;
                    return IndexOfResult.getIndex(i, 0);
                }
                case 1: {
                    if (bl || c != '*' || c2 != '/') continue block5;
                    n3 = 0;
                    if (++i >= n4 - 1) continue block5;
                    if (cArray != null) {
                        c2 = cArray[i + 1];
                        continue block5;
                    }
                    c2 = string.charAt(i + 1);
                    continue block5;
                }
                case 2: {
                    if (c != '\r' && c != '\n' && c != '\f') continue block5;
                    n3 = 0;
                    if (bl || c != '\r' || c2 != '\n' || ++i >= n4 - 1) continue block5;
                    if (cArray != null) {
                        c2 = cArray[i + 1];
                        continue block5;
                    }
                    c2 = string.charAt(i + 1);
                    continue block5;
                }
            }
        }
        return IndexOfResult.getMinusOne(n3);
    }

    public static class IndexOfResult {
        public static final IndexOfResult MINUS_ONE_STATE_NORMAL = new IndexOfResult(-1, 0);
        public static final IndexOfResult MINUS_ONE_STATE_MULTILINECOMMENT = new IndexOfResult(-1, 1);
        public static final IndexOfResult MINUS_ONE_STATE_COMMENT = new IndexOfResult(-1, 2);
        public static final IndexOfResult MINUS_ONE_STATE_SINGLEQUOTE = new IndexOfResult(-1, 3);
        public static final IndexOfResult MINUS_ONE_STATE_DOUBLEQUOTE = new IndexOfResult(-1, 4);
        int index;
        int state;

        public IndexOfResult(int n, int n2) {
            this.index = n;
            this.state = n2;
        }

        public int getIndex() {
            return this.index;
        }

        public int getState() {
            return this.state;
        }

        public static IndexOfResult getMinusOne(int n) {
            switch (n) {
                case 0: {
                    return MINUS_ONE_STATE_NORMAL;
                }
                case 1: {
                    return MINUS_ONE_STATE_MULTILINECOMMENT;
                }
                case 2: {
                    return MINUS_ONE_STATE_COMMENT;
                }
                case 3: {
                    return MINUS_ONE_STATE_SINGLEQUOTE;
                }
                case 4: {
                    return MINUS_ONE_STATE_DOUBLEQUOTE;
                }
            }
            return new IndexOfResult(-1, n);
        }

        public static IndexOfResult getIndex(int n, int n2) {
            return new IndexOfResult(n, n2);
        }

        public String toString() {
            switch (this.state) {
                case 0: {
                    return this.index + " MINUS_ONE_STATE_NORMAL";
                }
                case 1: {
                    return this.index + " MINUS_ONE_STATE_MULTILINECOMMENT";
                }
                case 2: {
                    return this.index + " MINUS_ONE_STATE_COMMENT";
                }
                case 3: {
                    return this.index + " MINUS_ONE_STATE_SINGLEQUOTE";
                }
                case 4: {
                    return this.index + " MINUS_ONE_STATE_DOUBLEQUOTE";
                }
            }
            return this.index + " ERROR";
        }
    }
}

