/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parametersoutput;

import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.IStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class CharacterParameterDataStream
extends InputStreamReader
implements IStream {
    public CharacterParameterDataStream(byte[] parameterData) throws UnsupportedEncodingException {
        super((InputStream)new ByteArrayInputStream(parameterData), "UTF-16");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (null == cbuf) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_BUFFER.name());
        }
        if (0 > off || cbuf.length < off) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_OFFSET.name(), new String[]{String.valueOf(off), String.valueOf(cbuf.length)});
        }
        int numCharsRead = 0;
        int numCharsAvailable = cbuf.length - off;
        for (numCharsRead = 0; numCharsRead < numCharsAvailable && numCharsRead < len; ++numCharsRead) {
            int value = super.read();
            if (-1 == value) {
                return -1;
            }
            cbuf[numCharsRead + off] = (char)value;
        }
        return numCharsRead;
    }
}

