/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.utilities;

import com.vertica.dsi.CppClassWrapper;
import com.vertica.support.IMessageSource;
import com.vertica.support.IWarningListener;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CPPWarningListenerWrapper
extends CppClassWrapper
implements IWarningListener {
    private final Object m_lockObj = new Object();
    private boolean m_isValid = true;

    public CPPWarningListenerWrapper(long objRef) throws ErrorException {
        super(objRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale getLocale() {
        Object object = this.m_lockObj;
        synchronized (object) {
            this.checkValid();
            return CPPWarningListenerWrapper.getLocaleImpl(this.getObjRef());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMessageSource getMessageSource() {
        Object object = this.m_lockObj;
        synchronized (object) {
            this.checkValid();
            return CPPWarningListenerWrapper.getMessageSourceImpl(this.getObjRef());
        }
    }

    @Override
    public List<Warning> getWarnings() {
        assert (this.m_isValid);
        return new ArrayList<Warning>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postWarning(Warning warning) {
        Object object = this.m_lockObj;
        synchronized (object) {
            this.checkValid();
            CPPWarningListenerWrapper.postWarningImpl(this.getObjRef(), warning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocale(Locale locale) {
        Object object = this.m_lockObj;
        synchronized (object) {
            this.checkValid();
            CPPWarningListenerWrapper.setLocaleImpl(this.getObjRef(), locale);
        }
    }

    private void checkValid() throws IllegalStateException {
        if (!this.m_isValid) {
            assert (false) : "Object used after release().";
            throw new IllegalStateException("Object used after release().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Object object = this.m_lockObj;
        synchronized (object) {
            assert (this.m_isValid) : "release() called more than once.";
            if (this.m_isValid) {
                CPPWarningListenerWrapper.destruct(this.getObjRef());
                this.m_isValid = false;
            }
        }
    }

    private static final native void postWarningImpl(long var0, Warning var2);

    private static final native void setLocaleImpl(long var0, Locale var2);

    private static final native Locale getLocaleImpl(long var0);

    private static final native IMessageSource getMessageSourceImpl(long var0);

    private static final native void destruct(long var0);
}

