/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import org.apache.batik.css.dom.CSSOMSVGColor;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPaint;

public class CSSOMSVGPaint
extends CSSOMSVGColor
implements SVGPaint {
    public CSSOMSVGPaint(CSSOMSVGColor.ValueProvider valueProvider) {
        super(valueProvider);
    }

    @Override
    public void setModificationHandler(CSSOMSVGColor.ModificationHandler modificationHandler) {
        if (!(modificationHandler instanceof PaintModificationHandler)) {
            throw new IllegalArgumentException();
        }
        super.setModificationHandler(modificationHandler);
    }

    @Override
    public short getColorType() {
        throw new DOMException(15, "");
    }

    @Override
    public short getPaintType() {
        Value value = this.valueProvider.getValue();
        switch (value.getCssValueType()) {
            case 1: {
                switch (value.getPrimitiveType()) {
                    case 21: {
                        String string = value.getStringValue();
                        if (string.equalsIgnoreCase("none")) {
                            return 101;
                        }
                        if (string.equalsIgnoreCase("currentcolor")) {
                            return 102;
                        }
                        return 1;
                    }
                    case 25: {
                        return 1;
                    }
                    case 20: {
                        return 107;
                    }
                }
                break;
            }
            case 2: {
                Value value2 = value.item(0);
                Value value3 = value.item(1);
                switch (value2.getPrimitiveType()) {
                    case 21: {
                        return 2;
                    }
                    case 20: {
                        if (value3.getCssValueType() == 2) {
                            return 106;
                        }
                        switch (value3.getPrimitiveType()) {
                            case 21: {
                                String string = value3.getStringValue();
                                if (string.equalsIgnoreCase("none")) {
                                    return 103;
                                }
                                if (string.equalsIgnoreCase("currentcolor")) {
                                    return 104;
                                }
                                return 105;
                            }
                            case 25: {
                                return 105;
                            }
                        }
                    }
                    case 25: {
                        return 2;
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public String getUri() {
        switch (this.getPaintType()) {
            case 107: {
                return this.valueProvider.getValue().getStringValue();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                return this.valueProvider.getValue().item(0).getStringValue();
            }
        }
        throw new InternalError();
    }

    @Override
    public void setUri(String string) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).uriChanged(string);
    }

    @Override
    public void setPaint(short s, String string, String string2, String string3) {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        ((PaintModificationHandler)this.handler).paintChanged(s, string, string2, string3);
    }

    public abstract class AbstractModificationHandler
    implements PaintModificationHandler {
        protected abstract Value getValue();

        @Override
        public void redTextChanged(String string) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string = "rgb(" + string + ", " + this.getValue().getGreen().getCssText() + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string = "rgb(" + string + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0) + " rgb(" + string + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string = this.getValue().item(0) + " rgb(" + string + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void redFloatValueChanged(short s, float f) throws DOMException {
            String string;
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string = "rgb(" + FloatValue.getCssText(s, f) + ", " + this.getValue().getGreen().getCssText() + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string = "rgb(" + FloatValue.getCssText(s, f) + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0) + " rgb(" + FloatValue.getCssText(s, f) + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string = this.getValue().item(0) + " rgb(" + FloatValue.getCssText(s, f) + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void greenTextChanged(String string) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string = "rgb(" + this.getValue().getRed().getCssText() + ", " + string + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + string + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + string + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + string + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void greenFloatValueChanged(short s, float f) throws DOMException {
            String string;
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string = "rgb(" + this.getValue().getRed().getCssText() + ", " + FloatValue.getCssText(s, f) + ", " + this.getValue().getBlue().getCssText() + ')';
                    break;
                }
                case 2: {
                    string = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + FloatValue.getCssText(s, f) + ", " + this.getValue().item(0).getBlue().getCssText() + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + FloatValue.getCssText(s, f) + ", " + this.getValue().item(1).getBlue().getCssText() + ')';
                    break;
                }
                case 106: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + FloatValue.getCssText(s, f) + ", " + this.getValue().item(1).getBlue().getCssText() + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void blueTextChanged(String string) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string = "rgb(" + this.getValue().getRed().getCssText() + ", " + this.getValue().getGreen().getCssText() + ", " + string + ')';
                    break;
                }
                case 2: {
                    string = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + string + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + string + ")";
                    break;
                }
                case 106: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + string + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void blueFloatValueChanged(short s, float f) throws DOMException {
            String string;
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    string = "rgb(" + this.getValue().getRed().getCssText() + ", " + this.getValue().getGreen().getCssText() + ", " + FloatValue.getCssText(s, f) + ')';
                    break;
                }
                case 2: {
                    string = "rgb(" + this.getValue().item(0).getRed().getCssText() + ", " + this.getValue().item(0).getGreen().getCssText() + ", " + FloatValue.getCssText(s, f) + ") " + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + FloatValue.getCssText(s, f) + ')';
                    break;
                }
                case 106: {
                    string = this.getValue().item(0) + " rgb(" + this.getValue().item(1).getRed().getCssText() + ", " + this.getValue().item(1).getGreen().getCssText() + ", " + FloatValue.getCssText(s, f) + ") " + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void rgbColorChanged(String string) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 1: {
                    break;
                }
                case 2: {
                    string = string + this.getValue().item(1).getCssText();
                    break;
                }
                case 105: {
                    string = this.getValue().item(0).getCssText() + ' ' + string;
                    break;
                }
                case 106: {
                    string = this.getValue().item(0).getCssText() + ' ' + string + ' ' + this.getValue().item(2).getCssText();
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
            this.textChanged(string);
        }

        @Override
        public void rgbColorICCColorChanged(String string, String string2) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    this.textChanged(string + ' ' + string2);
                    break;
                }
                case 106: {
                    this.textChanged(this.getValue().item(0).getCssText() + ' ' + string + ' ' + string2);
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorChanged(short s, String string, String string2) throws DOMException {
            switch (s) {
                case 102: {
                    this.textChanged("currentcolor");
                    break;
                }
                case 1: {
                    this.textChanged(string);
                    break;
                }
                case 2: {
                    this.textChanged(string + ' ' + string2);
                    break;
                }
                default: {
                    throw new DOMException(9, "");
                }
            }
        }

        @Override
        public void colorProfileChanged(String string) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    stringBuffer.append(string);
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    for (int i = 0; i < iCCColor.getLength(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    stringBuffer.append(string);
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    for (int i = 0; i < iCCColor.getLength(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorsCleared() throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorsInitialized(float f) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorInsertedBefore(float f, int n) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    for (n2 = n; n2 < iCCColor.getLength(); ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    int n3;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n3 = 0; n3 < n; ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    for (n3 = n; n3 < iCCColor.getLength(); ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorReplaced(float f, int n) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    for (n2 = n + 1; n2 < iCCColor.getLength(); ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    int n3;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n3 = 0; n3 < n; ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    for (n3 = n + 1; n3 < iCCColor.getLength(); ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorRemoved(int n) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    for (n2 = n + 1; n2 < iCCColor.getLength(); ++n2) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n2));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    int n3;
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (n3 = 0; n3 < n; ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    for (n3 = n + 1; n3 < iCCColor.getLength(); ++n3) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(n3));
                    }
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void colorAppend(float f) throws DOMException {
            switch (CSSOMSVGPaint.this.getPaintType()) {
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (int i = 0; i < iCCColor.getLength(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                case 106: {
                    StringBuffer stringBuffer = new StringBuffer(this.getValue().item(0).getCssText());
                    stringBuffer.append(' ');
                    stringBuffer.append(this.getValue().item(1).getCssText());
                    stringBuffer.append(" icc-color(");
                    ICCColor iCCColor = (ICCColor)this.getValue().item(1);
                    stringBuffer.append(iCCColor.getColorProfile());
                    for (int i = 0; i < iCCColor.getLength(); ++i) {
                        stringBuffer.append(',');
                        stringBuffer.append(iCCColor.getColor(i));
                    }
                    stringBuffer.append(',');
                    stringBuffer.append(f);
                    stringBuffer.append(')');
                    this.textChanged(stringBuffer.toString());
                    break;
                }
                default: {
                    throw new DOMException(7, "");
                }
            }
        }

        @Override
        public void uriChanged(String string) {
            this.textChanged("url(" + string + ") none");
        }

        @Override
        public void paintChanged(short s, String string, String string2, String string3) {
            switch (s) {
                case 101: {
                    this.textChanged("none");
                    break;
                }
                case 102: {
                    this.textChanged("currentcolor");
                    break;
                }
                case 1: {
                    this.textChanged(string2);
                    break;
                }
                case 2: {
                    this.textChanged(string2 + ' ' + string3);
                    break;
                }
                case 107: {
                    this.textChanged("url(" + string + ')');
                    break;
                }
                case 103: {
                    this.textChanged("url(" + string + ") none");
                    break;
                }
                case 104: {
                    this.textChanged("url(" + string + ") currentcolor");
                    break;
                }
                case 105: {
                    this.textChanged("url(" + string + ") " + string2);
                    break;
                }
                case 106: {
                    this.textChanged("url(" + string + ") " + string2 + ' ' + string3);
                }
            }
        }
    }

    public static interface PaintModificationHandler
    extends CSSOMSVGColor.ModificationHandler {
        public void uriChanged(String var1);

        public void paintChanged(short var1, String var2, String var3, String var4);
    }
}

