/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.events.PageImageEvent;
import org.icepdf.core.events.PageLoadingEvent;
import org.icepdf.core.events.PageLoadingListener;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageReference
implements Callable<BufferedImage> {
    private static final Logger logger = Logger.getLogger(ImageReference.class.toString());
    protected static boolean useProxy = Defs.booleanProperty("org.icepdf.core.imageProxy", true);
    protected FutureTask<BufferedImage> futureTask;
    protected ImageStream imageStream;
    protected GraphicsState graphicsState;
    protected Resources resources;
    protected BufferedImage image;
    protected Reference reference;
    protected int imageIndex;
    protected Page parentPage;

    protected ImageReference(ImageStream imageStream, GraphicsState graphicsState, Resources resources, int imageIndex, Page parentPage) {
        this.imageStream = imageStream;
        this.graphicsState = graphicsState;
        this.resources = resources;
        this.imageIndex = imageIndex;
        this.parentPage = parentPage;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract BufferedImage getImage();

    public void drawImage(Graphics2D aG, int aX, int aY, int aW, int aH) {
        BufferedImage image = this.getImage();
        if (image != null) {
            try {
                aG.drawImage(image, aX, aY, aW, aH, null);
            }
            catch (Throwable e) {
                logger.warning("There was a problem painting image, falling back to scaled instance " + this.imageStream.getPObjectReference() + "(" + this.imageStream.getWidth() + "x" + this.imageStream.getHeight() + ")");
                int width = image.getWidth(null);
                if (width > 1000 && width < 2000) {
                    width = 1000;
                } else if (width > 2000) {
                    width = 2000;
                }
                Image scaledImage = image.getScaledInstance(width, -1, 4);
                image.flush();
                aG.drawImage(scaledImage, aX, aY, aW, aH, null);
                this.image = ImageUtility.createBufferedImage(scaledImage);
            }
        }
    }

    protected BufferedImage createImage() {
        try {
            if (this.futureTask != null) {
                this.image = this.futureTask.get();
            }
            if (this.image == null) {
                this.image = (BufferedImage)this.call();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.fine("Image loading interrupted");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Image loading execution exception", e);
        }
        return this.image;
    }

    public ImageStream getImageStream() {
        return this.imageStream;
    }

    public boolean isImage() {
        return this.image != null;
    }

    protected void notifyPageImageLoadedEvent(long duration, boolean interrupted) {
        if (this.parentPage != null) {
            PageImageEvent pageLoadingEvent = new PageImageEvent(this.parentPage, this.imageIndex, this.parentPage.getImageCount(), duration, interrupted);
            List<PageLoadingListener> pageLoadingListeners = this.parentPage.getPageLoadingListeners();
            for (int i = pageLoadingListeners.size() - 1; i >= 0; --i) {
                PageLoadingListener client = pageLoadingListeners.get(i);
                client.pageImageLoaded(pageLoadingEvent);
            }
        }
    }

    protected void notifyImagePageEvents(long duration) {
        this.notifyPageImageLoadedEvent(duration, this.image == null);
        if (this.parentPage != null && this.imageIndex == this.parentPage.getImageCount() && this.parentPage.isPageInitialized() && this.parentPage.isPagePainted()) {
            this.notifyPageLoadingEnded();
        }
    }

    protected void notifyPageLoadingEnded() {
        if (this.parentPage != null) {
            PageLoadingEvent pageLoadingEvent = new PageLoadingEvent(this.parentPage, this.parentPage.isInitiated());
            List<PageLoadingListener> pageLoadingListeners = this.parentPage.getPageLoadingListeners();
            for (int i = pageLoadingListeners.size() - 1; i >= 0; --i) {
                PageLoadingListener client = pageLoadingListeners.get(i);
                client.pageLoadingEnded(pageLoadingEvent);
            }
        }
    }
}

