/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.ColorStyle;
import com.jidesoft.editor.EffectStyle;
import com.jidesoft.editor.FontStyle;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class SyntaxStyle
implements ColorStyle,
FontStyle,
EffectStyle {
    private int \u0105;
    private Color \u0108;
    private Color \u0103;
    private int \u0106;
    private Color \u0109;
    private Color \u0107;
    private transient Font \u0102;
    private transient Font \u0104;
    private transient FontMetrics \u0101;

    public SyntaxStyle() {
    }

    public SyntaxStyle(Color color, int n2) {
        this.\u0108 = color;
        this.\u0105 = n2;
    }

    public SyntaxStyle(int n2, Color color) {
        this.\u0106 = n2;
        this.\u0109 = color;
    }

    public SyntaxStyle(int n2, Color color, Color color2) {
        this.\u0106 = n2;
        this.\u0109 = color;
        this.\u0107 = color2;
    }

    public SyntaxStyle(Color color) {
        this.\u0103 = color;
    }

    public SyntaxStyle(Color color, Color color2) {
        this.\u0103 = color;
        this.\u0108 = color2;
    }

    public SyntaxStyle(Color color, Color color2, Color color3) {
        this.\u0103 = color;
        this.\u0108 = color2;
        this.\u0107 = color3;
    }

    @Override
    public Color getForeground() {
        return this.\u0108;
    }

    @Override
    public void setForeground(Color color) {
        this.\u0108 = color;
    }

    @Override
    public int getFontStyle() {
        return this.\u0105;
    }

    @Override
    public void setFontStyle(int n2) {
        this.\u0105 = n2;
        this.\u0101();
    }

    private void \u0101() {
        this.\u0102 = null;
        this.\u0104 = null;
        this.\u0101 = null;
    }

    public boolean isItalic() {
        return (this.getFontStyle() & 2) != 0;
    }

    public boolean isBold() {
        return (this.getFontStyle() & 1) != 0;
    }

    public boolean isPlain() {
        return this.getFontStyle() == 0;
    }

    @Override
    public Color getBackground() {
        return this.\u0103;
    }

    @Override
    public void setBackground(Color color) {
        this.\u0103 = color;
    }

    @Override
    public Color getEffectColor() {
        if (this.getEffect() != 0 && this.\u0109 == null) {
            return Color.RED;
        }
        return this.\u0109;
    }

    @Override
    public void setEffectColor(Color color) {
        this.\u0109 = color;
    }

    @Override
    public int getEffect() {
        return this.\u0106;
    }

    @Override
    public void setEffect(int n2) {
        this.\u0106 = n2;
    }

    @Override
    public Color getStripeColor() {
        return this.\u0107;
    }

    @Override
    public void setStripeColor(Color color) {
        this.\u0107 = color;
    }

    public Font getStyledFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font param must not be null");
        }
        if (font.equals(this.\u0102)) {
            return this.\u0104;
        }
        return font.deriveFont(this.getFontStyle());
    }

    public FontMetrics getFontMetrics(Font font, Graphics graphics) {
        if (font == null) {
            throw new NullPointerException("font param must not be null");
        }
        if (font.equals(this.\u0102) && this.\u0101 != null) {
            return this.\u0101;
        }
        this.\u0102 = font;
        this.\u0104 = font.deriveFont(this.getFontStyle());
        this.\u0101 = graphics.getFontMetrics(this.\u0104);
        return this.\u0101;
    }

    public void setGraphicsFlags(Graphics graphics, Font font) {
        Font font2 = this.getStyledFont(font);
        graphics.setFont(font2);
        graphics.setColor(this.\u0108);
    }

    public String toString() {
        return this.getClass().getName() + "[color=" + this.\u0108 + (this.isItalic() ? ",italic" : "") + (this.isBold() ? ",bold" : "") + "]";
    }

    public void paintMarker(Graphics graphics, int n2, int n3, int n4, FontMetrics fontMetrics) {
        Color color = graphics.getColor();
        if (this.getBackground() != null) {
            if (SystemInfo.isJdk6u14Above()) {
                graphics.setXORMode(Color.WHITE);
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect(n2, n4 + fontMetrics.getLeading() + fontMetrics.getMaxDescent(), n3 - n2, fontMetrics.getHeight());
            if (SystemInfo.isJdk6u14Above()) {
                graphics.setPaintMode();
            }
        }
        this.\u0101(graphics, n2, n3, n4, fontMetrics);
        graphics.setColor(color);
    }

    private void \u0101(Graphics graphics, int n2, int n3, int n4, FontMetrics fontMetrics) {
        switch (this.getEffect()) {
            case 2: {
                graphics.setColor(this.getEffectColor());
                int n5 = n4 + fontMetrics.getHeight() + 1;
                for (int i2 = n2; i2 < n3; i2 += 4) {
                    if (i2 + 2 <= n3 - 1) {
                        graphics.drawLine(i2, n5 + 2, i2 + 2, n5);
                    }
                    if (i2 + 4 > n3 - 1) continue;
                    graphics.drawLine(i2 + 3, n5 + 1, i2 + 4, n5 + 2);
                }
                break;
            }
            case 1: {
                graphics.setColor(this.getEffectColor());
                int n6 = n4 + fontMetrics.getHeight() + 1;
                graphics.drawLine(n2, n6, n3, n6);
                break;
            }
            case 3: {
                graphics.setColor(this.getEffectColor());
                int n7 = n4 + fontMetrics.getLeading() + fontMetrics.getMaxDescent() + fontMetrics.getHeight() / 2 + 1;
                graphics.drawLine(n2, n7, n3, n7);
                break;
            }
            case 4: {
                graphics.setColor(this.getEffectColor());
                graphics.drawRect(n2, n4 + fontMetrics.getLeading() + fontMetrics.getMaxDescent(), n3 - n2, fontMetrics.getHeight() - 1);
                break;
            }
        }
    }
}

