/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.render.PieLabelRenderer2D;
import com.jidesoft.chart.render.PieSegmentRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Positionable;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class DefaultPieSegmentRenderer
extends AbstractPieSegmentRenderer
implements PieSegmentRenderer2D {
    @Override
    public void renderSegments(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n2, int[] nArray) {
        Object object;
        ChartStyle chartStyle;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        ChartStyle chartStyle2 = chartStyle = chart == null || chart.getStyle(chartModel) == null ? new ChartStyle(Color.GRAY) : chart.getStyle(chartModel);
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.GRAY);
        }
        int n3 = point.x;
        int n4 = point.y;
        int n5 = (int)(1.0 * (double)n2);
        int n6 = 2 * n5;
        int n7 = (int)(0.2 * (double)n5);
        int n8 = n3 - n5;
        int n9 = n4 - n5;
        float f2 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Object object2;
            object = chart.getSelectionsForModel(chartModel);
            boolean bl = object.isSelectedIndex(i2);
            ChartPoint chartPoint = (ChartPoint)chartModel.getPoint(i2);
            boolean bl2 = chart.isRolloverEnabled() && chartPoint.equals(chart.getCurrentChartPoint());
            float f3 = f2 + (float)nArray[i2] / 2.0f;
            int n10 = chartStyle.isPieSegmentsAlwaysExploded() || bl && chart.isSelectionShowsExplodedSegments() ? (int)((double)n7 * Math.cos(Math.toRadians(f3))) : 0;
            int n11 = chartStyle.isPieSegmentsAlwaysExploded() || bl && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n7 * Math.sin(Math.toRadians(f3)))) : 0;
            Paint paint = chartStyle.getBarPaint();
            Highlight highlight = chartPoint.getHighlight();
            Positionable positionable = chartPoint.getX();
            if (highlight == null && positionable instanceof ChartCategory) {
                object2 = (ChartCategory)positionable;
                highlight = ((ChartCategory)object2).getHighlight();
            }
            if (highlight != null && (object2 = chart.getHighlightStyle(highlight)) != null) {
                paint = ((ChartStyle)object2).getBarPaint();
            }
            object2 = new Arc2D.Double(n8, n9, n6, n6, f2, nArray[i2], 2);
            Arc2D.Double double_ = new Arc2D.Double(n8, n9, n6, n6, f2, nArray[i2], 0);
            Paint paint2 = this.createSegmentPaint(chart, chartPoint, chartStyle, bl, bl2, (Shape)object2);
            if (paint2 != null) {
                paint = paint2;
            }
            if (bl2) {
                if (paint instanceof Color) {
                    paint = ColorFactory.intensify2((Color)paint, 50);
                } else if (paint instanceof TexturePaint) {
                    paint = this.modify((TexturePaint)paint);
                }
            }
            graphics2D.setPaint(paint);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n10, n11);
            graphics2D.transform(affineTransform);
            PointDescriptor pointDescriptor = new PointDescriptor(chartPoint, i2, chartModel);
            this.recordSegment(affineTransform.createTransformedShape((Shape)object2), pointDescriptor);
            graphics2D.fill((Shape)object2);
            if (bl) {
                graphics2D.setColor(this.getSelectionColor());
            } else {
                graphics2D.setColor(this.getOutlineColor());
            }
            f2 += (float)nArray[i2];
            graphics2D.translate(-n10, -n11);
        }
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines(false, graphics2D, chart, chartModel, point, n5, nArray, chartStyle);
        }
        this.renderOutlines(true, graphics2D, chart, chartModel, point, n5, nArray, chartStyle);
        PieLabelRenderer pieLabelRenderer = this.getPieLabelRenderer();
        if (pieLabelRenderer != null) {
            object = this.getLabelGraphics();
            pieLabelRenderer.renderLabels((Graphics)(object == null ? graphics : object), chart, chartModel, point, n6, n6, nArray, chartStyle);
        }
        graphics2D.dispose();
    }

    @Override
    public void renderSegments(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, float f2, float[] fArray) {
        Object object;
        Object object2;
        ChartStyle chartStyle;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        ChartStyle chartStyle2 = chartStyle = chart == null || chart.getStyle(chartModel) == null ? new ChartStyle(Color.GRAY) : chart.getStyle(chartModel);
        if (chartStyle == null) {
            chartStyle = new ChartStyle(Color.GRAY);
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        float f3 = 1.0f * f2;
        double d4 = 2.0f * f3;
        double d5 = 0.2 * (double)f3;
        double d6 = d2 - (double)f3;
        double d7 = d3 - (double)f3;
        double d8 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            Arc2D.Double double_;
            boolean bl;
            Paint paint;
            Object object3;
            object2 = chart.getSelectionsForModel(chartModel);
            boolean bl2 = object2 != null && object2.isSelectedIndex(i2);
            object = chartModel.getPoint(i2);
            Object object4 = chartStyle.getBarPaint();
            Highlight highlight = null;
            if (object instanceof Highlightable) {
                highlight = ((Highlightable)object).getHighlight();
            }
            Positionable positionable = object.getX();
            if (highlight == null && positionable instanceof ChartCategory) {
                object3 = (ChartCategory)positionable;
                highlight = ((ChartCategory)object3).getHighlight();
            }
            if (highlight != null && (object3 = chart.getHighlightStyle(highlight)) != null) {
                object4 = ((ChartStyle)object3).getBarPaint();
            }
            if ((paint = this.createSegmentPaint(chart, (Chartable)object, chartStyle, bl2, bl = chart.isRolloverEnabled() && object.equals(chart.getCurrentChartPoint()), double_ = new Arc2D.Double(d6, d7, d4, d4, d8, fArray[i2], 2))) != null) {
                object4 = paint;
            }
            if (bl) {
                if (object4 instanceof Color) {
                    object4 = ColorFactory.intensify2((Color)object4, 50);
                } else if (object4 instanceof TexturePaint) {
                    object4 = this.modify((TexturePaint)object4);
                }
            }
            double d9 = d8 + (double)fArray[i2] / 2.0;
            int n2 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)(d5 * Math.cos(Math.toRadians(d9))) : 0;
            int n3 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)(-d5 * Math.sin(Math.toRadians(d9))) : 0;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(n2, n3);
            graphics2D2.transform(affineTransform);
            PointDescriptor pointDescriptor = new PointDescriptor((Chartable)object, i2, chartModel);
            this.recordSegment(affineTransform.createTransformedShape(double_), pointDescriptor);
            graphics2D2.setPaint((Paint)object4);
            graphics2D2.setComposite(AlphaComposite.Src);
            graphics2D2.fill(double_);
            if (bl2) {
                graphics2D2.setColor(this.getSelectionColor());
            } else {
                graphics2D2.setColor(this.getOutlineColor());
            }
            d8 += (double)fArray[i2];
            graphics2D2.translate(-n2, -n3);
        }
        if (this.isAlwaysShowOutlines()) {
            this.renderOutlines2D(false, graphics2D2, chart, chartModel, point2D, f3, fArray, chartStyle);
        }
        this.renderOutlines2D(true, graphics2D2, chart, chartModel, point2D, f3, fArray, chartStyle);
        PieLabelRenderer pieLabelRenderer = this.getPieLabelRenderer();
        if (pieLabelRenderer != null) {
            if (pieLabelRenderer instanceof PieLabelRenderer2D) {
                object2 = (PieLabelRenderer2D)pieLabelRenderer;
                Graphics2D graphics2D3 = (Graphics2D)this.getLabelGraphics();
                for (Object object5 : object = (Object)Arrays.copyOf(fArray, fArray.length)) {
                }
                object2.renderLabels(graphics2D3 == null ? graphics2D2 : graphics2D3, chart, chartModel, point2D, d4, d4, fArray, chartStyle);
            } else {
                throw new IllegalStateException("To use a PieSegmentRenderer2D, you must also use a PieLabelRenderer2D");
            }
        }
        graphics2D2.dispose();
    }
}

