/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableToChartAdapter
implements AnnotatedChartModel,
TableModelListener {
    public static final String PROPERTY_X_COLUMN = "XColumn";
    public static final String PROPERTY_Y_COLUMN = "YColumn";
    private TableModel \u01d3;
    private String \u01db;
    private List<Annotation> \u01c8 = new ArrayList<Annotation>();
    private final List<ChartModelListener> \u01ce = new CopyOnWriteArrayList<ChartModelListener>();
    private Map<Integer, Highlight> \u01ca = new HashMap<Integer, Highlight>();
    private PropertyChangeSupport \u01cc = new PropertyChangeSupport(this);
    private Map<Integer, ChartPoint> \u01d0 = new HashMap<Integer, ChartPoint>();
    private CategoryRange<?> \u01cb = new CategoryRange();
    private CategoryRange<?> \u01cd = new CategoryRange();
    private boolean \u01d1 = false;
    private double \u01d9;
    private double \u01d7;
    private double \u01d8;
    private double \u01d6;
    private boolean \u01da = false;
    private int \u01d5 = 0;
    private int \u01d2 = 1;
    private Integer \u01c9 = null;
    private Integer \u01cf = null;

    public TableToChartAdapter(String string, TableModel tableModel) {
        this.setDelegate(tableModel);
        this.\u01db = string;
    }

    public void setDelegate(TableModel tableModel) {
        if (this.\u01d3 != null) {
            this.\u01d3.removeTableModelListener(this);
        }
        this.\u01d3 = tableModel;
        if (this.\u01d3 != null) {
            this.\u01d3.addTableModelListener(this);
        }
        this.update();
    }

    public TableModel getDelegate() {
        return this.\u01d3;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.\u01cc.addPropertyChangeListener(propertyChangeListener);
    }

    public void addHighlight(int n2, Highlight highlight) {
        this.\u01ca.put(n2, highlight);
        this.\u01d0.remove(n2);
    }

    public void removeHighlight(int n2) {
        this.\u01ca.remove(n2);
        this.\u01d0.remove(n2);
    }

    public void setRowInterval(Integer n2, Integer n3) {
        assert (n3 == null || n2 == null || n3 >= n2);
        this.\u01c9 = n2;
        this.\u01cf = n3;
        this.update();
    }

    public Integer getMinRow() {
        return this.\u01c9;
    }

    public void setMinRow(Integer n2) {
        this.\u01c9 = n2;
        this.update();
    }

    public Integer getMaxRow() {
        return this.\u01cf;
    }

    public void setMaxRow(Integer n2) {
        this.\u01cf = n2;
        this.update();
    }

    @Override
    public String getName() {
        return this.\u01db;
    }

    public int getXColumn() {
        return this.\u01d5;
    }

    public void setXColumn(int n2) {
        int n3 = this.\u01d5;
        this.\u01d5 = n2;
        this.\u01cc.firePropertyChange(PROPERTY_X_COLUMN, n3, n2);
        this.update();
    }

    public int getYColumn() {
        return this.\u01d2;
    }

    public void setYColumn(int n2) {
        int n3 = this.\u01d2;
        this.\u01d2 = n2;
        this.\u01cc.firePropertyChange(PROPERTY_Y_COLUMN, n3, n2);
        this.update();
    }

    private void \u010e() {
        this.\u01d8 = Double.MIN_VALUE;
        this.\u01d9 = Double.MAX_VALUE;
        this.\u01d6 = Double.MIN_VALUE;
        this.\u01d7 = Double.MAX_VALUE;
        int n2 = this.getPointCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Chartable chartable = this.getPoint(i2);
            double d2 = chartable.getX().position();
            double d3 = chartable.getY().position();
            if (d2 < this.\u01d9) {
                this.\u01d9 = d2;
            }
            if (d2 > this.\u01d8) {
                this.\u01d8 = d2;
            }
            if (d3 < this.\u01d7) {
                this.\u01d7 = d3;
            }
            if (!(d3 > this.\u01d6)) continue;
            this.\u01d6 = d3;
        }
        this.\u01d1 = true;
    }

    public Range<?> getXRange() {
        if (!this.\u01d1) {
            this.\u010e();
        }
        if (this.\u01cb.size() == 0.0) {
            return new NumericRange(this.\u01d9, this.\u01d8);
        }
        return this.\u01cb;
    }

    public Range<?> getYRange() {
        if (!this.\u01d1) {
            this.\u010e();
        }
        if (this.\u01cd.size() == 0.0) {
            return new NumericRange(this.\u01d7, this.\u01d6);
        }
        return this.\u01cd;
    }

    @Override
    public Chartable getPoint(int n2) {
        ChartPoint chartPoint = this.\u01d0.get(n2);
        if (chartPoint == null && n2 < this.getPointCount()) {
            Serializable serializable;
            Object object;
            Positionable positionable;
            int n3 = this.\u01c9 == null ? 0 : this.\u01c9;
            Object object2 = this.\u01d3.getValueAt(n3 + n2, this.\u01d5);
            Object object3 = this.\u01d3.getValueAt(n3 + n2, this.\u01d2);
            if (object2 == null) {
                positionable = null;
            } else if (object2 instanceof Number) {
                object = (Number)object2;
                positionable = new RealPosition(((Number)object).doubleValue());
            } else {
                positionable = new ChartCategory<Object>(object2);
                this.\u01cb.add((Category<?>)positionable);
            }
            if (object3 == null) {
                object = null;
            } else if (object3 instanceof Number) {
                serializable = (Number)object3;
                object = new RealPosition(serializable.doubleValue());
            } else {
                object = new ChartCategory<Object>(object3);
                this.\u01cd.add((ChartCategory)object);
            }
            chartPoint = new ChartPoint(positionable, (Positionable)object);
            serializable = this.\u01ca.get(n2);
            if (serializable != null) {
                chartPoint.setHighlight((Highlight)serializable);
            }
            this.\u01d0.put(n2, chartPoint);
        }
        return chartPoint;
    }

    @Override
    public int getPointCount() {
        if (this.\u01d3 == null) {
            return 0;
        }
        if (this.\u01c9 == null || this.\u01cf == null) {
            return this.\u01d3.getRowCount();
        }
        if (this.\u01c9 < 0 || this.\u01cf < 0) {
            return 0;
        }
        return this.\u01cf - this.\u01c9 + 1;
    }

    @Override
    public boolean isCyclical() {
        return this.\u01da;
    }

    public void setCyclical(boolean bl) {
        this.\u01da = bl;
    }

    @Override
    public int getAnnotationCount() {
        return this.\u01c8.size();
    }

    public void clearAnnotations() {
        this.\u01c8.clear();
    }

    @Override
    public Annotation getAnnotation(int n2) {
        return this.\u01c8.get(n2);
    }

    public void addAnnotation(Annotation annotation) {
        this.\u01c8.add(annotation);
    }

    public void removeAnnotation(Annotation annotation) {
        this.\u01c8.remove(annotation);
    }

    @Override
    public boolean isAnnotationsVisible() {
        return true;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.\u01ce.contains(chartModelListener)) {
            this.\u01ce.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.\u01ce.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public void update() {
        this.\u01d0.clear();
        this.\u01cb = new CategoryRange();
        this.\u01cd = new CategoryRange();
        this.\u01d1 = false;
        this.fireModelChanged();
    }

    protected void fireModelChanged() {
        for (ChartModelListener chartModelListener : this.\u01ce) {
            chartModelListener.chartModelChanged();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.update();
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(TableToChartAdapter.class.getName(), 4096);
        }
    }
}

