/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.CpInfo;
import com.yworks.yguard.obf.classfile.Utf8CpInfo;
import java.util.Enumeration;
import java.util.Vector;

public class ConstantPool {
    private ClassFile myClassFile;
    private Vector pool;

    public ConstantPool(ClassFile classFile, CpInfo[] cpInfo) {
        this.myClassFile = classFile;
        int length = cpInfo.length;
        this.pool = new Vector(length);
        this.pool.setSize(length);
        for (int i = 0; i < length; ++i) {
            this.pool.setElementAt(cpInfo[i], i);
        }
    }

    public Enumeration elements() {
        return this.pool.elements();
    }

    public int length() {
        return this.pool.size();
    }

    public CpInfo getCpEntry(int i) {
        if (i < this.pool.size()) {
            return (CpInfo)this.pool.elementAt(i);
        }
        throw new IndexOutOfBoundsException("Constant Pool index out of range.");
    }

    public void updateRefCount() {
        this.walkPool(new PoolAction(){

            @Override
            public void defaultAction(CpInfo cpInfo) {
                cpInfo.resetRefCount();
            }
        });
        this.myClassFile.markUtf8Refs(this);
        this.myClassFile.markNTRefs(this);
        this.walkPool(new PoolAction(){

            @Override
            public void utf8Action(Utf8CpInfo cpInfo) {
                if (cpInfo.getRefCount() == 0) {
                    cpInfo.clearString();
                }
            }
        });
    }

    public void incRefCount(int i) {
        CpInfo cpInfo = (CpInfo)this.pool.elementAt(i);
        if (cpInfo != null) {
            cpInfo.incRefCount();
        }
    }

    public int remapUtf8To(String newString, int oldIndex) {
        this.decRefCount(oldIndex);
        return this.addUtf8Entry(newString);
    }

    public void decRefCount(int i) {
        CpInfo cpInfo = (CpInfo)this.pool.elementAt(i);
        if (cpInfo != null) {
            cpInfo.decRefCount();
        }
    }

    public int addEntry(CpInfo entry) {
        int oldLength = this.pool.size();
        this.pool.setSize(oldLength + 1);
        this.pool.setElementAt(entry, oldLength);
        return oldLength;
    }

    private int addUtf8Entry(String s) {
        Utf8CpInfo entry;
        Object o;
        int i;
        for (i = 0; i < this.pool.size(); ++i) {
            o = this.pool.elementAt(i);
            if (!(o instanceof Utf8CpInfo) || !(entry = (Utf8CpInfo)o).getString().equals(s)) continue;
            entry.incRefCount();
            return i;
        }
        for (i = 0; i < this.pool.size(); ++i) {
            o = this.pool.elementAt(i);
            if (!(o instanceof Utf8CpInfo) || (entry = (Utf8CpInfo)o).getRefCount() != 0) continue;
            entry.setString(s);
            entry.incRefCount();
            return i;
        }
        return this.addEntry(new Utf8CpInfo(s));
    }

    private void walkPool(PoolAction pa) {
        Enumeration enumeration = this.pool.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (o instanceof Utf8CpInfo) {
                pa.utf8Action((Utf8CpInfo)o);
                continue;
            }
            if (!(o instanceof CpInfo)) continue;
            pa.defaultAction((CpInfo)o);
        }
    }

    class PoolAction {
        PoolAction() {
        }

        public void utf8Action(Utf8CpInfo cpInfo) {
            this.defaultAction(cpInfo);
        }

        public void defaultAction(CpInfo cpInfo) {
        }
    }
}

