/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.Tools;
import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ExceptionInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CodeAttrInfo
extends AttrInfo {
    public static final int CONSTANT_FIELD_SIZE = 12;
    private int u2maxStack;
    private int u2maxLocals;
    private int u4codeLength;
    private byte[] code;
    private int u2exceptionTableLength;
    private ExceptionInfo[] exceptionTable;
    protected int u2attributesCount;
    protected AttrInfo[] attributes;

    protected CodeAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected int getAttrInfoLength() {
        int length = 12 + this.u4codeLength + this.u2exceptionTableLength * 8;
        for (int i = 0; i < this.u2attributesCount; ++i) {
            length += 6 + this.attributes[i].getAttrInfoLength();
        }
        return length;
    }

    @Override
    protected String getAttrName() {
        return "Code";
    }

    @Override
    protected void trimAttrsExcept(String[] keepAttrs) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (Tools.isInArray(this.attributes[i].getAttrName(), keepAttrs)) {
                this.attributes[i].trimAttrsExcept(keepAttrs);
                continue;
            }
            this.attributes[i] = null;
        }
        AttrInfo[] left = new AttrInfo[this.attributes.length];
        int j = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] == null) continue;
            left[j++] = this.attributes[i];
        }
        this.attributes = new AttrInfo[j];
        System.arraycopy(left, 0, this.attributes, 0, j);
        this.u2attributesCount = j;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        int i;
        this.u2maxStack = din.readUnsignedShort();
        this.u2maxLocals = din.readUnsignedShort();
        this.u4codeLength = din.readInt();
        this.code = new byte[this.u4codeLength];
        din.readFully(this.code);
        this.u2exceptionTableLength = din.readUnsignedShort();
        this.exceptionTable = new ExceptionInfo[this.u2exceptionTableLength];
        for (i = 0; i < this.u2exceptionTableLength; ++i) {
            this.exceptionTable[i] = ExceptionInfo.create(din);
        }
        this.u2attributesCount = din.readUnsignedShort();
        this.attributes = new AttrInfo[this.u2attributesCount];
        for (i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i] = AttrInfo.create(din, this.owner);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        int i;
        dout.writeShort(this.u2maxStack);
        dout.writeShort(this.u2maxLocals);
        dout.writeInt(this.u4codeLength);
        dout.write(this.code);
        dout.writeShort(this.u2exceptionTableLength);
        for (i = 0; i < this.u2exceptionTableLength; ++i) {
            this.exceptionTable[i].write(dout);
        }
        dout.writeShort(this.u2attributesCount);
        for (i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].write(dout);
        }
    }
}

