/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import oracle.xml.common.format.DecimalFormatProperties;
import oracle.xml.common.format.NumberFormatter;
import oracle.xml.common.format.Picture;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class FNNumberFormat
extends OXMLFunction {
    private static final String FUNCTION_NAME = "format-number";
    private int NUMBER_ARGS;
    private int ERROR = 1;
    NumberFormatter<XQException> FORMATTER = new NumberFormatter<XQException>(){

        @Override
        protected XQException createInvalidPictureStringException(String string) {
            return new XQException("FODF1310: " + string);
        }
    };

    public FNNumberFormat(int n) {
        this.NUMBER_ARGS = n;
    }

    @Override
    public String getFunctionName() {
        return FUNCTION_NAME;
    }

    @Override
    public int getNumberArgs() {
        return this.NUMBER_ARGS;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(1, 1);
    }

    @Override
    public OXMLSequenceType getArgType(int n) {
        switch (n) {
            case 0: {
                return OXMLSequenceType.NUMERIC_ZERO_OR_MORE;
            }
            case 1: {
                return OXMLSequenceType.getConstantType(1, 1);
            }
        }
        return OXMLSequenceType.getConstantType(2, 1);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length == 2) {
            return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
        }
        if (oXMLSequenceArray.length != 3) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[0]);
        OXMLItem oXMLItem2 = FNUtil.getSingleItem(oXMLSequenceArray[1]);
        String string = oXMLItem2.getString();
        oXMLItem2 = FNUtil.getEmptyOrSingleItem(oXMLSequenceArray[2]);
        String string2 = oXMLItem2.getString();
        try {
            String string3 = this.format(oXMLItem, string, string2, (XSLTContext)oXMLFunctionContext);
            OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
            oXMLItem3.setString(OXMLSequenceType.TSTRING, string3);
            oXMLSequence.appendItem(oXMLItem3);
            return oXMLSequence;
        }
        catch (XSLException xSLException) {
            throw new XQException(xSLException.getMessage());
        }
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        OXMLItem oXMLItem2 = FNUtil.getSingleItem(oXMLSequence2);
        String string = oXMLItem2.getString();
        try {
            String string2 = this.format(oXMLItem, string, null, oXMLFunctionContext);
            OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
            oXMLItem3.setString(OXMLSequenceType.TSTRING, string2);
            oXMLSequence3.appendItem(oXMLItem3);
            return oXMLSequence3;
        }
        catch (XSLException xSLException) {
            throw new XQException(xSLException.getMessage());
        }
    }

    public String format(OXMLItem oXMLItem, String string, String string2, OXMLFunctionContext oXMLFunctionContext) throws XQException, XSLException {
        Serializable serializable;
        Object object;
        XSLTDecimalFormatProperties xSLTDecimalFormatProperties;
        if (oXMLFunctionContext instanceof XPathRuntimeContext) {
            if (string2 == null) {
                xSLTDecimalFormatProperties = oXMLFunctionContext instanceof XSLTContext ? new XSLTDecimalFormatProperties(((XSLTContext)oXMLFunctionContext).getDecimalFormat()) : new XSLTDecimalFormatProperties(((XPathRuntimeContext)oXMLFunctionContext).getDecimalFormatSymbols());
            } else {
                XPathRuntimeContext xPathRuntimeContext = (XPathRuntimeContext)oXMLFunctionContext;
                object = xPathRuntimeContext.getContextNode();
                serializable = !(object instanceof XMLElement) ? (XMLElement)((XMLNode)object).getParentNode() : (XMLElement)object;
                NSNameImpl nSNameImpl = XPathSequence.resolveQname(string2, (NSResolver)((Object)serializable), xPathRuntimeContext.getError());
                if (nSNameImpl == null) {
                    xPathRuntimeContext.getError().error1(22132, this.ERROR, string2);
                }
                xSLTDecimalFormatProperties = oXMLFunctionContext instanceof XSLTContext ? new XSLTDecimalFormatProperties(((XSLTContext)oXMLFunctionContext).getDecimalFormat(nSNameImpl)) : new XSLTDecimalFormatProperties(xPathRuntimeContext.getDecimalFormatSymbols());
            }
        } else {
            xSLTDecimalFormatProperties = new XSLTDecimalFormatProperties(null);
        }
        if (oXMLItem == null) {
            return xSLTDecimalFormatProperties.getNan();
        }
        int n = oXMLItem.getPrimitiveType();
        object = this.FORMATTER.parsePicture(string, xSLTDecimalFormatProperties);
        serializable = new StringBuilder();
        switch (n) {
            case 1: {
                return xSLTDecimalFormatProperties.getNan();
            }
            case 3: {
                this.FORMATTER.formatFloat(oXMLItem.getFloat(), (Picture)object, xSLTDecimalFormatProperties, (StringBuilder)serializable, string);
                break;
            }
            case 4: {
                this.FORMATTER.formatDouble(oXMLItem.getDouble(), (Picture)object, xSLTDecimalFormatProperties, (StringBuilder)serializable, string);
                break;
            }
            case 22: {
                this.FORMATTER.formatLong(oXMLItem.getInt(), (Picture)object, xSLTDecimalFormatProperties, (StringBuilder)serializable, string);
                break;
            }
            default: {
                this.FORMATTER.formatDecimal(oXMLItem.getDecimal(), (Picture)object, xSLTDecimalFormatProperties, (StringBuilder)serializable, string);
            }
        }
        return ((StringBuilder)serializable).toString();
    }

    class XSLTDecimalFormatProperties
    extends DecimalFormatProperties<XQException> {
        public XSLTDecimalFormatProperties(DecimalFormatSymbols decimalFormatSymbols) {
            if (decimalFormatSymbols != null) {
                this.decimalSep = decimalFormatSymbols.getDecimalSeparator();
                this.groupingSep = decimalFormatSymbols.getGroupingSeparator();
                this.minusSign = decimalFormatSymbols.getMinusSign();
                this.percent = decimalFormatSymbols.getPercent();
                this.perMille = decimalFormatSymbols.getPerMill();
                this.zeroDigit = decimalFormatSymbols.getZeroDigit();
                this.digit = decimalFormatSymbols.getDigit();
                this.patternSep = decimalFormatSymbols.getPatternSeparator();
                this.infinity = decimalFormatSymbols.getInfinity();
                this.nan = decimalFormatSymbols.getNaN();
            }
        }

        @Override
        protected XQException createInvalidValueForPropertyException(String string, String string2) {
            return new XQException("XQST0097: " + string2 + " = " + string);
        }

        @Override
        protected XQException createDuplicateValuesException(String string) {
            return new XQException("XQST0098: " + string);
        }

        @Override
        protected XQException createPropertyAlreadyDefinedException(String string) {
            return new XQException("XQST0114: " + string);
        }
    }
}

