-- Copyright (c) DbVis Software AB. All Rights Reserved.
SELECT 
    CU.CUSTOMER_ID                   AS ID,
    CU.FIRST_NAME||' '||CU.LAST_NAME AS NAME,
    A.ADDRESS                        AS ADDRESS,
    A.POSTAL_CODE                    AS ZIP_CODE,
    A.PHONE                          AS PHONE,
    CITY.CITY                        AS CITY,
    COUNTRY.COUNTRY                  AS COUNTRY,
    DECODE(CU.ACTIVE, 1,'Active','') AS NOTES,
    CU.STORE_ID                      AS SID
FROM 
    CUSTOMER CU 
JOIN 
    ADDRESS A 
ON 
    CU.ADDRESS_ID = A.ADDRESS_ID 
JOIN 
    CITY 
ON 
    A.CITY_ID = CITY.CITY_ID
JOIN 
    COUNTRY 
ON 
    CITY.COUNTRY_ID = COUNTRY.COUNTRY_ID;